/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.util.concurrent;

import io.logz.sender.com.google.common.annotations.GwtIncompatible;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.logz.sender.com.google.errorprone.annotations.CheckReturnValue;
import io.logz.sender.java.lang.Boolean;
import io.logz.sender.java.lang.Integer;
import io.logz.sender.java.lang.Long;
import io.logz.sender.java.lang.Runnable;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.Thread;
import io.logz.sender.java.util.Locale;
import io.logz.sender.java.util.concurrent.Executors;
import io.logz.sender.java.util.concurrent.ThreadFactory;
import io.logz.sender.java.util.concurrent.atomic.AtomicLong;

@CanIgnoreReturnValue
@GwtIncompatible
public final class ThreadFactoryBuilder
extends io.logz.sender.java.lang.Object {
    private String nameFormat = null;
    private Boolean daemon = null;
    private Integer priority = null;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler = null;
    private ThreadFactory backingThreadFactory = null;

    public ThreadFactoryBuilder setNameFormat(String nameFormat) {
        String unused = ThreadFactoryBuilder.format(nameFormat, new io.logz.sender.java.lang.Object[]{Integer.valueOf((int)0)});
        this.nameFormat = nameFormat;
        return this;
    }

    public ThreadFactoryBuilder setDaemon(boolean daemon) {
        this.daemon = Boolean.valueOf((boolean)daemon);
        return this;
    }

    public ThreadFactoryBuilder setPriority(int priority) {
        Preconditions.checkArgument(priority >= 1, (String)"io.logz.sender.Thread priority (%s) must be >= %s", priority, 1);
        Preconditions.checkArgument(priority <= 10, (String)"io.logz.sender.Thread priority (%s) must be <= %s", priority, 10);
        this.priority = Integer.valueOf((int)priority);
        return this;
    }

    public ThreadFactoryBuilder setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = Preconditions.checkNotNull(uncaughtExceptionHandler);
        return this;
    }

    public ThreadFactoryBuilder setThreadFactory(ThreadFactory backingThreadFactory) {
        this.backingThreadFactory = Preconditions.checkNotNull(backingThreadFactory);
        return this;
    }

    @CheckReturnValue
    public ThreadFactory build() {
        return ThreadFactoryBuilder.doBuild(this);
    }

    private static ThreadFactory doBuild(ThreadFactoryBuilder builder) {
        final String nameFormat = builder.nameFormat;
        final Boolean daemon = builder.daemon;
        final Integer priority = builder.priority;
        final Thread.UncaughtExceptionHandler uncaughtExceptionHandler = builder.uncaughtExceptionHandler;
        final ThreadFactory backingThreadFactory = builder.backingThreadFactory != null ? builder.backingThreadFactory : Executors.defaultThreadFactory();
        final AtomicLong count = nameFormat != null ? new AtomicLong(0L) : null;
        return new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread thread = backingThreadFactory.newThread(runnable);
                if (nameFormat != null) {
                    thread.setName(ThreadFactoryBuilder.format(nameFormat, new io.logz.sender.java.lang.Object[]{Long.valueOf((long)count.getAndIncrement())}));
                }
                if (daemon != null) {
                    thread.setDaemon(daemon.booleanValue());
                }
                if (priority != null) {
                    thread.setPriority(priority.intValue());
                }
                if (uncaughtExceptionHandler != null) {
                    thread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
                }
                return thread;
            }
        };
    }

    private static String format(String format, io.logz.sender.java.lang.Object ... args) {
        return String.format((Locale)Locale.ROOT, (String)format, (io.logz.sender.java.lang.Object[])args);
    }
}

