/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.util.concurrent;

import io.logz.sender.com.google.common.annotations.GwtIncompatible;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.base.Throwables;
import io.logz.sender.com.google.common.collect.ImmutableList;
import io.logz.sender.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.logz.sender.java.lang.Exception;
import io.logz.sender.java.lang.InterruptedException;
import io.logz.sender.java.lang.Runnable;
import io.logz.sender.java.lang.RuntimeException;
import io.logz.sender.java.lang.Throwable;
import io.logz.sender.java.util.Collection;
import io.logz.sender.java.util.List;
import io.logz.sender.java.util.concurrent.Callable;
import io.logz.sender.java.util.concurrent.ExecutionException;
import io.logz.sender.java.util.concurrent.ExecutorService;
import io.logz.sender.java.util.concurrent.Executors;
import io.logz.sender.java.util.concurrent.Future;
import io.logz.sender.java.util.concurrent.TimeUnit;
import io.logz.sender.java.util.concurrent.TimeoutException;

@CanIgnoreReturnValue
@GwtIncompatible
abstract class WrappingExecutorService
extends io.logz.sender.java.lang.Object
implements ExecutorService {
    private final ExecutorService delegate;

    protected WrappingExecutorService(ExecutorService delegate) {
        this.delegate = Preconditions.checkNotNull(delegate);
    }

    protected abstract <T extends io.logz.sender.java.lang.Object> Callable<T> wrapTask(Callable<T> var1);

    protected Runnable wrapTask(Runnable command) {
        final Callable wrapped = this.wrapTask(Executors.callable((Runnable)command, null));
        return new Runnable(){

            public void run() {
                try {
                    wrapped.call();
                }
                catch (Exception e) {
                    Throwables.throwIfUnchecked((Throwable)((Object)e));
                    throw new RuntimeException((Throwable)((Object)e));
                }
            }
        };
    }

    private <T extends io.logz.sender.java.lang.Object> ImmutableList<Callable<T>> wrapTasks(Collection<? extends Callable<T>> tasks) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Callable task : tasks) {
            builder.add((io.logz.sender.java.lang.Object)this.wrapTask(task));
        }
        return builder.build();
    }

    public final void execute(Runnable command) {
        this.delegate.execute(this.wrapTask(command));
    }

    public final <T extends io.logz.sender.java.lang.Object> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(this.wrapTask(Preconditions.checkNotNull(task)));
    }

    public final Future<?> submit(Runnable task) {
        return this.delegate.submit(this.wrapTask(task));
    }

    public final <T extends io.logz.sender.java.lang.Object> Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(this.wrapTask(task), result);
    }

    public final <T extends io.logz.sender.java.lang.Object> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(this.wrapTasks(tasks));
    }

    public final <T extends io.logz.sender.java.lang.Object> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(this.wrapTasks(tasks), timeout, unit);
    }

    public final <T extends io.logz.sender.java.lang.Object> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)this.delegate.invokeAny(this.wrapTasks(tasks));
    }

    public final <T extends io.logz.sender.java.lang.Object> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.delegate.invokeAny(this.wrapTasks(tasks), timeout, unit);
    }

    public final void shutdown() {
        this.delegate.shutdown();
    }

    public final List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    public final boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    public final boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    public final boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }
}

