/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.gson;

import io.logz.sender.com.google.gson.FieldNamingPolicy;
import io.logz.sender.com.google.gson.FieldNamingStrategy;
import io.logz.sender.com.google.gson.InstanceCreator;
import io.logz.sender.com.google.gson.JsonDeserializationContext;
import io.logz.sender.com.google.gson.JsonElement;
import io.logz.sender.com.google.gson.JsonIOException;
import io.logz.sender.com.google.gson.JsonNull;
import io.logz.sender.com.google.gson.JsonParseException;
import io.logz.sender.com.google.gson.JsonSerializationContext;
import io.logz.sender.com.google.gson.JsonSyntaxException;
import io.logz.sender.com.google.gson.LongSerializationPolicy;
import io.logz.sender.com.google.gson.TypeAdapter;
import io.logz.sender.com.google.gson.TypeAdapterFactory;
import io.logz.sender.com.google.gson.internal.ConstructorConstructor;
import io.logz.sender.com.google.gson.internal.Excluder;
import io.logz.sender.com.google.gson.internal.Primitives;
import io.logz.sender.com.google.gson.internal.Streams;
import io.logz.sender.com.google.gson.internal.bind.ArrayTypeAdapter;
import io.logz.sender.com.google.gson.internal.bind.CollectionTypeAdapterFactory;
import io.logz.sender.com.google.gson.internal.bind.DateTypeAdapter;
import io.logz.sender.com.google.gson.internal.bind.JsonAdapterAnnotationTypeAdapterFactory;
import io.logz.sender.com.google.gson.internal.bind.JsonTreeReader;
import io.logz.sender.com.google.gson.internal.bind.JsonTreeWriter;
import io.logz.sender.com.google.gson.internal.bind.MapTypeAdapterFactory;
import io.logz.sender.com.google.gson.internal.bind.ObjectTypeAdapter;
import io.logz.sender.com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import io.logz.sender.com.google.gson.internal.bind.SqlDateTypeAdapter;
import io.logz.sender.com.google.gson.internal.bind.TimeTypeAdapter;
import io.logz.sender.com.google.gson.internal.bind.TypeAdapters;
import io.logz.sender.com.google.gson.reflect.TypeToken;
import io.logz.sender.com.google.gson.stream.JsonReader;
import io.logz.sender.com.google.gson.stream.JsonToken;
import io.logz.sender.com.google.gson.stream.JsonWriter;
import io.logz.sender.com.google.gson.stream.MalformedJsonException;
import io.logz.sender.java.io.EOFException;
import io.logz.sender.java.io.IOException;
import io.logz.sender.java.io.Reader;
import io.logz.sender.java.io.StringReader;
import io.logz.sender.java.io.StringWriter;
import io.logz.sender.java.io.Writer;
import io.logz.sender.java.lang.Appendable;
import io.logz.sender.java.lang.AssertionError;
import io.logz.sender.java.lang.Class;
import io.logz.sender.java.lang.Double;
import io.logz.sender.java.lang.Float;
import io.logz.sender.java.lang.IllegalArgumentException;
import io.logz.sender.java.lang.IllegalStateException;
import io.logz.sender.java.lang.Long;
import io.logz.sender.java.lang.Number;
import io.logz.sender.java.lang.Object;
import io.logz.sender.java.lang.RuntimeException;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.lang.ThreadLocal;
import io.logz.sender.java.lang.Throwable;
import io.logz.sender.java.lang.reflect.Type;
import io.logz.sender.java.math.BigDecimal;
import io.logz.sender.java.math.BigInteger;
import io.logz.sender.java.util.ArrayList;
import io.logz.sender.java.util.Collections;
import io.logz.sender.java.util.HashMap;
import io.logz.sender.java.util.List;
import io.logz.sender.java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Gson
extends Object {
    static final boolean DEFAULT_JSON_NON_EXECUTABLE = false;
    private static final String JSON_NON_EXECUTABLE_PREFIX = "io.logz.sender.)]}'\n";
    private final ThreadLocal<Map<TypeToken<?>, FutureTypeAdapter<?>>> calls = new ThreadLocal();
    private final Map<TypeToken<?>, TypeAdapter<?>> typeTokenCache = Collections.synchronizedMap((Map)new HashMap());
    private final List<TypeAdapterFactory> factories;
    private final ConstructorConstructor constructorConstructor;
    private final boolean serializeNulls;
    private final boolean htmlSafe;
    private final boolean generateNonExecutableJson;
    private final boolean prettyPrinting;
    final JsonDeserializationContext deserializationContext = new JsonDeserializationContext(){

        @Override
        public <T extends Object> T deserialize(JsonElement json, Type typeOfT) throws JsonParseException {
            return Gson.this.fromJson(json, typeOfT);
        }
    };
    final JsonSerializationContext serializationContext = new JsonSerializationContext(){

        public JsonElement serialize(Object src) {
            return Gson.this.toJsonTree(src);
        }

        public JsonElement serialize(Object src, Type typeOfSrc) {
            return Gson.this.toJsonTree(src, typeOfSrc);
        }
    };

    public Gson() {
        this(Excluder.DEFAULT, FieldNamingPolicy.IDENTITY, Collections.emptyMap(), false, false, false, true, false, false, LongSerializationPolicy.DEFAULT, (List<TypeAdapterFactory>)Collections.emptyList());
    }

    Gson(Excluder excluder, FieldNamingStrategy fieldNamingPolicy, Map<Type, InstanceCreator<?>> instanceCreators, boolean serializeNulls, boolean complexMapKeySerialization, boolean generateNonExecutableGson, boolean htmlSafe, boolean prettyPrinting, boolean serializeSpecialFloatingPointValues, LongSerializationPolicy longSerializationPolicy, List<TypeAdapterFactory> typeAdapterFactories) {
        this.constructorConstructor = new ConstructorConstructor(instanceCreators);
        this.serializeNulls = serializeNulls;
        this.generateNonExecutableJson = generateNonExecutableGson;
        this.htmlSafe = htmlSafe;
        this.prettyPrinting = prettyPrinting;
        ArrayList factories = new ArrayList();
        factories.add((Object)TypeAdapters.JSON_ELEMENT_FACTORY);
        factories.add((Object)ObjectTypeAdapter.FACTORY);
        factories.add((Object)excluder);
        factories.addAll(typeAdapterFactories);
        factories.add((Object)TypeAdapters.STRING_FACTORY);
        factories.add((Object)TypeAdapters.INTEGER_FACTORY);
        factories.add((Object)TypeAdapters.BOOLEAN_FACTORY);
        factories.add((Object)TypeAdapters.BYTE_FACTORY);
        factories.add((Object)TypeAdapters.SHORT_FACTORY);
        factories.add((Object)TypeAdapters.newFactory(Long.TYPE, Long.class, this.longAdapter(longSerializationPolicy)));
        factories.add((Object)TypeAdapters.newFactory(Double.TYPE, Double.class, this.doubleAdapter(serializeSpecialFloatingPointValues)));
        factories.add((Object)TypeAdapters.newFactory(Float.TYPE, Float.class, this.floatAdapter(serializeSpecialFloatingPointValues)));
        factories.add((Object)TypeAdapters.NUMBER_FACTORY);
        factories.add((Object)TypeAdapters.CHARACTER_FACTORY);
        factories.add((Object)TypeAdapters.STRING_BUILDER_FACTORY);
        factories.add((Object)TypeAdapters.STRING_BUFFER_FACTORY);
        factories.add((Object)TypeAdapters.newFactory(BigDecimal.class, TypeAdapters.BIG_DECIMAL));
        factories.add((Object)TypeAdapters.newFactory(BigInteger.class, TypeAdapters.BIG_INTEGER));
        factories.add((Object)TypeAdapters.URL_FACTORY);
        factories.add((Object)TypeAdapters.URI_FACTORY);
        factories.add((Object)TypeAdapters.UUID_FACTORY);
        factories.add((Object)TypeAdapters.LOCALE_FACTORY);
        factories.add((Object)TypeAdapters.INET_ADDRESS_FACTORY);
        factories.add((Object)TypeAdapters.BIT_SET_FACTORY);
        factories.add((Object)DateTypeAdapter.FACTORY);
        factories.add((Object)TypeAdapters.CALENDAR_FACTORY);
        factories.add((Object)TimeTypeAdapter.FACTORY);
        factories.add((Object)SqlDateTypeAdapter.FACTORY);
        factories.add((Object)TypeAdapters.TIMESTAMP_FACTORY);
        factories.add((Object)ArrayTypeAdapter.FACTORY);
        factories.add((Object)TypeAdapters.CLASS_FACTORY);
        factories.add((Object)new CollectionTypeAdapterFactory(this.constructorConstructor));
        factories.add((Object)new MapTypeAdapterFactory(this.constructorConstructor, complexMapKeySerialization));
        factories.add((Object)new JsonAdapterAnnotationTypeAdapterFactory(this.constructorConstructor));
        factories.add((Object)TypeAdapters.ENUM_FACTORY);
        factories.add((Object)new ReflectiveTypeAdapterFactory(this.constructorConstructor, fieldNamingPolicy, excluder));
        this.factories = Collections.unmodifiableList((List)factories);
    }

    private TypeAdapter<Number> doubleAdapter(boolean serializeSpecialFloatingPointValues) {
        if (serializeSpecialFloatingPointValues) {
            return TypeAdapters.DOUBLE;
        }
        return new TypeAdapter<Number>(){

            @Override
            public Double read(JsonReader in) throws IOException {
                if (in.peek() == JsonToken.NULL) {
                    in.nextNull();
                    return null;
                }
                return Double.valueOf((double)in.nextDouble());
            }

            @Override
            public void write(JsonWriter out, Number value) throws IOException {
                if (value == null) {
                    out.nullValue();
                    return;
                }
                double doubleValue = value.doubleValue();
                Gson.this.checkValidFloatingPoint(doubleValue);
                out.value(value);
            }
        };
    }

    private TypeAdapter<Number> floatAdapter(boolean serializeSpecialFloatingPointValues) {
        if (serializeSpecialFloatingPointValues) {
            return TypeAdapters.FLOAT;
        }
        return new TypeAdapter<Number>(){

            @Override
            public Float read(JsonReader in) throws IOException {
                if (in.peek() == JsonToken.NULL) {
                    in.nextNull();
                    return null;
                }
                return Float.valueOf((float)((float)in.nextDouble()));
            }

            @Override
            public void write(JsonWriter out, Number value) throws IOException {
                if (value == null) {
                    out.nullValue();
                    return;
                }
                float floatValue = value.floatValue();
                Gson.this.checkValidFloatingPoint(floatValue);
                out.value(value);
            }
        };
    }

    private void checkValidFloatingPoint(double value) {
        if (Double.isNaN((double)value) || Double.isInfinite((double)value)) {
            throw new IllegalArgumentException(new StringBuilder().append(value).append((String)"io.logz.sender. is not a valid double value as per JSON specification. To override this").append((String)"io.logz.sender. behavior, use GsonBuilder.serializeSpecialFloatingPointValues() method.").toString());
        }
    }

    private TypeAdapter<Number> longAdapter(LongSerializationPolicy longSerializationPolicy) {
        if (longSerializationPolicy == LongSerializationPolicy.DEFAULT) {
            return TypeAdapters.LONG;
        }
        return new TypeAdapter<Number>(){

            @Override
            public Number read(JsonReader in) throws IOException {
                if (in.peek() == JsonToken.NULL) {
                    in.nextNull();
                    return null;
                }
                return Long.valueOf((long)in.nextLong());
            }

            @Override
            public void write(JsonWriter out, Number value) throws IOException {
                if (value == null) {
                    out.nullValue();
                    return;
                }
                out.value(value.toString());
            }
        };
    }

    public <T extends Object> TypeAdapter<T> getAdapter(TypeToken<T> type) {
        FutureTypeAdapter ongoingCall;
        TypeAdapter cached = (TypeAdapter)this.typeTokenCache.get(type);
        if (cached != null) {
            return cached;
        }
        Map threadCalls = (Map)this.calls.get();
        boolean requiresThreadLocalCleanup = false;
        if (threadCalls == null) {
            threadCalls = new HashMap();
            this.calls.set((Object)threadCalls);
            requiresThreadLocalCleanup = true;
        }
        if ((ongoingCall = (FutureTypeAdapter)threadCalls.get(type)) != null) {
            return ongoingCall;
        }
        try {
            FutureTypeAdapter<T> call = new FutureTypeAdapter<T>();
            threadCalls.put(type, call);
            for (TypeAdapterFactory factory : this.factories) {
                TypeAdapter<T> candidate = factory.create(this, type);
                if (candidate == null) continue;
                call.setDelegate(candidate);
                this.typeTokenCache.put(type, candidate);
                TypeAdapter<T> typeAdapter = candidate;
                return typeAdapter;
            }
            throw new IllegalArgumentException(new StringBuilder().append((String)"io.logz.sender.GSON cannot handle ").append(type).toString());
        }
        finally {
            threadCalls.remove(type);
            if (requiresThreadLocalCleanup) {
                this.calls.remove();
            }
        }
    }

    public <T extends Object> TypeAdapter<T> getDelegateAdapter(TypeAdapterFactory skipPast, TypeToken<T> type) {
        boolean skipPastFound = false;
        if (!this.factories.contains((Object)skipPast)) {
            skipPastFound = true;
        }
        for (TypeAdapterFactory factory : this.factories) {
            if (!skipPastFound) {
                if (factory != skipPast) continue;
                skipPastFound = true;
                continue;
            }
            TypeAdapter<T> candidate = factory.create(this, type);
            if (candidate == null) continue;
            return candidate;
        }
        throw new IllegalArgumentException(new StringBuilder().append((String)"io.logz.sender.GSON cannot serialize ").append(type).toString());
    }

    public <T extends Object> TypeAdapter<T> getAdapter(Class<T> type) {
        return this.getAdapter(TypeToken.get(type));
    }

    public JsonElement toJsonTree(Object src) {
        if (src == null) {
            return JsonNull.INSTANCE;
        }
        return this.toJsonTree(src, (Type)src.getClass());
    }

    public JsonElement toJsonTree(Object src, Type typeOfSrc) {
        JsonTreeWriter writer = new JsonTreeWriter();
        this.toJson(src, typeOfSrc, writer);
        return writer.get();
    }

    public String toJson(Object src) {
        if (src == null) {
            return this.toJson(JsonNull.INSTANCE);
        }
        return this.toJson(src, (Type)src.getClass());
    }

    public String toJson(Object src, Type typeOfSrc) {
        StringWriter writer = new StringWriter();
        this.toJson(src, typeOfSrc, (Appendable)writer);
        return writer.toString();
    }

    public void toJson(Object src, Appendable writer) throws JsonIOException {
        if (src != null) {
            this.toJson(src, (Type)src.getClass(), writer);
        } else {
            this.toJson((JsonElement)JsonNull.INSTANCE, writer);
        }
    }

    public void toJson(Object src, Type typeOfSrc, Appendable writer) throws JsonIOException {
        try {
            JsonWriter jsonWriter = this.newJsonWriter(Streams.writerForAppendable(writer));
            this.toJson(src, typeOfSrc, jsonWriter);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)((java.lang.Object)e));
        }
    }

    public void toJson(Object src, Type typeOfSrc, JsonWriter writer) throws JsonIOException {
        TypeAdapter<?> adapter = this.getAdapter(TypeToken.get(typeOfSrc));
        boolean oldLenient = writer.isLenient();
        writer.setLenient(true);
        boolean oldHtmlSafe = writer.isHtmlSafe();
        writer.setHtmlSafe(this.htmlSafe);
        boolean oldSerializeNulls = writer.getSerializeNulls();
        writer.setSerializeNulls(this.serializeNulls);
        try {
            adapter.write(writer, src);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)((java.lang.Object)e));
        }
        finally {
            writer.setLenient(oldLenient);
            writer.setHtmlSafe(oldHtmlSafe);
            writer.setSerializeNulls(oldSerializeNulls);
        }
    }

    public String toJson(JsonElement jsonElement) {
        StringWriter writer = new StringWriter();
        this.toJson(jsonElement, (Appendable)writer);
        return writer.toString();
    }

    public void toJson(JsonElement jsonElement, Appendable writer) throws JsonIOException {
        try {
            JsonWriter jsonWriter = this.newJsonWriter(Streams.writerForAppendable(writer));
            this.toJson(jsonElement, jsonWriter);
        }
        catch (IOException e) {
            throw new RuntimeException((Throwable)((java.lang.Object)e));
        }
    }

    private JsonWriter newJsonWriter(Writer writer) throws IOException {
        if (this.generateNonExecutableJson) {
            writer.write((String)"io.logz.sender.)]}'\n");
        }
        JsonWriter jsonWriter = new JsonWriter(writer);
        if (this.prettyPrinting) {
            jsonWriter.setIndent((String)"io.logz.sender.  ");
        }
        jsonWriter.setSerializeNulls(this.serializeNulls);
        return jsonWriter;
    }

    public void toJson(JsonElement jsonElement, JsonWriter writer) throws JsonIOException {
        boolean oldLenient = writer.isLenient();
        writer.setLenient(true);
        boolean oldHtmlSafe = writer.isHtmlSafe();
        writer.setHtmlSafe(this.htmlSafe);
        boolean oldSerializeNulls = writer.getSerializeNulls();
        writer.setSerializeNulls(this.serializeNulls);
        try {
            Streams.write(jsonElement, writer);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)((java.lang.Object)e));
        }
        finally {
            writer.setLenient(oldLenient);
            writer.setHtmlSafe(oldHtmlSafe);
            writer.setSerializeNulls(oldSerializeNulls);
        }
    }

    public <T extends Object> T fromJson(String json, Class<T> classOfT) throws JsonSyntaxException {
        T object = this.fromJson(json, (Type)classOfT);
        return (T)Primitives.wrap(classOfT).cast(object);
    }

    public <T extends Object> T fromJson(String json, Type typeOfT) throws JsonSyntaxException {
        if (json == null) {
            return null;
        }
        StringReader reader = new StringReader(json);
        T target = this.fromJson((Reader)reader, typeOfT);
        return target;
    }

    public <T extends Object> T fromJson(Reader json, Class<T> classOfT) throws JsonSyntaxException, JsonIOException {
        JsonReader jsonReader = new JsonReader(json);
        T object = this.fromJson(jsonReader, (Type)classOfT);
        Gson.assertFullConsumption(object, jsonReader);
        return (T)Primitives.wrap(classOfT).cast(object);
    }

    public <T extends Object> T fromJson(Reader json, Type typeOfT) throws JsonIOException, JsonSyntaxException {
        JsonReader jsonReader = new JsonReader(json);
        T object = this.fromJson(jsonReader, typeOfT);
        Gson.assertFullConsumption(object, jsonReader);
        return object;
    }

    private static void assertFullConsumption(Object obj, JsonReader reader) {
        try {
            if (obj != null && reader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonIOException((String)"io.logz.sender.JSON document was not fully consumed.");
            }
        }
        catch (MalformedJsonException e) {
            throw new JsonSyntaxException((Throwable)((java.lang.Object)e));
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)((java.lang.Object)e));
        }
    }

    public <T extends Object> T fromJson(JsonReader reader, Type typeOfT) throws JsonIOException, JsonSyntaxException {
        boolean isEmpty = true;
        boolean oldLenient = reader.isLenient();
        reader.setLenient(true);
        try {
            java.lang.Object object;
            reader.peek();
            isEmpty = false;
            TypeToken<?> typeToken = TypeToken.get(typeOfT);
            TypeAdapter<?> typeAdapter = this.getAdapter(typeToken);
            java.lang.Object obj = object = typeAdapter.read(reader);
            return (T)obj;
        }
        catch (EOFException e) {
            if (isEmpty) {
                T t = null;
                return t;
            }
            throw new JsonSyntaxException((Throwable)((java.lang.Object)e));
        }
        catch (IllegalStateException e) {
            throw new JsonSyntaxException((Throwable)((java.lang.Object)e));
        }
        catch (IOException e) {
            throw new JsonSyntaxException((Throwable)((java.lang.Object)e));
        }
        finally {
            reader.setLenient(oldLenient);
        }
    }

    public <T extends Object> T fromJson(JsonElement json, Class<T> classOfT) throws JsonSyntaxException {
        T object = this.fromJson(json, (Type)classOfT);
        return (T)Primitives.wrap(classOfT).cast(object);
    }

    public <T extends Object> T fromJson(JsonElement json, Type typeOfT) throws JsonSyntaxException {
        if (json == null) {
            return null;
        }
        return this.fromJson(new JsonTreeReader(json), typeOfT);
    }

    public String toString() {
        return new StringBuilder((String)"io.logz.sender.{serializeNulls:").append(this.serializeNulls).append((String)"io.logz.sender.factories:").append(this.factories).append((String)"io.logz.sender.,instanceCreators:").append((Object)this.constructorConstructor).append((String)"io.logz.sender.}").toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FutureTypeAdapter<T extends Object>
    extends TypeAdapter<T> {
        private TypeAdapter<T> delegate;

        FutureTypeAdapter() {
        }

        public void setDelegate(TypeAdapter<T> typeAdapter) {
            if (this.delegate != null) {
                throw new AssertionError();
            }
            this.delegate = typeAdapter;
        }

        @Override
        public T read(JsonReader in) throws IOException {
            if (this.delegate == null) {
                throw new IllegalStateException();
            }
            return this.delegate.read(in);
        }

        @Override
        public void write(JsonWriter out, T value) throws IOException {
            if (this.delegate == null) {
                throw new IllegalStateException();
            }
            this.delegate.write(out, value);
        }
    }
}

