/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.gson;

import io.logz.sender.com.google.gson.JsonElement;
import io.logz.sender.com.google.gson.JsonIOException;
import io.logz.sender.com.google.gson.internal.bind.JsonTreeReader;
import io.logz.sender.com.google.gson.internal.bind.JsonTreeWriter;
import io.logz.sender.com.google.gson.stream.JsonReader;
import io.logz.sender.com.google.gson.stream.JsonToken;
import io.logz.sender.com.google.gson.stream.JsonWriter;
import io.logz.sender.java.io.IOException;
import io.logz.sender.java.io.Reader;
import io.logz.sender.java.io.StringReader;
import io.logz.sender.java.io.StringWriter;
import io.logz.sender.java.io.Writer;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.Throwable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeAdapter<T extends io.logz.sender.java.lang.Object>
extends io.logz.sender.java.lang.Object {
    public abstract void write(JsonWriter var1, T var2) throws IOException;

    public final void toJson(Writer out, T value) throws IOException {
        JsonWriter writer = new JsonWriter(out);
        this.write(writer, value);
    }

    public final TypeAdapter<T> nullSafe() {
        return new TypeAdapter<T>(){

            @Override
            public void write(JsonWriter out, T value) throws IOException {
                if (value == null) {
                    out.nullValue();
                } else {
                    TypeAdapter.this.write(out, value);
                }
            }

            @Override
            public T read(JsonReader reader) throws IOException {
                if (reader.peek() == JsonToken.NULL) {
                    reader.nextNull();
                    return null;
                }
                return TypeAdapter.this.read(reader);
            }
        };
    }

    public final String toJson(T value) throws IOException {
        StringWriter stringWriter = new StringWriter();
        this.toJson((Writer)stringWriter, value);
        return stringWriter.toString();
    }

    public final JsonElement toJsonTree(T value) {
        try {
            JsonTreeWriter jsonWriter = new JsonTreeWriter();
            this.write(jsonWriter, value);
            return jsonWriter.get();
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)((Object)e));
        }
    }

    public abstract T read(JsonReader var1) throws IOException;

    public final T fromJson(Reader in) throws IOException {
        JsonReader reader = new JsonReader(in);
        return this.read(reader);
    }

    public final T fromJson(String json) throws IOException {
        return this.fromJson((Reader)new StringReader(json));
    }

    public final T fromJsonTree(JsonElement jsonTree) {
        try {
            JsonTreeReader jsonReader = new JsonTreeReader(jsonTree);
            return this.read(jsonReader);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)((Object)e));
        }
    }
}

