/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.gson.internal;

import io.logz.sender.com.google.gson.InstanceCreator;
import io.logz.sender.com.google.gson.JsonIOException;
import io.logz.sender.com.google.gson.internal.LinkedTreeMap;
import io.logz.sender.com.google.gson.internal.ObjectConstructor;
import io.logz.sender.com.google.gson.internal.UnsafeAllocator;
import io.logz.sender.com.google.gson.reflect.TypeToken;
import io.logz.sender.java.lang.AssertionError;
import io.logz.sender.java.lang.Class;
import io.logz.sender.java.lang.Exception;
import io.logz.sender.java.lang.IllegalAccessException;
import io.logz.sender.java.lang.InstantiationException;
import io.logz.sender.java.lang.NoSuchMethodException;
import io.logz.sender.java.lang.RuntimeException;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.lang.Throwable;
import io.logz.sender.java.lang.reflect.Constructor;
import io.logz.sender.java.lang.reflect.InvocationTargetException;
import io.logz.sender.java.lang.reflect.ParameterizedType;
import io.logz.sender.java.lang.reflect.Type;
import io.logz.sender.java.util.ArrayList;
import io.logz.sender.java.util.Collection;
import io.logz.sender.java.util.EnumSet;
import io.logz.sender.java.util.LinkedHashMap;
import io.logz.sender.java.util.LinkedHashSet;
import io.logz.sender.java.util.LinkedList;
import io.logz.sender.java.util.Map;
import io.logz.sender.java.util.Queue;
import io.logz.sender.java.util.Set;
import io.logz.sender.java.util.SortedMap;
import io.logz.sender.java.util.SortedSet;
import io.logz.sender.java.util.TreeMap;
import io.logz.sender.java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConstructorConstructor
extends io.logz.sender.java.lang.Object {
    private final Map<Type, InstanceCreator<?>> instanceCreators;

    public ConstructorConstructor(Map<Type, InstanceCreator<?>> instanceCreators) {
        this.instanceCreators = instanceCreators;
    }

    public <T extends io.logz.sender.java.lang.Object> ObjectConstructor<T> get(TypeToken<T> typeToken) {
        final Type type = typeToken.getType();
        Class<T> rawType = typeToken.getRawType();
        final InstanceCreator typeCreator = (InstanceCreator)this.instanceCreators.get((io.logz.sender.java.lang.Object)type);
        if (typeCreator != null) {
            return new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    return typeCreator.createInstance(type);
                }
            };
        }
        final InstanceCreator rawTypeCreator = (InstanceCreator)this.instanceCreators.get(rawType);
        if (rawTypeCreator != null) {
            return new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    return rawTypeCreator.createInstance(type);
                }
            };
        }
        ObjectConstructor<T> defaultConstructor = this.newDefaultConstructor(rawType);
        if (defaultConstructor != null) {
            return defaultConstructor;
        }
        ObjectConstructor<T> defaultImplementation = this.newDefaultImplementationConstructor(type, rawType);
        if (defaultImplementation != null) {
            return defaultImplementation;
        }
        return this.newUnsafeAllocator(type, rawType);
    }

    private <T extends io.logz.sender.java.lang.Object> ObjectConstructor<T> newDefaultConstructor(Class<? super T> rawType) {
        try {
            final Constructor constructor = rawType.getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    try {
                        io.logz.sender.java.lang.Object[] args = null;
                        return constructor.newInstance(args);
                    }
                    catch (InstantiationException e) {
                        throw new RuntimeException(new StringBuilder().append((String)"io.logz.sender.Failed to invoke ").append((io.logz.sender.java.lang.Object)constructor).append((String)"io.logz.sender. with no args").toString(), (Throwable)((Object)e));
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(new StringBuilder().append((String)"io.logz.sender.Failed to invoke ").append((io.logz.sender.java.lang.Object)constructor).append((String)"io.logz.sender. with no args").toString(), e.getTargetException());
                    }
                    catch (IllegalAccessException e) {
                        throw new AssertionError((io.logz.sender.java.lang.Object)e);
                    }
                }
            };
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private <T extends io.logz.sender.java.lang.Object> ObjectConstructor<T> newDefaultImplementationConstructor(final Type type, Class<? super T> rawType) {
        if (Collection.class.isAssignableFrom(rawType)) {
            if (SortedSet.class.isAssignableFrom(rawType)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new TreeSet();
                    }
                };
            }
            if (EnumSet.class.isAssignableFrom(rawType)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        if (type instanceof ParameterizedType) {
                            Type elementType = ((ParameterizedType)type).getActualTypeArguments()[0];
                            if (elementType instanceof Class) {
                                return EnumSet.noneOf((Class)((Class)elementType));
                            }
                            throw new JsonIOException(new StringBuilder().append((String)"io.logz.sender.Invalid EnumSet type: ").append(type.toString()).toString());
                        }
                        throw new JsonIOException(new StringBuilder().append((String)"io.logz.sender.Invalid EnumSet type: ").append(type.toString()).toString());
                    }
                };
            }
            if (Set.class.isAssignableFrom(rawType)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new LinkedHashSet();
                    }
                };
            }
            if (Queue.class.isAssignableFrom(rawType)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new LinkedList();
                    }
                };
            }
            return new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    return new ArrayList();
                }
            };
        }
        if (Map.class.isAssignableFrom(rawType)) {
            if (SortedMap.class.isAssignableFrom(rawType)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new TreeMap();
                    }
                };
            }
            if (type instanceof ParameterizedType && !String.class.isAssignableFrom(TypeToken.get(((ParameterizedType)type).getActualTypeArguments()[0]).getRawType())) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new LinkedHashMap();
                    }
                };
            }
            return new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    return (Object)new LinkedTreeMap();
                }
            };
        }
        return null;
    }

    private <T extends io.logz.sender.java.lang.Object> ObjectConstructor<T> newUnsafeAllocator(final Type type, final Class<? super T> rawType) {
        return new ObjectConstructor<T>(){
            private final UnsafeAllocator unsafeAllocator = UnsafeAllocator.create();

            @Override
            public T construct() {
                try {
                    Object newInstance = this.unsafeAllocator.newInstance(rawType);
                    return newInstance;
                }
                catch (Exception e) {
                    throw new RuntimeException(new StringBuilder().append((String)"io.logz.sender.Unable to invoke no-args constructor for ").append((io.logz.sender.java.lang.Object)type).append((String)"io.logz.sender.. ").append((String)"io.logz.sender.Register an InstanceCreator with Gson for this type may fix this problem.").toString(), (Throwable)((Object)e));
                }
            }
        };
    }

    public String toString() {
        return this.instanceCreators.toString();
    }
}

