/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.gson.internal.bind;

import io.logz.sender.com.google.gson.Gson;
import io.logz.sender.com.google.gson.TypeAdapter;
import io.logz.sender.com.google.gson.TypeAdapterFactory;
import io.logz.sender.com.google.gson.internal.$Gson$Types;
import io.logz.sender.com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import io.logz.sender.com.google.gson.reflect.TypeToken;
import io.logz.sender.com.google.gson.stream.JsonReader;
import io.logz.sender.com.google.gson.stream.JsonToken;
import io.logz.sender.com.google.gson.stream.JsonWriter;
import io.logz.sender.java.io.IOException;
import io.logz.sender.java.lang.Class;
import io.logz.sender.java.lang.reflect.Array;
import io.logz.sender.java.lang.reflect.GenericArrayType;
import io.logz.sender.java.lang.reflect.Type;
import io.logz.sender.java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayTypeAdapter<E extends io.logz.sender.java.lang.Object>
extends TypeAdapter<io.logz.sender.java.lang.Object> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T extends io.logz.sender.java.lang.Object> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            Type type = typeToken.getType();
            if (!(type instanceof GenericArrayType || type instanceof Class && ((Class)type).isArray())) {
                return null;
            }
            Type componentType = $Gson$Types.getArrayComponentType(type);
            TypeAdapter<?> componentTypeAdapter = gson.getAdapter(TypeToken.get(componentType));
            return new ArrayTypeAdapter(gson, componentTypeAdapter, $Gson$Types.getRawType(componentType));
        }
    };
    private final Class<E> componentType;
    private final TypeAdapter<E> componentTypeAdapter;

    public ArrayTypeAdapter(Gson context, TypeAdapter<E> componentTypeAdapter, Class<E> componentType) {
        this.componentTypeAdapter = new TypeAdapterRuntimeTypeWrapper<E>(context, componentTypeAdapter, (Type)componentType);
        this.componentType = componentType;
    }

    @Override
    public io.logz.sender.java.lang.Object read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        ArrayList list = new ArrayList();
        in.beginArray();
        while (in.hasNext()) {
            E instance = this.componentTypeAdapter.read(in);
            list.add(instance);
        }
        in.endArray();
        io.logz.sender.java.lang.Object array = Array.newInstance(this.componentType, (int)list.size());
        for (int i = 0; i < list.size(); ++i) {
            Array.set((io.logz.sender.java.lang.Object)array, (int)i, (io.logz.sender.java.lang.Object)list.get(i));
        }
        return array;
    }

    @Override
    public void write(JsonWriter out, io.logz.sender.java.lang.Object array) throws IOException {
        if (array == null) {
            out.nullValue();
            return;
        }
        out.beginArray();
        int length = Array.getLength((io.logz.sender.java.lang.Object)array);
        for (int i = 0; i < length; ++i) {
            io.logz.sender.java.lang.Object value = Array.get((io.logz.sender.java.lang.Object)array, (int)i);
            this.componentTypeAdapter.write(out, value);
        }
        out.endArray();
    }
}

