/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.gson.internal.bind;

import io.logz.sender.com.google.gson.Gson;
import io.logz.sender.com.google.gson.JsonSyntaxException;
import io.logz.sender.com.google.gson.TypeAdapter;
import io.logz.sender.com.google.gson.TypeAdapterFactory;
import io.logz.sender.com.google.gson.reflect.TypeToken;
import io.logz.sender.com.google.gson.stream.JsonReader;
import io.logz.sender.com.google.gson.stream.JsonToken;
import io.logz.sender.com.google.gson.stream.JsonWriter;
import io.logz.sender.java.io.IOException;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.Throwable;
import io.logz.sender.java.text.DateFormat;
import io.logz.sender.java.text.ParseException;
import io.logz.sender.java.text.SimpleDateFormat;
import io.logz.sender.java.util.Date;
import io.logz.sender.java.util.Locale;
import io.logz.sender.java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DateTypeAdapter
extends TypeAdapter<Date> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T extends io.logz.sender.java.lang.Object> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == Date.class ? new DateTypeAdapter() : null;
        }
    };
    private final DateFormat enUsFormat = DateFormat.getDateTimeInstance((int)2, (int)2, (Locale)Locale.US);
    private final DateFormat localFormat = DateFormat.getDateTimeInstance((int)2, (int)2);
    private final DateFormat iso8601Format = DateTypeAdapter.buildIso8601Format();

    private static DateFormat buildIso8601Format() {
        SimpleDateFormat iso8601Format = new SimpleDateFormat((String)"io.logz.sender.yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        iso8601Format.setTimeZone(TimeZone.getTimeZone((String)"io.logz.sender.UTC"));
        return iso8601Format;
    }

    @Override
    public Date read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        return this.deserializeToDate(in.nextString());
    }

    private synchronized Date deserializeToDate(String json) {
        try {
            return this.localFormat.parse(json);
        }
        catch (ParseException ignored) {
            try {
                return this.enUsFormat.parse(json);
            }
            catch (ParseException ignored2) {
                try {
                    return this.iso8601Format.parse(json);
                }
                catch (ParseException e) {
                    throw new JsonSyntaxException(json, (Throwable)((Object)e));
                }
            }
        }
    }

    @Override
    public synchronized void write(JsonWriter out, Date value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        String dateFormatAsString = this.enUsFormat.format(value);
        out.value(dateFormatAsString);
    }
}

