/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.gson.internal.bind;

import io.logz.sender.com.google.gson.JsonArray;
import io.logz.sender.com.google.gson.JsonElement;
import io.logz.sender.com.google.gson.JsonNull;
import io.logz.sender.com.google.gson.JsonObject;
import io.logz.sender.com.google.gson.JsonPrimitive;
import io.logz.sender.com.google.gson.stream.JsonReader;
import io.logz.sender.com.google.gson.stream.JsonToken;
import io.logz.sender.java.io.IOException;
import io.logz.sender.java.io.Reader;
import io.logz.sender.java.lang.AssertionError;
import io.logz.sender.java.lang.Double;
import io.logz.sender.java.lang.IllegalStateException;
import io.logz.sender.java.lang.NumberFormatException;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.util.ArrayList;
import io.logz.sender.java.util.Iterator;
import io.logz.sender.java.util.List;
import io.logz.sender.java.util.Map;

public final class JsonTreeReader
extends JsonReader {
    private static final Reader UNREADABLE_READER = new Reader(){

        public int read(char[] buffer, int offset, int count) throws IOException {
            throw new AssertionError();
        }

        public void close() throws IOException {
            throw new AssertionError();
        }
    };
    private static final io.logz.sender.java.lang.Object SENTINEL_CLOSED = new io.logz.sender.java.lang.Object();
    private final List<io.logz.sender.java.lang.Object> stack = new ArrayList();

    public JsonTreeReader(JsonElement element) {
        super(UNREADABLE_READER);
        this.stack.add((io.logz.sender.java.lang.Object)element);
    }

    public void beginArray() throws IOException {
        this.expect(JsonToken.BEGIN_ARRAY);
        JsonArray array = (JsonArray)this.peekStack();
        this.stack.add(array.iterator());
    }

    public void endArray() throws IOException {
        this.expect(JsonToken.END_ARRAY);
        this.popStack();
        this.popStack();
    }

    public void beginObject() throws IOException {
        this.expect(JsonToken.BEGIN_OBJECT);
        JsonObject object = (JsonObject)this.peekStack();
        this.stack.add((io.logz.sender.java.lang.Object)object.entrySet().iterator());
    }

    public void endObject() throws IOException {
        this.expect(JsonToken.END_OBJECT);
        this.popStack();
        this.popStack();
    }

    public boolean hasNext() throws IOException {
        JsonToken token = this.peek();
        return token != JsonToken.END_OBJECT && token != JsonToken.END_ARRAY;
    }

    public JsonToken peek() throws IOException {
        if (this.stack.isEmpty()) {
            return JsonToken.END_DOCUMENT;
        }
        io.logz.sender.java.lang.Object o = this.peekStack();
        if (o instanceof Iterator) {
            boolean isObject = this.stack.get(this.stack.size() - 2) instanceof JsonObject;
            Iterator iterator = (Iterator)o;
            if (iterator.hasNext()) {
                if (isObject) {
                    return JsonToken.NAME;
                }
                this.stack.add(iterator.next());
                return this.peek();
            }
            return isObject ? JsonToken.END_OBJECT : JsonToken.END_ARRAY;
        }
        if (o instanceof JsonObject) {
            return JsonToken.BEGIN_OBJECT;
        }
        if (o instanceof JsonArray) {
            return JsonToken.BEGIN_ARRAY;
        }
        if (o instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)o;
            if (primitive.isString()) {
                return JsonToken.STRING;
            }
            if (primitive.isBoolean()) {
                return JsonToken.BOOLEAN;
            }
            if (primitive.isNumber()) {
                return JsonToken.NUMBER;
            }
            throw new AssertionError();
        }
        if (o instanceof JsonNull) {
            return JsonToken.NULL;
        }
        if (o == SENTINEL_CLOSED) {
            throw new IllegalStateException((String)"io.logz.sender.JsonReader is closed");
        }
        throw new AssertionError();
    }

    private io.logz.sender.java.lang.Object peekStack() {
        return this.stack.get(this.stack.size() - 1);
    }

    private io.logz.sender.java.lang.Object popStack() {
        return this.stack.remove(this.stack.size() - 1);
    }

    private void expect(JsonToken expected) throws IOException {
        if (this.peek() != expected) {
            throw new IllegalStateException(new StringBuilder().append((String)"io.logz.sender.Expected ").append((io.logz.sender.java.lang.Object)expected).append((String)"io.logz.sender. but was ").append((io.logz.sender.java.lang.Object)this.peek()).toString());
        }
    }

    public String nextName() throws IOException {
        this.expect(JsonToken.NAME);
        Iterator i = (Iterator)this.peekStack();
        Map.Entry entry = (Map.Entry)i.next();
        this.stack.add(entry.getValue());
        return (String)entry.getKey();
    }

    public String nextString() throws IOException {
        JsonToken token = this.peek();
        if (token != JsonToken.STRING && token != JsonToken.NUMBER) {
            throw new IllegalStateException(new StringBuilder().append((String)"io.logz.sender.Expected ").append((io.logz.sender.java.lang.Object)JsonToken.STRING).append((String)"io.logz.sender. but was ").append((io.logz.sender.java.lang.Object)token).toString());
        }
        return ((JsonPrimitive)this.popStack()).getAsString();
    }

    public boolean nextBoolean() throws IOException {
        this.expect(JsonToken.BOOLEAN);
        return ((JsonPrimitive)this.popStack()).getAsBoolean();
    }

    public void nextNull() throws IOException {
        this.expect(JsonToken.NULL);
        this.popStack();
    }

    public double nextDouble() throws IOException {
        JsonToken token = this.peek();
        if (token != JsonToken.NUMBER && token != JsonToken.STRING) {
            throw new IllegalStateException(new StringBuilder().append((String)"io.logz.sender.Expected ").append((io.logz.sender.java.lang.Object)JsonToken.NUMBER).append((String)"io.logz.sender. but was ").append((io.logz.sender.java.lang.Object)token).toString());
        }
        double result = ((JsonPrimitive)this.peekStack()).getAsDouble();
        if (!this.isLenient() && (Double.isNaN((double)result) || Double.isInfinite((double)result))) {
            throw new NumberFormatException(new StringBuilder().append((String)"io.logz.sender.JSON forbids NaN and infinities: ").append(result).toString());
        }
        this.popStack();
        return result;
    }

    public long nextLong() throws IOException {
        JsonToken token = this.peek();
        if (token != JsonToken.NUMBER && token != JsonToken.STRING) {
            throw new IllegalStateException(new StringBuilder().append((String)"io.logz.sender.Expected ").append((io.logz.sender.java.lang.Object)JsonToken.NUMBER).append((String)"io.logz.sender. but was ").append((io.logz.sender.java.lang.Object)token).toString());
        }
        long result = ((JsonPrimitive)this.peekStack()).getAsLong();
        this.popStack();
        return result;
    }

    public int nextInt() throws IOException {
        JsonToken token = this.peek();
        if (token != JsonToken.NUMBER && token != JsonToken.STRING) {
            throw new IllegalStateException(new StringBuilder().append((String)"io.logz.sender.Expected ").append((io.logz.sender.java.lang.Object)JsonToken.NUMBER).append((String)"io.logz.sender. but was ").append((io.logz.sender.java.lang.Object)token).toString());
        }
        int result = ((JsonPrimitive)this.peekStack()).getAsInt();
        this.popStack();
        return result;
    }

    public void close() throws IOException {
        this.stack.clear();
        this.stack.add(SENTINEL_CLOSED);
    }

    public void skipValue() throws IOException {
        if (this.peek() == JsonToken.NAME) {
            this.nextName();
        } else {
            this.popStack();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public void promoteNameToValue() throws IOException {
        this.expect(JsonToken.NAME);
        Iterator i = (Iterator)this.peekStack();
        Map.Entry entry = (Map.Entry)i.next();
        this.stack.add(entry.getValue());
        this.stack.add((io.logz.sender.java.lang.Object)new JsonPrimitive((String)entry.getKey()));
    }
}

