/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.gson.internal.bind;

import io.logz.sender.com.google.gson.JsonArray;
import io.logz.sender.com.google.gson.JsonElement;
import io.logz.sender.com.google.gson.JsonNull;
import io.logz.sender.com.google.gson.JsonObject;
import io.logz.sender.com.google.gson.JsonPrimitive;
import io.logz.sender.com.google.gson.stream.JsonWriter;
import io.logz.sender.java.io.IOException;
import io.logz.sender.java.io.Writer;
import io.logz.sender.java.lang.AssertionError;
import io.logz.sender.java.lang.Boolean;
import io.logz.sender.java.lang.Double;
import io.logz.sender.java.lang.IllegalArgumentException;
import io.logz.sender.java.lang.IllegalStateException;
import io.logz.sender.java.lang.Long;
import io.logz.sender.java.lang.Number;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.util.ArrayList;
import io.logz.sender.java.util.List;

public final class JsonTreeWriter
extends JsonWriter {
    private static final Writer UNWRITABLE_WRITER = new Writer(){

        public void write(char[] buffer, int offset, int counter) {
            throw new AssertionError();
        }

        public void flush() throws IOException {
            throw new AssertionError();
        }

        public void close() throws IOException {
            throw new AssertionError();
        }
    };
    private static final JsonPrimitive SENTINEL_CLOSED = new JsonPrimitive((String)"io.logz.sender.closed");
    private final List<JsonElement> stack = new ArrayList();
    private String pendingName;
    private JsonElement product = JsonNull.INSTANCE;

    public JsonTreeWriter() {
        super(UNWRITABLE_WRITER);
    }

    public JsonElement get() {
        if (!this.stack.isEmpty()) {
            throw new IllegalStateException(new StringBuilder().append((String)"io.logz.sender.Expected one JSON element but was ").append(this.stack).toString());
        }
        return this.product;
    }

    private JsonElement peek() {
        return (JsonElement)this.stack.get(this.stack.size() - 1);
    }

    private void put(JsonElement value) {
        if (this.pendingName != null) {
            if (!value.isJsonNull() || this.getSerializeNulls()) {
                JsonObject object = (JsonObject)this.peek();
                object.add(this.pendingName, value);
            }
            this.pendingName = null;
        } else if (this.stack.isEmpty()) {
            this.product = value;
        } else {
            JsonElement element = this.peek();
            if (element instanceof JsonArray) {
                ((JsonArray)element).add(value);
            } else {
                throw new IllegalStateException();
            }
        }
    }

    public JsonWriter beginArray() throws IOException {
        JsonArray array = new JsonArray();
        this.put(array);
        this.stack.add((io.logz.sender.java.lang.Object)array);
        return this;
    }

    public JsonWriter endArray() throws IOException {
        if (this.stack.isEmpty() || this.pendingName != null) {
            throw new IllegalStateException();
        }
        JsonElement element = this.peek();
        if (element instanceof JsonArray) {
            this.stack.remove(this.stack.size() - 1);
            return this;
        }
        throw new IllegalStateException();
    }

    public JsonWriter beginObject() throws IOException {
        JsonObject object = new JsonObject();
        this.put(object);
        this.stack.add((io.logz.sender.java.lang.Object)object);
        return this;
    }

    public JsonWriter endObject() throws IOException {
        if (this.stack.isEmpty() || this.pendingName != null) {
            throw new IllegalStateException();
        }
        JsonElement element = this.peek();
        if (element instanceof JsonObject) {
            this.stack.remove(this.stack.size() - 1);
            return this;
        }
        throw new IllegalStateException();
    }

    public JsonWriter name(String name) throws IOException {
        if (this.stack.isEmpty() || this.pendingName != null) {
            throw new IllegalStateException();
        }
        JsonElement element = this.peek();
        if (element instanceof JsonObject) {
            this.pendingName = name;
            return this;
        }
        throw new IllegalStateException();
    }

    public JsonWriter value(String value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.put(new JsonPrimitive(value));
        return this;
    }

    public JsonWriter nullValue() throws IOException {
        this.put(JsonNull.INSTANCE);
        return this;
    }

    public JsonWriter value(boolean value) throws IOException {
        this.put(new JsonPrimitive(Boolean.valueOf((boolean)value)));
        return this;
    }

    public JsonWriter value(double value) throws IOException {
        if (!this.isLenient() && (Double.isNaN((double)value) || Double.isInfinite((double)value))) {
            throw new IllegalArgumentException(new StringBuilder().append((String)"io.logz.sender.JSON forbids NaN and infinities: ").append(value).toString());
        }
        this.put(new JsonPrimitive((Number)Double.valueOf((double)value)));
        return this;
    }

    public JsonWriter value(long value) throws IOException {
        this.put(new JsonPrimitive((Number)Long.valueOf((long)value)));
        return this;
    }

    public JsonWriter value(Number value) throws IOException {
        double d;
        if (value == null) {
            return this.nullValue();
        }
        if (!this.isLenient() && (Double.isNaN((double)(d = value.doubleValue())) || Double.isInfinite((double)d))) {
            throw new IllegalArgumentException(new StringBuilder().append((String)"io.logz.sender.JSON forbids NaN and infinities: ").append((io.logz.sender.java.lang.Object)value).toString());
        }
        this.put(new JsonPrimitive(value));
        return this;
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        if (!this.stack.isEmpty()) {
            throw new IOException((String)"io.logz.sender.Incomplete document");
        }
        this.stack.add((io.logz.sender.java.lang.Object)SENTINEL_CLOSED);
    }
}

