/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.gson.stream;

import io.logz.sender.java.io.Closeable;
import io.logz.sender.java.io.Flushable;
import io.logz.sender.java.io.IOException;
import io.logz.sender.java.io.Writer;
import io.logz.sender.java.lang.CharSequence;
import io.logz.sender.java.lang.Double;
import io.logz.sender.java.lang.IllegalArgumentException;
import io.logz.sender.java.lang.IllegalStateException;
import io.logz.sender.java.lang.Integer;
import io.logz.sender.java.lang.Long;
import io.logz.sender.java.lang.NullPointerException;
import io.logz.sender.java.lang.Number;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.lang.System;

public class JsonWriter
extends io.logz.sender.java.lang.Object
implements Closeable,
Flushable {
    private static final String[] REPLACEMENT_CHARS = new String[128];
    private static final String[] HTML_SAFE_REPLACEMENT_CHARS;
    private final Writer out;
    private int[] stack = new int[32];
    private int stackSize = 0;
    private String indent;
    private String separator;
    private boolean lenient;
    private boolean htmlSafe;
    private String deferredName;
    private boolean serializeNulls;

    public JsonWriter(Writer out) {
        this.push(6);
        this.separator = "io.logz.sender.:";
        this.serializeNulls = true;
        if (out == null) {
            throw new NullPointerException((String)"io.logz.sender.out == null");
        }
        this.out = out;
    }

    public final void setIndent(String indent) {
        if (indent.length() == 0) {
            this.indent = null;
            this.separator = "io.logz.sender.:";
        } else {
            this.indent = indent;
            this.separator = "io.logz.sender.: ";
        }
    }

    public final void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public final void setHtmlSafe(boolean htmlSafe) {
        this.htmlSafe = htmlSafe;
    }

    public final boolean isHtmlSafe() {
        return this.htmlSafe;
    }

    public final void setSerializeNulls(boolean serializeNulls) {
        this.serializeNulls = serializeNulls;
    }

    public final boolean getSerializeNulls() {
        return this.serializeNulls;
    }

    public JsonWriter beginArray() throws IOException {
        this.writeDeferredName();
        return this.open(1, (String)"io.logz.sender.[");
    }

    public JsonWriter endArray() throws IOException {
        return this.close(1, 2, (String)"io.logz.sender.]");
    }

    public JsonWriter beginObject() throws IOException {
        this.writeDeferredName();
        return this.open(3, (String)"io.logz.sender.{");
    }

    public JsonWriter endObject() throws IOException {
        return this.close(3, 5, (String)"io.logz.sender.}");
    }

    private JsonWriter open(int empty, String openBracket) throws IOException {
        this.beforeValue(true);
        this.push(empty);
        this.out.write(openBracket);
        return this;
    }

    private JsonWriter close(int empty, int nonempty, String closeBracket) throws IOException {
        int context = this.peek();
        if (context != nonempty && context != empty) {
            throw new IllegalStateException((String)"io.logz.sender.Nesting problem.");
        }
        if (this.deferredName != null) {
            throw new IllegalStateException(new StringBuilder().append((String)"io.logz.sender.Dangling name: ").append(this.deferredName).toString());
        }
        --this.stackSize;
        if (context == nonempty) {
            this.newline();
        }
        this.out.write(closeBracket);
        return this;
    }

    private void push(int newTop) {
        if (this.stackSize == this.stack.length) {
            int[] newStack = new int[this.stackSize * 2];
            System.arraycopy((io.logz.sender.java.lang.Object)this.stack, (int)0, (io.logz.sender.java.lang.Object)newStack, (int)0, (int)this.stackSize);
            this.stack = newStack;
        }
        this.stack[this.stackSize++] = newTop;
    }

    private int peek() {
        if (this.stackSize == 0) {
            throw new IllegalStateException((String)"io.logz.sender.JsonWriter is closed.");
        }
        return this.stack[this.stackSize - 1];
    }

    private void replaceTop(int topOfStack) {
        this.stack[this.stackSize - 1] = topOfStack;
    }

    public JsonWriter name(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException((String)"io.logz.sender.name == null");
        }
        if (this.deferredName != null) {
            throw new IllegalStateException();
        }
        if (this.stackSize == 0) {
            throw new IllegalStateException((String)"io.logz.sender.JsonWriter is closed.");
        }
        this.deferredName = name;
        return this;
    }

    private void writeDeferredName() throws IOException {
        if (this.deferredName != null) {
            this.beforeName();
            this.string(this.deferredName);
            this.deferredName = null;
        }
    }

    public JsonWriter value(String value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue(false);
        this.string(value);
        return this;
    }

    public JsonWriter nullValue() throws IOException {
        if (this.deferredName != null) {
            if (this.serializeNulls) {
                this.writeDeferredName();
            } else {
                this.deferredName = null;
                return this;
            }
        }
        this.beforeValue(false);
        this.out.write((String)"io.logz.sender.null");
        return this;
    }

    public JsonWriter value(boolean value) throws IOException {
        this.writeDeferredName();
        this.beforeValue(false);
        this.out.write((String)(value ? "io.logz.sender.true" : "io.logz.sender.false"));
        return this;
    }

    public JsonWriter value(double value) throws IOException {
        if (Double.isNaN((double)value) || Double.isInfinite((double)value)) {
            throw new IllegalArgumentException(new StringBuilder().append((String)"io.logz.sender.Numeric values must be finite, but was ").append(value).toString());
        }
        this.writeDeferredName();
        this.beforeValue(false);
        this.out.append((CharSequence)Double.toString((double)value));
        return this;
    }

    public JsonWriter value(long value) throws IOException {
        this.writeDeferredName();
        this.beforeValue(false);
        this.out.write(Long.toString((long)value));
        return this;
    }

    public JsonWriter value(Number value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        String string = value.toString();
        if (!this.lenient && (string.equals((io.logz.sender.java.lang.Object)"io.logz.sender.-Infinity") || string.equals((io.logz.sender.java.lang.Object)"io.logz.sender.Infinity") || string.equals((io.logz.sender.java.lang.Object)"io.logz.sender.NaN"))) {
            throw new IllegalArgumentException(new StringBuilder().append((String)"io.logz.sender.Numeric values must be finite, but was ").append((io.logz.sender.java.lang.Object)value).toString());
        }
        this.beforeValue(false);
        this.out.append((CharSequence)string);
        return this;
    }

    public void flush() throws IOException {
        if (this.stackSize == 0) {
            throw new IllegalStateException((String)"io.logz.sender.JsonWriter is closed.");
        }
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
        int size = this.stackSize;
        if (size > 1 || size == 1 && this.stack[size - 1] != 7) {
            throw new IOException((String)"io.logz.sender.Incomplete document");
        }
        this.stackSize = 0;
    }

    private void string(String value) throws IOException {
        String[] replacements = this.htmlSafe ? HTML_SAFE_REPLACEMENT_CHARS : REPLACEMENT_CHARS;
        this.out.write((String)"io.logz.sender.\"");
        int last = 0;
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            Object replacement;
            char c = value.charAt(i);
            if (c < '\u0080') {
                replacement = replacements[c];
                if (replacement == null) {
                    continue;
                }
            } else if (c == '\u2028') {
                replacement = "io.logz.sender.\\u2028";
            } else {
                if (c != '\u2029') continue;
                replacement = "io.logz.sender.\\u2029";
            }
            if (last < i) {
                this.out.write(value, last, i - last);
            }
            this.out.write(replacement);
            last = i + 1;
        }
        if (last < length) {
            this.out.write(value, last, length - last);
        }
        this.out.write((String)"io.logz.sender.\"");
    }

    private void newline() throws IOException {
        if (this.indent == null) {
            return;
        }
        this.out.write((String)"io.logz.sender.\n");
        int size = this.stackSize;
        for (int i = 1; i < size; ++i) {
            this.out.write(this.indent);
        }
    }

    private void beforeName() throws IOException {
        int context = this.peek();
        if (context == 5) {
            this.out.write(44);
        } else if (context != 3) {
            throw new IllegalStateException((String)"io.logz.sender.Nesting problem.");
        }
        this.newline();
        this.replaceTop(4);
    }

    private void beforeValue(boolean root) throws IOException {
        switch (this.peek()) {
            case 7: {
                if (!this.lenient) {
                    throw new IllegalStateException((String)"io.logz.sender.JSON must have only one top-level value.");
                }
            }
            case 6: {
                if (!this.lenient && !root) {
                    throw new IllegalStateException((String)"io.logz.sender.JSON must start with an array or an object.");
                }
                this.replaceTop(7);
                break;
            }
            case 1: {
                this.replaceTop(2);
                this.newline();
                break;
            }
            case 2: {
                this.out.append(',');
                this.newline();
                break;
            }
            case 4: {
                this.out.append((CharSequence)this.separator);
                this.replaceTop(5);
                break;
            }
            default: {
                throw new IllegalStateException((String)"io.logz.sender.Nesting problem.");
            }
        }
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            JsonWriter.REPLACEMENT_CHARS[i] = String.format((String)"io.logz.sender.\\u%04x", (io.logz.sender.java.lang.Object[])new io.logz.sender.java.lang.Object[]{Integer.valueOf((int)i)});
        }
        JsonWriter.REPLACEMENT_CHARS[34] = "io.logz.sender.\\\"";
        JsonWriter.REPLACEMENT_CHARS[92] = "io.logz.sender.\\\\";
        JsonWriter.REPLACEMENT_CHARS[9] = "io.logz.sender.\\t";
        JsonWriter.REPLACEMENT_CHARS[8] = "io.logz.sender.\\b";
        JsonWriter.REPLACEMENT_CHARS[10] = "io.logz.sender.\\n";
        JsonWriter.REPLACEMENT_CHARS[13] = "io.logz.sender.\\r";
        JsonWriter.REPLACEMENT_CHARS[12] = "io.logz.sender.\\f";
        HTML_SAFE_REPLACEMENT_CHARS = (String[])REPLACEMENT_CHARS.clone();
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[60] = "io.logz.sender.\\u003c";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[62] = "io.logz.sender.\\u003e";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[38] = "io.logz.sender.\\u0026";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[61] = "io.logz.sender.\\u003d";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[39] = "io.logz.sender.\\u0027";
    }
}

