/*
 * Decompiled with CFR 0.152.
 */
package io.logz.logback;

import ch.qos.logback.classic.pattern.LineOfCallerConverter;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import com.google.common.base.Splitter;
import io.logz.logback-appender.sender.HttpsRequestConfiguration;
import io.logz.logback-appender.sender.LogzioSender;
import io.logz.logback-appender.sender.SenderStatusReporter;
import io.logz.logback-appender.sender.com.google.gson.Gson;
import io.logz.logback-appender.sender.com.google.gson.JsonElement;
import io.logz.logback-appender.sender.com.google.gson.JsonObject;
import io.logz.logback-appender.sender.exceptions.LogzioParameterErrorException;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LogzioLogbackAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final Gson gson = new Gson();
    private static final String TIMESTAMP = "@timestamp";
    private static final String LOGLEVEL = "loglevel";
    private static final String MARKER = "marker";
    private static final String MESSAGE = "message";
    private static final String LOGGER = "logger";
    private static final String LINE = "line";
    private static final String THREAD = "thread";
    private static final String EXCEPTION = "exception";
    private static final String FORMAT_TEXT = "text";
    private static final String FORMAT_JSON = "json";
    private static final int DONT_LIMIT_CAPACITY = -1;
    private static final int LOWER_PERCENTAGE_FS_SPACE = 1;
    private static final int UPPER_PERCENTAGE_FS_SPACE = 100;
    private static final Set<String> reservedFields = new HashSet<String>(Arrays.asList("@timestamp", "loglevel", "marker", "message", "logger", "thread", "exception"));
    private LogzioSender logzioSender;
    private ThrowableProxyConverter throwableProxyConverter;
    private LineOfCallerConverter lineOfCallerConverter;
    private Map<String, String> additionalFieldsMap = new HashMap<String, String>();
    private String logzioToken;
    private String logzioType = "java";
    private int drainTimeoutSec = 5;
    private int fileSystemFullPercentThreshold = 98;
    private String queueDir;
    private String logzioUrl;
    private int connectTimeout = 10000;
    private int socketTimeout = 10000;
    private boolean debug = false;
    private boolean addHostname = false;
    private boolean line = false;
    private boolean compressRequests = false;
    private boolean inMemoryQueue = false;
    private long inMemoryQueueCapacityBytes = 0x6400000L;
    private long inMemoryLogsCountCapacity = -1L;
    private int gcPersistedQueueFilesIntervalSeconds = 30;
    private String format = "text";
    private Encoder<ILoggingEvent> encoder = null;

    public void setEncoder(Encoder<ILoggingEvent> encoder) {
        this.encoder = encoder;
    }

    public Encoder<ILoggingEvent> getEncoder() {
        return this.encoder;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setToken(String logzioToken) {
        this.logzioToken = this.getValueFromSystemEnvironmentIfNeeded(logzioToken);
    }

    public void setLogzioType(String logzioType) {
        this.logzioType = logzioType;
    }

    public void setDrainTimeoutSec(int drainTimeoutSec) {
        if (drainTimeoutSec < 1) {
            this.drainTimeoutSec = 1;
            this.addInfo("Got unsupported drain timeout " + drainTimeoutSec + ". The timeout must be number greater then 1. I have set to 1 as fallback.");
        } else {
            this.drainTimeoutSec = drainTimeoutSec;
        }
    }

    public void setFileSystemFullPercentThreshold(int fileSystemFullPercentThreshold) {
        this.fileSystemFullPercentThreshold = fileSystemFullPercentThreshold;
    }

    @Deprecated
    public void setBufferDir(String bufferDir) {
        this.queueDir = bufferDir;
    }

    public void setQueueDir(String queueDir) {
        this.queueDir = queueDir;
    }

    public void setLogzioUrl(String logzioUrl) {
        this.logzioUrl = this.getValueFromSystemEnvironmentIfNeeded(logzioUrl);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setInMemoryQueue(boolean inMemoryQueue) {
        this.inMemoryQueue = inMemoryQueue;
    }

    public boolean isInMemoryQueue() {
        return this.inMemoryQueue;
    }

    public void setInMemoryQueueCapacityBytes(long inMemoryQueueCapacityBytes) {
        this.inMemoryQueueCapacityBytes = inMemoryQueueCapacityBytes;
    }

    public long getInMemoryQueueCapacityBytes() {
        return this.inMemoryQueueCapacityBytes;
    }

    public void setInMemoryLogsCountCapacity(long inMemoryLogsCountCapacity) {
        this.inMemoryLogsCountCapacity = inMemoryLogsCountCapacity;
    }

    @Deprecated
    public long getInMemoryLogsCountLimit() {
        return this.inMemoryLogsCountCapacity;
    }

    public long getInMemoryLogsCountCapacity() {
        return this.inMemoryLogsCountCapacity;
    }

    public boolean isCompressRequests() {
        return this.compressRequests;
    }

    public void setCompressRequests(boolean compressRequests) {
        this.compressRequests = compressRequests;
    }

    public void setAdditionalFields(String additionalFields) {
        if (additionalFields != null) {
            Splitter.on(';').omitEmptyStrings().withKeyValueSeparator('=').split(additionalFields).forEach((k, v) -> {
                if (reservedFields.contains(k)) {
                    this.addWarn("The field name '" + k + "' defined in additionalFields configuration can't be used since it's a reserved field name. This field will not be added to the outgoing log messages");
                } else {
                    String value = this.getValueFromSystemEnvironmentIfNeeded((String)v);
                    if (value != null) {
                        this.additionalFieldsMap.put((String)k, value);
                    }
                }
            });
            this.addInfo("The additional fields that would be added: " + this.additionalFieldsMap.toString());
        }
    }

    public boolean isAddHostname() {
        return this.addHostname;
    }

    public void setAddHostname(boolean addHostname) {
        this.addHostname = addHostname;
    }

    public boolean isLine() {
        return this.line;
    }

    public void setLine(boolean line) {
        this.line = line;
    }

    public void setGcPersistedQueueFilesIntervalSeconds(int gcPersistedQueueFilesIntervalSeconds) {
        this.gcPersistedQueueFilesIntervalSeconds = gcPersistedQueueFilesIntervalSeconds;
    }

    public void start() {
        HttpsRequestConfiguration conf;
        this.setHostname();
        try {
            conf = this.getHttpsRequestConfiguration();
        }
        catch (LogzioParameterErrorException e) {
            this.addError("Some of the configuration parameters of logz.io are wrong: " + e.getMessage(), e);
            return;
        }
        LogzioSender.Builder logzioSenderBuilder = this.getSenderBuilder(conf);
        if (this.inMemoryQueue) {
            if (!this.validateInMemoryThresholds()) {
                return;
            }
            logzioSenderBuilder.withInMemoryQueue().setCapacityInBytes(this.inMemoryQueueCapacityBytes).setLogsCountLimit(this.inMemoryLogsCountCapacity).endInMemoryQueue();
        } else {
            if (!this.validateFsPercentThreshold()) {
                return;
            }
            File queueDirFile = this.getQueueFile();
            if (queueDirFile == null) {
                return;
            }
            logzioSenderBuilder.withDiskQueue().setQueueDir(queueDirFile).setGcPersistedQueueFilesIntervalSeconds(this.gcPersistedQueueFilesIntervalSeconds).setFsPercentThreshold(this.fileSystemFullPercentThreshold).endDiskQueue();
        }
        try {
            this.logzioSender = logzioSenderBuilder.build();
        }
        catch (LogzioParameterErrorException e) {
            this.addError("Could not create logzio sender", e);
            return;
        }
        this.logzioSender.start();
        this.throwableProxyConverter = new ThrowableProxyConverter();
        this.lineOfCallerConverter = new LineOfCallerConverter();
        this.throwableProxyConverter.setOptionList(Collections.singletonList("full"));
        this.throwableProxyConverter.start();
        super.start();
    }

    private LogzioSender.Builder getSenderBuilder(HttpsRequestConfiguration conf) {
        return LogzioSender.builder().setDebug(this.debug).setDrainTimeoutSec(this.drainTimeoutSec).setHttpsRequestConfiguration(conf).setReporter(new StatusReporter()).setTasksExecutor(this.context.getScheduledExecutorService());
    }

    private File getQueueFile() {
        if (this.queueDir != null) {
            this.queueDir = this.queueDir + File.separator + this.logzioType;
            File queueFile = new File(this.queueDir);
            if (queueFile.exists()) {
                if (!queueFile.canWrite()) {
                    this.addError("We cant write to your queueDir location: " + queueFile.getAbsolutePath());
                    return null;
                }
            } else if (!queueFile.mkdirs()) {
                this.addError("We cant create your queueDir location: " + queueFile.getAbsolutePath());
                return null;
            }
        } else {
            this.queueDir = System.getProperty("java.io.tmpdir") + File.separator + "logzio-logback-queue" + File.separator + this.logzioType;
        }
        return new File(this.queueDir, "logzio-logback-appender");
    }

    private boolean validateInMemoryThresholds() {
        if (this.inMemoryQueueCapacityBytes <= 0L && this.inMemoryQueueCapacityBytes != -1L) {
            this.addError("inMemoryQueueCapacityBytes should be a non zero integer or -1");
            return false;
        }
        if (this.inMemoryLogsCountCapacity <= 0L && this.inMemoryLogsCountCapacity != -1L) {
            this.addError("inMemoryLogsCountCapacity should be a non zero integer or -1");
            return false;
        }
        return true;
    }

    private boolean validateFsPercentThreshold() {
        if ((this.fileSystemFullPercentThreshold < 1 || this.fileSystemFullPercentThreshold > 100) && this.fileSystemFullPercentThreshold != -1) {
            this.addError("fileSystemFullPercentThreshold should be a number between 1 and 100, or -1");
            return false;
        }
        return true;
    }

    private void setHostname() {
        try {
            if (this.addHostname) {
                String hostname = InetAddress.getLocalHost().getHostName();
                this.additionalFieldsMap.put("hostname", hostname);
            }
        }
        catch (UnknownHostException e) {
            this.addWarn("The configuration addHostName was specified but the host could not be resolved, thus the field 'hostname' will not be added", e);
        }
    }

    private HttpsRequestConfiguration getHttpsRequestConfiguration() throws LogzioParameterErrorException {
        return HttpsRequestConfiguration.builder().setLogzioListenerUrl(this.logzioUrl).setSocketTimeout(this.socketTimeout).setLogzioType(this.logzioType).setLogzioToken(this.logzioToken).setConnectTimeout(this.connectTimeout).setCompressRequests(this.compressRequests).build();
    }

    public void drainQueueAndSend() {
        if (this.logzioSender != null) {
            this.logzioSender.drainQueueAndSend();
        }
    }

    public void stop() {
        if (this.logzioSender != null) {
            this.logzioSender.stop();
        }
        if (this.throwableProxyConverter != null) {
            this.throwableProxyConverter.stop();
        }
        super.stop();
    }

    private String getValueFromSystemEnvironmentIfNeeded(String value) {
        if (value != null && value.startsWith("$")) {
            String variableName = value.replace("$", "");
            String envVariable = System.getenv(variableName);
            if (envVariable == null || envVariable.isEmpty()) {
                envVariable = System.getProperty(variableName);
            }
            return envVariable;
        }
        return value;
    }

    private void formatMessageAndSend(ILoggingEvent loggingEvent) {
        try {
            if (this.encoder == null) {
                this.logzioSender.send(this.formatMessageAsJsonInternal(loggingEvent));
            } else {
                this.logzioSender.send(this.encoder.encode((Object)loggingEvent));
            }
        }
        catch (Exception e) {
            this.addWarn("Failed to format and send message", e);
        }
    }

    private JsonObject formatMessageAsJsonInternal(ILoggingEvent loggingEvent) {
        JsonObject logMessage;
        if (this.format.equals(FORMAT_JSON)) {
            try {
                JsonElement jsonElement = gson.fromJson(loggingEvent.getFormattedMessage(), JsonElement.class);
                logMessage = jsonElement.getAsJsonObject();
            }
            catch (Exception e) {
                logMessage = new JsonObject();
                logMessage.addProperty(MESSAGE, loggingEvent.getFormattedMessage());
            }
        } else {
            logMessage = new JsonObject();
            logMessage.addProperty(MESSAGE, loggingEvent.getFormattedMessage());
        }
        if (loggingEvent.getMDCPropertyMap() != null) {
            loggingEvent.getMDCPropertyMap().forEach(logMessage::addProperty);
        }
        logMessage.addProperty(TIMESTAMP, new Date(loggingEvent.getTimeStamp()).toInstant().toString());
        logMessage.addProperty(LOGLEVEL, loggingEvent.getLevel().levelStr);
        if (loggingEvent.getMarker() != null) {
            logMessage.addProperty(MARKER, loggingEvent.getMarker().toString());
        }
        logMessage.addProperty(LOGGER, loggingEvent.getLoggerName());
        logMessage.addProperty(THREAD, loggingEvent.getThreadName());
        if (this.line) {
            logMessage.addProperty(LINE, this.lineOfCallerConverter.convert(loggingEvent));
        }
        if (loggingEvent.getThrowableProxy() != null) {
            logMessage.addProperty(EXCEPTION, this.throwableProxyConverter.convert(loggingEvent));
        }
        if (this.additionalFieldsMap != null) {
            this.additionalFieldsMap.forEach(logMessage::addProperty);
        }
        return logMessage;
    }

    protected void append(ILoggingEvent loggingEvent) {
        if (!loggingEvent.getLoggerName().contains("io.logz.logback-appender.sender")) {
            this.formatMessageAndSend(loggingEvent);
        }
    }

    private class StatusReporter
    implements SenderStatusReporter {
        private StatusReporter() {
        }

        @Override
        public void error(String msg) {
            LogzioLogbackAppender.this.addError(msg);
        }

        @Override
        public void error(String msg, Throwable e) {
            LogzioLogbackAppender.this.addError(msg, e);
        }

        @Override
        public void warning(String msg) {
            LogzioLogbackAppender.this.addWarn(msg);
        }

        @Override
        public void warning(String msg, Throwable e) {
            LogzioLogbackAppender.this.addWarn(msg, e);
        }

        @Override
        public void info(String msg) {
            LogzioLogbackAppender.this.addInfo(msg);
        }

        @Override
        public void info(String msg, Throwable e) {
            LogzioLogbackAppender.this.addInfo(msg, e);
        }
    }
}

