/*
 * Decompiled with CFR 0.152.
 */
package io.logz.logback-appender.sender.org.kairosdb.metrics4j;

import io.logz.logback-appender.sender.org.kairosdb.metrics4j.MetricsContext;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.annotation.Help;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.collectors.MetricCollector;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.configuration.MetricConfig;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.ArgKey;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.CustomArgKey;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.DoubleLambdaCollectorAdaptor;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.LambdaArgKey;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.LongLambdaCollectorAdaptor;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.MethodArgKey;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.SourceInvocationHandler;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.StaticCollectorCollection;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.TagKey;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.DoubleSupplier;
import java.util.function.LongSupplier;

public class MetricSourceManager {
    private static Map<Class, SourceInvocationHandler> s_invocationMap = new ConcurrentHashMap<Class, SourceInvocationHandler>();
    private static Map<ArgKey, StaticCollectorCollection> s_staticCollectors = new ConcurrentHashMap<ArgKey, StaticCollectorCollection>();
    private static MetricConfig s_metricConfig;

    public static void setMetricConfig(MetricConfig config) {
        s_metricConfig = config;
        s_invocationMap.clear();
    }

    public static void clearConfig() {
        s_metricConfig = null;
        s_invocationMap.clear();
    }

    public static MetricConfig getMetricConfig() {
        if (s_metricConfig == null) {
            try {
                s_metricConfig = MetricConfig.parseConfig("metrics4j.conf", "metrics4j.properties");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return s_metricConfig;
    }

    public static void registerMetricCollector(MetricCollector collector) {
        CustomArgKey key = new CustomArgKey(collector);
    }

    public static <T> T getSource(Class<T> tClass) {
        InvocationHandler handler = s_invocationMap.computeIfAbsent(tClass, klass -> {
            MetricConfig metricConfig = MetricSourceManager.getMetricConfig();
            if (metricConfig.isDumpMetrics()) {
                Method[] methods;
                String className = klass.getName();
                for (Method method : methods = klass.getMethods()) {
                    String helpText = "";
                    if (method.isAnnotationPresent(Help.class)) {
                        helpText = method.getAnnotation(Help.class).value();
                    }
                    metricConfig.addDumpSource(className + "." + method.getName(), helpText);
                }
            }
            return new SourceInvocationHandler(metricConfig);
        });
        Object proxyInstance = Proxy.newProxyInstance(tClass.getClassLoader(), new Class[]{tClass}, handler);
        return (T)proxyInstance;
    }

    public static void addSource(Object o, Map<String, String> tags) {
    }

    public static void removeSource(String className, String methodName, Map<String, String> tags) {
        LambdaArgKey key = new LambdaArgKey(className, methodName);
        StaticCollectorCollection collection = s_staticCollectors.get(key);
        if (collection != null) {
            collection.removeCollector(MetricSourceManager.buildTagKey(tags));
        }
    }

    private static TagKey buildTagKey(Map<String, String> tags) {
        TreeMap<String, String> sortedTags = new TreeMap<String, String>(tags);
        TagKey.Builder builder = TagKey.newBuilder();
        for (String tagKey : sortedTags.keySet()) {
            builder.addTag(tagKey, (String)sortedTags.get(tagKey));
        }
        return builder.build();
    }

    public static void addSource(String className, String methodName, Map<String, String> tags, String help, MetricCollector collector) {
        LambdaArgKey key = new LambdaArgKey(className, methodName);
        MetricConfig metricConfig = MetricSourceManager.getMetricConfig();
        if (metricConfig.isDumpMetrics()) {
            metricConfig.addDumpSource(className + "." + methodName, null);
        }
        if (metricConfig.isDisabled(key)) {
            return;
        }
        StaticCollectorCollection collection = s_staticCollectors.computeIfAbsent(key, k -> {
            StaticCollectorCollection staticCollection = new StaticCollectorCollection((ArgKey)k);
            MetricsContext context = metricConfig.getContext();
            Map<String, String> configTags = metricConfig.getTagsForKey(key);
            if (tags != null) {
                configTags.putAll(tags);
            }
            context.assignCollector(key, staticCollection, configTags, metricConfig.getPropsForKey(key), null, help);
            return staticCollection;
        });
        collection.addCollector(MetricSourceManager.buildTagKey(tags), collector);
    }

    public static void addSource(String className, String methodName, Map<String, String> tags, String help, LongSupplier supplier) {
        MetricSourceManager.addSource(className, methodName, tags, help, new LongLambdaCollectorAdaptor(supplier));
    }

    public static void addSource(String className, String methodName, Map<String, String> tags, String help, DoubleSupplier supplier) {
        MetricSourceManager.addSource(className, methodName, tags, help, new DoubleLambdaCollectorAdaptor(supplier));
    }

    public static <T> T setCollectorForSource(MetricCollector stats, Class<T> reporterClass) {
        MetricConfig metricConfig = MetricSourceManager.getMetricConfig();
        SourceInvocationHandler handler = s_invocationMap.computeIfAbsent(reporterClass, klass -> new SourceInvocationHandler(metricConfig));
        Object proxyInstance = Proxy.newProxyInstance(reporterClass.getClassLoader(), new Class[]{reporterClass}, (proxy, method, args) -> {
            handler.setCollector(new MethodArgKey(method, args), stats);
            return null;
        });
        return (T)proxyInstance;
    }

    public MetricsContext getMetricsContext() {
        return null;
    }
}

