/*
 * Decompiled with CFR 0.152.
 */
package io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal;

import io.logz.logback-appender.sender.org.kairosdb.metrics4j.configuration.MissingReferenceException;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.ArgKey;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.ComponentTracker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ListComponentTracker<T>
extends ComponentTracker<T> {
    private final Map<List<String>, List<T>> m_mappedComponents = new HashMap<List<String>, List<T>>();

    public ListComponentTracker(String componentType) {
        super(componentType);
    }

    @Override
    public void addToPath(String name, List<String> path) {
        Object component = this.m_components.get(name);
        if (component == null) {
            throw new MissingReferenceException(this.m_componentType, name);
        }
        List componentList = this.m_mappedComponents.computeIfAbsent(path, k -> new ArrayList());
        componentList.add(component);
    }

    public List<T> getComponentsForKey(ArgKey key) {
        ArrayList<T> ret = new ArrayList<T>();
        List<String> configPath = key.getConfigPath();
        for (int i = configPath.size(); i >= 0; --i) {
            ArrayList<String> searchPath = new ArrayList<String>(configPath.subList(0, i));
            List<T> objects = this.m_mappedComponents.get(searchPath);
            if (objects == null) continue;
            ret.addAll(objects);
        }
        return ret;
    }
}

