/*
 * Decompiled with CFR 0.152.
 */
package io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal;

import io.logz.logback-appender.sender.org.kairosdb.metrics4j.CollectorNotification;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.FormatterNotification;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.MetricsContext;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.SinkNotification;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.TriggerNotification;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.collectors.Collector;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.formatters.Formatter;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.ArgKey;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.AssignedFormatter;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.CollectorCollection;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.CollectorContainer;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.ComponentTracker;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.ListComponentTracker;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.NeverTrigger;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.SinkQueue;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.TriggerMetricCollection;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.sinks.MetricSink;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.triggers.Trigger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetricsContextImpl
implements MetricsContext {
    private final ListComponentTracker<SinkQueue> m_sinks = new ListComponentTracker("sink");
    private final ListComponentTracker<Collector> m_collectors = new ListComponentTracker("collector");
    private final ListComponentTracker<AssignedFormatter> m_formatters = new ListComponentTracker("formatter");
    private final ComponentTracker<TriggerMetricCollection> m_triggers = new ComponentTracker("trigger");

    public void addCollectorToPath(String name, List<String> path) {
        this.m_collectors.addToPath(name, path);
    }

    @Override
    public void addSinkToPath(String name, List<String> path) {
        this.m_sinks.addToPath(name, path);
    }

    public void addFormatterToPath(String name, List<String> path) {
        this.m_formatters.addToPath(name, path);
    }

    @Override
    public void addTriggerToPath(String name, List<String> path) {
        this.m_triggers.addToPath(name, path);
    }

    @Override
    public void registerSink(String name, MetricSink sink) {
        sink.init(this);
        this.m_sinks.addComponent(name, new SinkQueue(sink, name));
    }

    @Override
    public void registerCollector(String name, Collector collector) {
        collector.init(this);
        this.m_collectors.addComponent(name, collector);
    }

    @Override
    public void registerFormatter(String name, Formatter formatter) {
        formatter.init(this);
        this.m_formatters.addComponent(name, new AssignedFormatter(formatter, "*"));
    }

    public void registerAssignedFormatter(String name, Formatter formatter, String sinkName) {
        formatter.init(this);
        this.m_formatters.addComponent(name, new AssignedFormatter(formatter, sinkName));
    }

    @Override
    public void registerTrigger(String name, Trigger trigger) {
        trigger.init(this);
        this.m_triggers.addComponent(name, new TriggerMetricCollection(trigger));
    }

    public MetricSink getSink(String name) {
        SinkQueue sinkQueue = (SinkQueue)this.m_sinks.getComponent(name);
        if (sinkQueue != null) {
            return sinkQueue.getSink();
        }
        return null;
    }

    @Override
    public List<Collector> getCollectorsForKey(ArgKey key) {
        List<Collector> ret = this.m_collectors.getComponentsForKey(key);
        if (ret != null) {
            return ret;
        }
        return Collections.emptyList();
    }

    private TriggerMetricCollection getTriggerForKey(ArgKey key) {
        TriggerMetricCollection triggerMetricCollection = this.m_triggers.getComponentForKey(key);
        if (triggerMetricCollection == null) {
            triggerMetricCollection = new TriggerMetricCollection(new NeverTrigger());
        }
        return triggerMetricCollection;
    }

    public Collector getCollector(String name) {
        Collector collector = (Collector)this.m_collectors.getComponent(name);
        return collector;
    }

    public Formatter getFormatter(String name) {
        return ((AssignedFormatter)this.m_formatters.getComponent(name)).getFormatter();
    }

    public Trigger getTrigger(String name) {
        return this.m_triggers.getComponent(name).getTrigger();
    }

    @Override
    public void assignCollector(ArgKey key, CollectorCollection collectors, Map<String, String> collectorTags, Map<String, String> properties, String metricName, String help) {
        CollectorContainer collectorContainer = new CollectorContainer(collectors, key);
        if (metricName != null) {
            collectorContainer.setMetricName(metricName);
        }
        collectorContainer.setTags(collectorTags);
        collectorContainer.setProps(properties);
        collectorContainer.setHelp(help);
        List<AssignedFormatter> formatters = this.m_formatters.getComponentsForKey(key);
        List<SinkQueue> sinkQueues = this.m_sinks.getComponentsForKey(key);
        HashMap<String, Formatter> collectorFormatters = new HashMap<String, Formatter>();
        block0: for (SinkQueue sinkQueue : sinkQueues) {
            String sinkName = sinkQueue.getSinkName();
            for (AssignedFormatter formatter : formatters) {
                if (!formatter.getSinkRef().equals("*") && !formatter.getSinkRef().equals(sinkName)) continue;
                collectorFormatters.put(sinkName, formatter.getFormatter());
                continue block0;
            }
        }
        collectorContainer.setFormatters(collectorFormatters);
        collectorContainer.addSinkQueue(sinkQueues);
        TriggerMetricCollection trigger = this.getTriggerForKey(key);
        trigger.addCollector(collectorContainer);
    }

    @Override
    public void registerSinkNotification(SinkNotification notification) {
        this.m_sinks.addComponentListener((name, sink) -> notification.newSink(name, sink.getSink()));
    }

    @Override
    public void registerTriggerNotification(TriggerNotification notification) {
        this.m_triggers.addComponentListener((name, trigger) -> notification.newTrigger(name, trigger.getTrigger()));
    }

    @Override
    public void registerFormatterNotification(FormatterNotification notification) {
        this.m_formatters.addComponentListener((name, formatter) -> notification.newFormatter(name, formatter.getFormatter()));
    }

    @Override
    public void registerCollectorNotification(CollectorNotification notification) {
        this.m_collectors.addComponentListener((name, collector) -> notification.newCollector(name, (Collector)collector));
    }

    public String toString() {
        return "MetricsContextImpl(m_sinks=" + this.m_sinks + ", m_collectors=" + this.m_collectors + ", m_formatters=" + this.m_formatters + ", m_triggers=" + this.m_triggers + ")";
    }
}

