/*
 * Decompiled with CFR 0.152.
 */
package io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal;

import io.logz.logback-appender.sender.org.kairosdb.metrics4j.annotation.Help;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.collectors.Collector;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.collectors.MetricCollector;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.configuration.ImplementationException;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.configuration.MetricConfig;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.CollectorCollection;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.CollectorCollectionAdapter;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.DevNullCollector;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.DevNullCollectorCollection;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.MethodArgKey;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.TagKey;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceInvocationHandler
implements InvocationHandler {
    private static Logger log = LoggerFactory.getLogger(SourceInvocationHandler.class);
    public static final String COLLECTOR_PACKAGE = "io.logz.logback-appender.sender.org.kairosdb.metrics4j.collectors";
    private final Map<MethodArgKey, CollectorCollection> m_statsMap = new ConcurrentHashMap<MethodArgKey, CollectorCollection>();
    private final MetricConfig m_config;

    public SourceInvocationHandler(MetricConfig config) {
        this.m_config = config;
    }

    private CollectorCollection getCollectorCollection(MethodArgKey key) {
        return this.m_statsMap.computeIfAbsent(key, k -> this.lookupCollectorClass((MethodArgKey)k));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MethodArgKey key = new MethodArgKey(method, args);
        TagKey tagKey = key.getTagKey();
        CollectorCollection collection = this.getCollectorCollection(key);
        MetricCollector ret = collection.getCollector(tagKey);
        return ret;
    }

    public void setCollector(MethodArgKey key, MetricCollector statsObject) {
        Class<?> returnType = key.getMethod().getReturnType();
        if (!returnType.isAssignableFrom(statsObject.getClass())) {
            throw new IllegalArgumentException("The collectors object " + statsObject.getClass().getName() + " does not match return type for method " + key.getMethod().getName() + " which should be " + returnType.getName());
        }
        CollectorCollection collection = this.m_statsMap.get(key);
        if (collection == null || !(collection instanceof CollectorCollectionAdapter)) {
            collection = new CollectorCollectionAdapter(new DevNullCollector(), key);
            this.m_statsMap.put(key, collection);
        }
        ((CollectorCollectionAdapter)collection).addCollector(key.getTagKey(), statsObject);
    }

    private CollectorCollection lookupCollectorClass(MethodArgKey key) {
        if (this.m_config.isDisabled(key)) {
            return new DevNullCollectorCollection();
        }
        Class<?> returnType = key.getMethod().getReturnType();
        String className = returnType.getName();
        if (!COLLECTOR_PACKAGE.equals(className.substring(0, className.lastIndexOf(46)))) {
            throw new ImplementationException("You have specified a return type on " + key.getClassName() + "." + key.getMethodName() + " that is not a generic collector interface as found in " + COLLECTOR_PACKAGE);
        }
        CollectorCollection ret = null;
        Iterator<Collector> collectors = this.m_config.getContext().getCollectorsForKey(key).iterator();
        String helpText = "";
        Method method = key.getMethod();
        if (method.isAnnotationPresent(Help.class)) {
            Help help = method.getAnnotation(Help.class);
            helpText = help.value();
        }
        while (collectors.hasNext()) {
            Collector collector = collectors.next();
            if (!returnType.isInstance(collector)) continue;
            ret = new CollectorCollectionAdapter(collector, key);
            Map<String, String> tagsForKey = this.m_config.getTagsForKey(key);
            this.m_config.getContext().assignCollector(key, ret, tagsForKey, this.m_config.getPropsForKey(key), this.m_config.getMetricNameForKey(key), helpText);
            break;
        }
        if (ret == null) {
            log.info("Unable to find collector for " + key);
            ret = new DevNullCollectorCollection();
        }
        return ret;
    }
}

