/*
 * Decompiled with CFR 0.152.
 */
package io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal;

import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.CollectorContainer;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.SinkQueue;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.triggers.MetricCollection;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.triggers.Trigger;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;

public class TriggerMetricCollection
implements MetricCollection {
    private final Trigger m_trigger;
    private List<CollectorContainer> m_collectors;
    private Set<SinkQueue> m_sinkQueues;

    public TriggerMetricCollection(Trigger trigger) {
        this.m_trigger = trigger;
        this.m_trigger.setMetricCollection(this);
        this.m_collectors = new CopyOnWriteArrayList<CollectorContainer>();
        this.m_sinkQueues = new CopyOnWriteArraySet<SinkQueue>();
    }

    public Trigger getTrigger() {
        return this.m_trigger;
    }

    public void addCollector(CollectorContainer collector) {
        this.m_collectors.add(collector);
        this.m_sinkQueues.addAll(collector.getSinkQueueList());
    }

    @Override
    public void reportMetrics(Instant now) {
        for (CollectorContainer collector : this.m_collectors) {
            collector.reportMetrics(now);
        }
        for (SinkQueue sinkQueue : this.m_sinkQueues) {
            sinkQueue.flush();
        }
    }
}

