/*
 * Decompiled with CFR 0.152.
 */
package io.logz.logback-appender.sender.org.kairosdb.bigqueue;

import io.logz.logback-appender.sender.org.kairosdb.bigqueue.IBigArray;
import io.logz.logback-appender.sender.org.kairosdb.bigqueue.metrics.BigArrayStats;
import io.logz.logback-appender.sender.org.kairosdb.bigqueue.page.IMappedPage;
import io.logz.logback-appender.sender.org.kairosdb.bigqueue.page.IMappedPageFactory;
import io.logz.logback-appender.sender.org.kairosdb.bigqueue.page.MappedPageFactoryImpl;
import io.logz.logback-appender.sender.org.kairosdb.bigqueue.utils.Calculator;
import io.logz.logback-appender.sender.org.kairosdb.bigqueue.utils.Clock;
import io.logz.logback-appender.sender.org.kairosdb.bigqueue.utils.FileUtil;
import io.logz.logback-appender.sender.org.kairosdb.bigqueue.utils.SystemClockImpl;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.MetricSourceManager;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BigArrayImpl
implements IBigArray {
    private final BigArrayStats stats = MetricSourceManager.getSource(BigArrayStats.class);
    static final String INDEX_PAGE_FOLDER = "index";
    static final String DATA_PAGE_FOLDER = "data";
    static final String META_DATA_PAGE_FOLDER = "meta_data";
    static final int INDEX_ITEMS_PER_PAGE_BITS = 17;
    static final int INDEX_ITEMS_PER_PAGE = 131072;
    static final int INDEX_ITEM_LENGTH_BITS = 5;
    static final int INDEX_ITEM_LENGTH = 32;
    static final int INDEX_PAGE_SIZE = 0x400000;
    final int DATA_PAGE_SIZE;
    public static final int DEFAULT_DATA_PAGE_SIZE = 0x8000000;
    public static final int MINIMUM_DATA_PAGE_SIZE = 0x2000000;
    static final int INDEX_PAGE_CACHE_TTL = 1000;
    static final int DATA_PAGE_CACHE_TTL = 1000;
    static final int META_DATA_ITEM_LENGTH_BITS = 4;
    static final int META_DATA_PAGE_SIZE = 16;
    private static final int INDEX_ITEM_DATA_ITEM_LENGTH_OFFSET = 12;
    static final int INDEX_ITEM_DATA_ITEM_TIMESTAMP_OFFSET = 16;
    String arrayDirectory;
    final String arrayName;
    IMappedPageFactory indexPageFactory;
    IMappedPageFactory dataPageFactory;
    IMappedPageFactory metaPageFactory;
    static final long META_DATA_PAGE_INDEX = 0L;
    final AtomicLong arrayHeadIndex = new AtomicLong();
    final AtomicLong arrayTailIndex = new AtomicLong();
    long headDataPageIndex;
    int headDataItemOffset;
    Clock clock = new SystemClockImpl();
    final Lock appendLock = new ReentrantLock();
    final ReadWriteLock arrayReadWritelock = new ReentrantReadWriteLock();
    final Lock arrayReadLock = this.arrayReadWritelock.readLock();
    final Lock arrayWriteLock = this.arrayReadWritelock.writeLock();

    public BigArrayImpl(String arrayDir, String arrayName) throws IOException {
        this(arrayDir, arrayName, 0x8000000);
    }

    public BigArrayImpl(String arrayDir, String arrayName, int pageSize) throws IOException {
        this.arrayDirectory = arrayDir;
        if (!this.arrayDirectory.endsWith(File.separator)) {
            this.arrayDirectory = this.arrayDirectory + File.separator;
        }
        this.arrayDirectory = this.arrayDirectory + arrayName + File.separator;
        this.arrayName = arrayName;
        if (!FileUtil.isFilenameValid(this.arrayDirectory)) {
            throw new IllegalArgumentException("invalid array directory : " + this.arrayDirectory);
        }
        if (pageSize < 0x2000000) {
            throw new IllegalArgumentException("invalid page size, allowed minimum is : 33554432 bytes.");
        }
        this.DATA_PAGE_SIZE = pageSize;
        this.commonInit();
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("name", arrayName);
        MetricSourceManager.addSource(BigArrayStats.class.getName(), "arraySize", tags, "Reports size of the array", () -> this.size());
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public String getArrayDirectory() {
        return this.arrayDirectory;
    }

    void commonInit() throws IOException {
        this.indexPageFactory = new MappedPageFactoryImpl(0x400000, this.arrayDirectory + INDEX_PAGE_FOLDER, 1000L);
        this.dataPageFactory = new MappedPageFactoryImpl(this.DATA_PAGE_SIZE, this.arrayDirectory + DATA_PAGE_FOLDER, 1000L);
        this.metaPageFactory = new MappedPageFactoryImpl(16, this.arrayDirectory + META_DATA_PAGE_FOLDER, 10000L);
        this.initArrayIndex();
        this.initDataPageIndex();
    }

    @Override
    public void removeAll() throws IOException {
        try {
            this.arrayWriteLock.lock();
            this.indexPageFactory.deleteAllPages();
            this.dataPageFactory.deleteAllPages();
            this.metaPageFactory.deleteAllPages();
            this.commonInit();
        }
        finally {
            this.arrayWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBeforeIndex(long index) throws IOException {
        try {
            this.arrayWriteLock.lock();
            this.validateIndex(index);
            long indexPageIndex = Calculator.div(index, 17);
            ByteBuffer indexItemBuffer = this.getIndexItemBuffer(index);
            long dataPageIndex = indexItemBuffer.getLong();
            if (indexPageIndex > 0L) {
                this.indexPageFactory.deletePagesBeforePageIndex(indexPageIndex);
            }
            if (dataPageIndex > 0L) {
                this.dataPageFactory.deletePagesBeforePageIndex(dataPageIndex);
            }
            this.arrayTailIndex.set(index);
        }
        finally {
            this.arrayWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBefore(long timestamp) throws IOException {
        try {
            this.arrayWriteLock.lock();
            long firstIndexPageIndex = this.indexPageFactory.getFirstPageIndexBefore(timestamp);
            if (firstIndexPageIndex >= 0L) {
                long toRemoveBeforeIndex = Calculator.mul(firstIndexPageIndex, 17);
                this.removeBeforeIndex(toRemoveBeforeIndex);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        finally {
            this.arrayWriteLock.unlock();
        }
    }

    void initArrayIndex() throws IOException {
        IMappedPage metaDataPage = this.metaPageFactory.acquirePage(0L);
        ByteBuffer metaBuf = metaDataPage.getLocal(0);
        long head = metaBuf.getLong();
        long tail = metaBuf.getLong();
        this.arrayHeadIndex.set(head);
        this.arrayTailIndex.set(tail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initDataPageIndex() throws IOException {
        if (this.isEmpty()) {
            this.headDataPageIndex = 0L;
            this.headDataItemOffset = 0;
        } else {
            IMappedPage previousIndexPage = null;
            long previousIndexPageIndex = -1L;
            try {
                long previousIndex = this.arrayHeadIndex.get() - 1L;
                previousIndexPageIndex = Calculator.div(previousIndex, 17);
                previousIndexPage = this.indexPageFactory.acquirePage(previousIndexPageIndex);
                int previousIndexPageOffset = (int)Calculator.mul(Calculator.mod(previousIndex, 17), 5);
                ByteBuffer previousIndexItemBuffer = previousIndexPage.getLocal(previousIndexPageOffset);
                long previousDataPageIndex = previousIndexItemBuffer.getLong();
                int previousDataItemOffset = previousIndexItemBuffer.getInt();
                int perviousDataItemLength = previousIndexItemBuffer.getInt();
                this.headDataPageIndex = previousDataPageIndex;
                this.headDataItemOffset = previousDataItemOffset + perviousDataItemLength;
            }
            finally {
                if (previousIndexPage != null) {
                    this.indexPageFactory.releasePage(previousIndexPageIndex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long append(byte[] data) throws IOException {
        try {
            this.stats.appendData(this.arrayName).put(data.length);
            this.arrayReadLock.lock();
            IMappedPage toAppendDataPage = null;
            IMappedPage toAppendIndexPage = null;
            long toAppendIndexPageIndex = -1L;
            long toAppendDataPageIndex = -1L;
            long toAppendArrayIndex = -1L;
            try {
                this.appendLock.lock();
                if (this.headDataItemOffset + data.length > this.DATA_PAGE_SIZE) {
                    ++this.headDataPageIndex;
                    this.headDataItemOffset = 0;
                }
                toAppendDataPageIndex = this.headDataPageIndex;
                int toAppendDataItemOffset = this.headDataItemOffset;
                toAppendArrayIndex = this.arrayHeadIndex.get();
                toAppendDataPage = this.dataPageFactory.acquirePage(toAppendDataPageIndex);
                ByteBuffer toAppendDataPageBuffer = toAppendDataPage.getLocal(toAppendDataItemOffset);
                toAppendDataPageBuffer.put(data);
                toAppendDataPage.setDirty(true);
                this.headDataItemOffset += data.length;
                toAppendIndexPageIndex = Calculator.div(toAppendArrayIndex, 17);
                toAppendIndexPage = this.indexPageFactory.acquirePage(toAppendIndexPageIndex);
                int toAppendIndexItemOffset = (int)Calculator.mul(Calculator.mod(toAppendArrayIndex, 17), 5);
                ByteBuffer toAppendIndexPageBuffer = toAppendIndexPage.getLocal(toAppendIndexItemOffset);
                toAppendIndexPageBuffer.putLong(toAppendDataPageIndex);
                toAppendIndexPageBuffer.putInt(toAppendDataItemOffset);
                toAppendIndexPageBuffer.putInt(data.length);
                long currentTime = this.clock.getTime();
                toAppendIndexPageBuffer.putLong(currentTime);
                toAppendIndexPage.setDirty(true);
                this.arrayHeadIndex.incrementAndGet();
                IMappedPage metaDataPage = this.metaPageFactory.acquirePage(0L);
                ByteBuffer metaDataBuf = metaDataPage.getLocal(0);
                metaDataBuf.putLong(this.arrayHeadIndex.get());
                metaDataBuf.putLong(this.arrayTailIndex.get());
                metaDataPage.setDirty(true);
            }
            finally {
                this.appendLock.unlock();
                if (toAppendDataPage != null) {
                    this.dataPageFactory.releasePage(toAppendDataPageIndex);
                }
                if (toAppendIndexPage != null) {
                    this.indexPageFactory.releasePage(toAppendIndexPageIndex);
                }
            }
            long l = toAppendArrayIndex;
            return l;
        }
        finally {
            this.arrayReadLock.unlock();
        }
    }

    @Override
    public void flush() {
        try {
            this.arrayReadLock.lock();
            this.metaPageFactory.flush();
            this.indexPageFactory.flush();
            this.dataPageFactory.flush();
        }
        finally {
            this.arrayReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get(long index) throws IOException {
        try {
            this.arrayReadLock.lock();
            this.validateIndex(index);
            IMappedPage dataPage = null;
            long dataPageIndex = -1L;
            try {
                ByteBuffer indexItemBuffer = this.getIndexItemBuffer(index);
                dataPageIndex = indexItemBuffer.getLong();
                int dataItemOffset = indexItemBuffer.getInt();
                int dataItemLength = indexItemBuffer.getInt();
                dataPage = this.dataPageFactory.acquirePage(dataPageIndex);
                byte[] data = dataPage.getLocal(dataItemOffset, dataItemLength);
                this.stats.getData(this.arrayName).put(data.length);
                byte[] byArray = data;
                if (dataPage != null) {
                    this.dataPageFactory.releasePage(dataPageIndex);
                }
                return byArray;
            }
            catch (Throwable throwable) {
                if (dataPage != null) {
                    this.dataPageFactory.releasePage(dataPageIndex);
                }
                throw throwable;
            }
        }
        finally {
            this.arrayReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimestamp(long index) throws IOException {
        try {
            long ts;
            this.arrayReadLock.lock();
            this.validateIndex(index);
            ByteBuffer indexItemBuffer = this.getIndexItemBuffer(index);
            int position = indexItemBuffer.position();
            indexItemBuffer.position(position + 16);
            long l = ts = indexItemBuffer.getLong();
            return l;
        }
        finally {
            this.arrayReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuffer getIndexItemBuffer(long index) throws IOException {
        IMappedPage indexPage = null;
        long indexPageIndex = -1L;
        try {
            ByteBuffer indexItemBuffer;
            indexPageIndex = Calculator.div(index, 17);
            indexPage = this.indexPageFactory.acquirePage(indexPageIndex);
            int indexItemOffset = (int)Calculator.mul(Calculator.mod(index, 17), 5);
            ByteBuffer byteBuffer = indexItemBuffer = indexPage.getLocal(indexItemOffset);
            return byteBuffer;
        }
        finally {
            if (indexPage != null) {
                this.indexPageFactory.releasePage(indexPageIndex);
            }
        }
    }

    void validateIndex(long index) {
        if (this.arrayTailIndex.get() <= this.arrayHeadIndex.get() ? index < this.arrayTailIndex.get() || index >= this.arrayHeadIndex.get() : index < this.arrayTailIndex.get() && index >= this.arrayHeadIndex.get()) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds [" + this.arrayTailIndex.get() + " - " + this.arrayHeadIndex.get() + "]");
        }
    }

    @Override
    public long size() {
        try {
            this.arrayReadLock.lock();
            long l = this.arrayHeadIndex.get() - this.arrayTailIndex.get();
            return l;
        }
        finally {
            this.arrayReadLock.unlock();
        }
    }

    @Override
    public long getHeadIndex() {
        try {
            this.arrayReadLock.lock();
            long l = this.arrayHeadIndex.get();
            return l;
        }
        finally {
            this.arrayReadLock.unlock();
        }
    }

    @Override
    public long getTailIndex() {
        try {
            this.arrayReadLock.lock();
            long l = this.arrayTailIndex.get();
            return l;
        }
        finally {
            this.arrayReadLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            this.arrayReadLock.lock();
            boolean bl = this.arrayHeadIndex.get() == this.arrayTailIndex.get();
            return bl;
        }
        finally {
            this.arrayReadLock.unlock();
        }
    }

    @Override
    public boolean isFull() {
        return false;
    }

    @Override
    public void close() throws IOException {
        try {
            this.arrayWriteLock.lock();
            if (this.metaPageFactory != null) {
                this.metaPageFactory.releaseCachedPages();
            }
            if (this.indexPageFactory != null) {
                this.indexPageFactory.releaseCachedPages();
            }
            if (this.dataPageFactory != null) {
                this.dataPageFactory.releaseCachedPages();
            }
        }
        finally {
            this.arrayWriteLock.unlock();
        }
    }

    @Override
    public int getDataPageSize() {
        return this.DATA_PAGE_SIZE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long findClosestIndex(long timestamp) throws IOException {
        try {
            this.arrayReadLock.lock();
            long closestIndex = -1L;
            long tailIndex = this.arrayTailIndex.get();
            long headIndex = this.arrayHeadIndex.get();
            if (tailIndex == headIndex) {
                long l = closestIndex;
                return l;
            }
            long lastIndex = headIndex;
            if (lastIndex < 0L) {
                lastIndex = Long.MAX_VALUE;
            }
            if (tailIndex < lastIndex) {
                closestIndex = this.closestBinarySearch(tailIndex, lastIndex, timestamp);
            } else {
                long lowPartClosestIndex = this.closestBinarySearch(0L, lastIndex, timestamp);
                long highPartClosetIndex = this.closestBinarySearch(tailIndex, Long.MAX_VALUE, timestamp);
                long lowPartTimestamp = this.getTimestamp(lowPartClosestIndex);
                long highPartTimestamp = this.getTimestamp(highPartClosetIndex);
                closestIndex = Math.abs(timestamp - lowPartTimestamp) < Math.abs(timestamp - highPartTimestamp) ? lowPartClosestIndex : highPartClosetIndex;
            }
            long l = closestIndex;
            return l;
        }
        finally {
            this.arrayReadLock.unlock();
        }
    }

    private long closestBinarySearch(long low, long high, long timestamp) throws IOException {
        long dif = high - low;
        long mid = dif / 2L + low;
        long midTimestamp = this.getTimestamp(mid);
        if (midTimestamp < timestamp) {
            long nextLow = mid + 1L;
            if (nextLow >= high) {
                return mid;
            }
            return this.closestBinarySearch(mid, high, timestamp);
        }
        if (midTimestamp > timestamp) {
            long nextHigh = mid - 1L;
            if (nextHigh <= low) {
                return low;
            }
            return this.closestBinarySearch(low, mid, timestamp);
        }
        return mid;
    }

    @Override
    public long getBackFileSize() throws IOException {
        try {
            this.arrayReadLock.lock();
            long l = this._getBackFileSize();
            return l;
        }
        finally {
            this.arrayReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void limitBackFileSize(long sizeLimit) throws IOException {
        if (sizeLimit < (long)(0x400000 + this.DATA_PAGE_SIZE)) {
            return;
        }
        long backFileSize = this.getBackFileSize();
        if (backFileSize <= sizeLimit) {
            return;
        }
        long toTruncateSize = backFileSize - sizeLimit;
        if (toTruncateSize < (long)this.DATA_PAGE_SIZE) {
            return;
        }
        try {
            this.arrayWriteLock.lock();
            backFileSize = this._getBackFileSize();
            if (backFileSize <= sizeLimit) {
                return;
            }
            toTruncateSize = backFileSize - sizeLimit;
            if (toTruncateSize < (long)this.DATA_PAGE_SIZE) {
                return;
            }
            long tailIndex = this.arrayTailIndex.get();
            long headIndex = this.arrayHeadIndex.get();
            long totalLength = 0L;
            while (tailIndex != headIndex && (totalLength += (long)this.getDataItemLength(tailIndex)) <= toTruncateSize) {
                if (Calculator.mod(++tailIndex, 17) != 0L) continue;
                totalLength += 0x400000L;
            }
            this.removeBeforeIndex(tailIndex);
        }
        finally {
            this.arrayWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getItemLength(long index) throws IOException {
        try {
            this.arrayReadLock.lock();
            this.validateIndex(index);
            int n = this.getDataItemLength(index);
            return n;
        }
        finally {
            this.arrayReadLock.unlock();
        }
    }

    private int getDataItemLength(long index) throws IOException {
        ByteBuffer indexItemBuffer = this.getIndexItemBuffer(index);
        int position = indexItemBuffer.position();
        indexItemBuffer.position(position + 12);
        int length = indexItemBuffer.getInt();
        return length;
    }

    private long _getBackFileSize() throws IOException {
        return this.indexPageFactory.getBackPageFileSize() + this.dataPageFactory.getBackPageFileSize();
    }
}

