/*
 * Decompiled with CFR 0.152.
 */
package io.logz.logback-appender.sender.org.kairosdb.bigqueue.page;

import io.logz.logback-appender.sender.org.kairosdb.bigqueue.page.IMappedPage;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedPageImpl
implements IMappedPage,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(MappedPageImpl.class);
    private ThreadLocalByteBuffer threadLocalBuffer;
    private volatile boolean dirty = false;
    private volatile boolean closed = false;
    private String pageFile;
    private long index;
    private boolean isNew = false;

    public MappedPageImpl(MappedByteBuffer mbb, String pageFile, long index) {
        this.threadLocalBuffer = new ThreadLocalByteBuffer(mbb);
        this.pageFile = pageFile;
        this.index = index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        MappedPageImpl mappedPageImpl = this;
        synchronized (mappedPageImpl) {
            if (this.closed) {
                return;
            }
            this.flush();
            MappedByteBuffer srcBuf = (MappedByteBuffer)this.threadLocalBuffer.getSourceBuffer();
            MappedPageImpl.unmap(srcBuf);
            this.threadLocalBuffer = null;
            this.closed = true;
            if (logger.isDebugEnabled()) {
                logger.debug("Mapped page for " + this.pageFile + " was just unmapped and closed.");
            }
        }
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.isNew = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        MappedPageImpl mappedPageImpl = this;
        synchronized (mappedPageImpl) {
            if (this.closed) {
                return;
            }
            if (this.dirty) {
                MappedByteBuffer srcBuf = (MappedByteBuffer)this.threadLocalBuffer.getSourceBuffer();
                srcBuf.force();
                this.dirty = false;
                if (logger.isDebugEnabled()) {
                    logger.debug("Mapped page for " + this.pageFile + " was just flushed.");
                }
            }
        }
    }

    @Override
    public byte[] getLocal(int position, int length) {
        ByteBuffer buf = this.getLocal(position);
        byte[] data = new byte[length];
        buf.get(data);
        return data;
    }

    @Override
    public ByteBuffer getLocal(int position) {
        ByteBuffer buf = (ByteBuffer)this.threadLocalBuffer.get();
        buf.position(position);
        return buf;
    }

    private static void unmap(MappedByteBuffer buffer) {
        Cleaner.clean(buffer);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public String toString() {
        return "Mapped page for " + this.pageFile + ", index = " + this.index + ".";
    }

    @Override
    public String getPageFile() {
        return this.pageFile;
    }

    @Override
    public long getPageIndex() {
        return this.index;
    }

    private static class ThreadLocalByteBuffer
    extends ThreadLocal<ByteBuffer> {
        private ByteBuffer _src;

        public ThreadLocalByteBuffer(ByteBuffer src) {
            this._src = src;
        }

        public ByteBuffer getSourceBuffer() {
            return this._src;
        }

        @Override
        protected synchronized ByteBuffer initialValue() {
            ByteBuffer dup = this._src.duplicate();
            return dup;
        }
    }

    private static class Cleaner {
        public static final boolean CLEAN_SUPPORTED;
        private static final Method directBufferCleaner;
        private static final Method directBufferCleanerClean;

        private Cleaner() {
        }

        public static void clean(ByteBuffer buffer) {
            if (buffer == null) {
                return;
            }
            if (CLEAN_SUPPORTED && buffer.isDirect()) {
                try {
                    Object cleaner = directBufferCleaner.invoke((Object)buffer, new Object[0]);
                    directBufferCleanerClean.invoke(cleaner, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        static {
            boolean v;
            Method directBufferCleanerX = null;
            Method directBufferCleanerCleanX = null;
            try {
                directBufferCleanerX = Class.forName("java.nio.DirectByteBuffer").getMethod("cleaner", new Class[0]);
                directBufferCleanerX.setAccessible(true);
                directBufferCleanerCleanX = Class.forName("sun.misc.Cleaner").getMethod("clean", new Class[0]);
                directBufferCleanerCleanX.setAccessible(true);
                v = true;
            }
            catch (Exception e) {
                v = false;
            }
            CLEAN_SUPPORTED = v;
            directBufferCleaner = directBufferCleanerX;
            directBufferCleanerClean = directBufferCleanerCleanX;
        }
    }
}

