/*
 * Decompiled with CFR 0.152.
 */
package io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal;

import io.logz.logback-appender.sender.org.kairosdb.metrics4j.configuration.ConfigurationException;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.shaded.config.Config;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.shaded.config.ConfigValue;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanInjector {
    public static final Logger logger = LoggerFactory.getLogger(BeanInjector.class);
    private final String m_objName;
    private final Class<?> m_class;
    private Map<String, PropertyDescriptor> m_propMap = new HashMap<String, PropertyDescriptor>();

    public BeanInjector(String objName, Class<?> objClass) throws IntrospectionException {
        PropertyDescriptor[] propertyDescriptors;
        this.m_objName = objName;
        this.m_class = objClass;
        BeanInfo beanInfo = Introspector.getBeanInfo(objClass);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
            this.m_propMap.put(this.getDashPropertyName(propertyDescriptor.getName()), propertyDescriptor);
        }
    }

    private String getDashPropertyName(String camelCaseName) {
        StringBuilder sb = new StringBuilder();
        for (char c : camelCaseName.toCharArray()) {
            if (Character.isUpperCase(c)) {
                sb.append('-').append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public Object createInstance(Config config) {
        Object instance;
        try {
            instance = this.m_class.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            String msg = "Failed to instantiate instance of '" + this.m_class.getName() + "' for object '" + this.m_objName + "'.  Error: " + e.getMessage();
            throw new ConfigurationException(msg);
        }
        Set<Map.Entry<String, ConfigValue>> props = config.entrySet();
        for (Map.Entry<String, ConfigValue> prop : props) {
            String property = prop.getKey();
            if (property.equals("_class") || property.equals("_folder")) continue;
            PropertyDescriptor pd = this.m_propMap.get(property);
            if (pd == null || pd.getWriteMethod() == null) {
                String msg = "Property '" + property + "' was specified for object '" + this.m_objName + "' but no matching setter was found on '" + this.m_class.getName() + "'";
                throw new ConfigurationException(msg);
            }
            Method method = pd.getWriteMethod();
            Type propClass = method.getGenericParameterTypes()[0];
            Object propValue = BeanInjector.getValue(propClass, config, property);
            if (propValue == null) {
                String msg = "Object type for '" + method.getName() + "' on '" + this.m_class + "' is of un unsupported type.  Supported types are (int, long, double, boolean, String, Duration and Enum)";
                throw new ConfigurationException(msg);
            }
            try {
                method.invoke(instance, propValue);
            }
            catch (Exception e) {
                logger.error("Invocation error: ", (Throwable)e);
                String msg = "Call to " + this.m_class.getName() + ":" + method.getName() + " failed with message: " + e.getMessage();
                throw new ConfigurationException(msg);
            }
        }
        return instance;
    }

    private static Object getValue(Type parameterType, Config config, String configPropName) {
        try {
            Type compareType = parameterType;
            if (parameterType instanceof ParameterizedType) {
                compareType = ((ParameterizedType)parameterType).getRawType();
            }
            if (compareType == Boolean.class || compareType == Boolean.TYPE) {
                return config.getBoolean(configPropName);
            }
            if (compareType == Integer.class || compareType == Integer.TYPE) {
                return config.getInt(configPropName);
            }
            if (compareType == Double.class || compareType == Double.TYPE) {
                return config.getDouble(configPropName);
            }
            if (compareType == Long.class || compareType == Long.TYPE) {
                return config.getLong(configPropName);
            }
            if (compareType == String.class) {
                return config.getString(configPropName);
            }
            if (compareType == Duration.class) {
                return config.getDuration(configPropName);
            }
            if (compareType.equals(List.class)) {
                return BeanInjector.getListValue(parameterType, config, configPropName);
            }
            if (compareType == Set.class) {
                return BeanInjector.getSetValue(parameterType, config, configPropName);
            }
            if (Enum.class.isAssignableFrom((Class)compareType)) {
                return Enum.valueOf((Class)parameterType, config.getString(configPropName));
            }
            return null;
        }
        catch (Exception e) {
            logger.error("Failed to get value for property " + configPropName, (Throwable)e);
            return null;
        }
    }

    private static Object getSetValue(Type parameterType, Config config, String configPropName) {
        return new HashSet((List)BeanInjector.getListValue(parameterType, config, configPropName));
    }

    private static Object getListValue(Type parameterType, Config config, String configPropName) {
        Type elementType = ((ParameterizedType)parameterType).getActualTypeArguments()[0];
        if (elementType == Boolean.class) {
            return config.getBooleanList(configPropName);
        }
        if (elementType == Integer.class) {
            return config.getIntList(configPropName);
        }
        if (elementType == Double.class) {
            return config.getDoubleList(configPropName);
        }
        if (elementType == Long.class) {
            return config.getLongList(configPropName);
        }
        if (elementType == String.class) {
            return config.getStringList(configPropName);
        }
        if (elementType == Duration.class) {
            return config.getDurationList(configPropName);
        }
        if (((Class)elementType).isEnum()) {
            List enumValues = config.getEnumList((Class)elementType, configPropName);
            return enumValues;
        }
        return null;
    }
}

