/*
 * Decompiled with CFR 0.152.
 */
package io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal;

import io.logz.logback-appender.sender.org.kairosdb.metrics4j.formatters.Formatter;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.ArgKey;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.CollectorCollection;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.FormattedMetric;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.SinkQueue;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.reporting.ReportedMetric;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CollectorContainer {
    private final CollectorCollection m_collector;
    private final ArgKey m_argKey;
    private Map<String, Formatter> m_formatters;
    private List<SinkQueue> m_sinkQueueList;
    private Map<String, String> m_tags;
    private Map<String, String> m_props;
    private String m_metricName;
    private String m_help = "";

    public CollectorContainer(CollectorCollection collector, ArgKey argKey) {
        this.m_collector = Objects.requireNonNull(collector);
        this.m_argKey = argKey;
        this.m_sinkQueueList = new ArrayList<SinkQueue>();
    }

    public CollectorContainer setFormatters(Map<String, Formatter> formatters) {
        this.m_formatters = formatters;
        return this;
    }

    public CollectorContainer addSinkQueue(List<SinkQueue> queue) {
        this.m_sinkQueueList.addAll(queue);
        return this;
    }

    public List<SinkQueue> getSinkQueueList() {
        return this.m_sinkQueueList;
    }

    private void formatAndSink(ReportedMetric metric) {
        for (SinkQueue sinkQueue : this.m_sinkQueueList) {
            Formatter formatter = this.m_formatters.computeIfAbsent(sinkQueue.getSinkName(), sq -> sinkQueue.getSink().getDefaultFormatter());
            FormattedMetric formattedMetric = new FormattedMetric(metric, this.m_props, this.m_tags, this.m_help);
            for (ReportedMetric.Sample sample : metric.getSamples()) {
                String metricName = formatter.formatReportedMetric(metric, sample, this.m_metricName);
                formattedMetric.addSample(sample, metricName);
            }
            sinkQueue.addMetric(formattedMetric);
        }
    }

    public void reportMetrics(Instant now) {
        Iterable<ReportedMetric> reportedMetrics = this.m_collector.gatherMetrics(now);
        for (ReportedMetric metric : reportedMetrics) {
            this.formatAndSink(metric);
        }
    }

    public void setTags(Map<String, String> tags) {
        this.m_tags = tags;
    }

    public void setMetricName(String metricName) {
        this.m_metricName = metricName;
    }

    public void setProps(Map<String, String> props) {
        this.m_props = props;
    }

    public String getHelp() {
        return this.m_help;
    }

    public void setHelp(String help) {
        this.m_help = help;
    }
}

