/*
 * Decompiled with CFR 0.152.
 */
package io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal;

import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.MapCombiner;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.reporting.MetricValue;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.reporting.ReportedMetric;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FormattedMetric {
    private final ReportedMetric m_metric;
    private final List<Sample> m_samples;
    private final Map<String, String> m_props;
    private final Map<String, String> m_combinedTags;
    private final String m_help;

    public FormattedMetric(ReportedMetric metric, Map<String, String> props, Map<String, String> staticTags, String help) {
        this.m_metric = metric;
        this.m_samples = new ArrayList<Sample>();
        this.m_props = props;
        this.m_combinedTags = new MapCombiner<String, String>(staticTags, this.m_metric.getTags());
        this.m_help = help;
    }

    public void addSample(ReportedMetric.Sample sample, String formattedName) {
        this.m_samples.add(new Sample(sample, formattedName));
    }

    public String getClassName() {
        return this.m_metric.getClassName();
    }

    public String getMethodName() {
        return this.m_metric.getMethodName();
    }

    public Map<String, String> getTags() {
        return this.m_combinedTags;
    }

    public List<Sample> getSamples() {
        return this.m_samples;
    }

    public Map<String, String> getProps() {
        return this.m_props;
    }

    public String getHelp() {
        return this.m_help;
    }

    public String toString() {
        return "FormattedMetric(m_metric=" + this.m_metric + ", m_samples=" + this.m_samples + ", m_props=" + this.m_props + ", m_combinedTags=" + this.m_combinedTags + ", m_help=" + this.m_help + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FormattedMetric)) {
            return false;
        }
        FormattedMetric other = (FormattedMetric)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ReportedMetric this$m_metric = this.m_metric;
        ReportedMetric other$m_metric = other.m_metric;
        if (this$m_metric == null ? other$m_metric != null : !this$m_metric.equals(other$m_metric)) {
            return false;
        }
        List<Sample> this$m_samples = this.m_samples;
        List<Sample> other$m_samples = other.m_samples;
        if (this$m_samples == null ? other$m_samples != null : !((Object)this$m_samples).equals(other$m_samples)) {
            return false;
        }
        Map<String, String> this$m_props = this.m_props;
        Map<String, String> other$m_props = other.m_props;
        if (this$m_props == null ? other$m_props != null : !((Object)this$m_props).equals(other$m_props)) {
            return false;
        }
        Map<String, String> this$m_combinedTags = this.m_combinedTags;
        Map<String, String> other$m_combinedTags = other.m_combinedTags;
        if (this$m_combinedTags == null ? other$m_combinedTags != null : !((Object)this$m_combinedTags).equals(other$m_combinedTags)) {
            return false;
        }
        String this$m_help = this.m_help;
        String other$m_help = other.m_help;
        return !(this$m_help == null ? other$m_help != null : !this$m_help.equals(other$m_help));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FormattedMetric;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ReportedMetric $m_metric = this.m_metric;
        result = result * 59 + ($m_metric == null ? 43 : $m_metric.hashCode());
        List<Sample> $m_samples = this.m_samples;
        result = result * 59 + ($m_samples == null ? 43 : ((Object)$m_samples).hashCode());
        Map<String, String> $m_props = this.m_props;
        result = result * 59 + ($m_props == null ? 43 : ((Object)$m_props).hashCode());
        Map<String, String> $m_combinedTags = this.m_combinedTags;
        result = result * 59 + ($m_combinedTags == null ? 43 : ((Object)$m_combinedTags).hashCode());
        String $m_help = this.m_help;
        result = result * 59 + ($m_help == null ? 43 : $m_help.hashCode());
        return result;
    }

    public static class Sample {
        private final ReportedMetric.Sample m_sample;
        private final String m_metricName;

        private Sample(ReportedMetric.Sample sample, String metricName) {
            this.m_sample = sample;
            this.m_metricName = metricName;
        }

        public String getFieldName() {
            return this.m_sample.getFieldName();
        }

        public MetricValue getValue() {
            return this.m_sample.getValue();
        }

        public Instant getTime() {
            return this.m_sample.getTime();
        }

        public String getMetricName() {
            return this.m_metricName;
        }

        public String toString() {
            return "FormattedMetric.Sample(m_sample=" + this.m_sample + ", m_metricName=" + this.m_metricName + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sample)) {
                return false;
            }
            Sample other = (Sample)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ReportedMetric.Sample this$m_sample = this.m_sample;
            ReportedMetric.Sample other$m_sample = other.m_sample;
            if (this$m_sample == null ? other$m_sample != null : !this$m_sample.equals(other$m_sample)) {
                return false;
            }
            String this$m_metricName = this.m_metricName;
            String other$m_metricName = other.m_metricName;
            return !(this$m_metricName == null ? other$m_metricName != null : !this$m_metricName.equals(other$m_metricName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Sample;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ReportedMetric.Sample $m_sample = this.m_sample;
            result = result * 59 + ($m_sample == null ? 43 : $m_sample.hashCode());
            String $m_metricName = this.m_metricName;
            result = result * 59 + ($m_metricName == null ? 43 : $m_metricName.hashCode());
            return result;
        }
    }
}

