/*
 * Decompiled with CFR 0.152.
 */
package io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal;

import io.logz.logback-appender.sender.org.kairosdb.metrics4j.collectors.MetricCollector;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.ArgKey;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.CollectorCollection;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.ReportedMetricImpl;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal.TagKey;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.reporting.MetricReporter;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.reporting.MetricValue;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.reporting.ReportedMetric;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Map;

public abstract class MetricsGatherer
implements CollectorCollection {
    protected abstract ArgKey getArgKey();

    protected abstract Map<TagKey, MetricCollector> getCollectors();

    @Override
    public Iterable<ReportedMetric> gatherMetrics(Instant now) {
        ArgKey argKey = this.getArgKey();
        Map<TagKey, MetricCollector> collectors = this.getCollectors();
        ArrayList<ReportedMetric> ret = new ArrayList<ReportedMetric>();
        for (Map.Entry<TagKey, MetricCollector> entry : collectors.entrySet()) {
            final ReportedMetricImpl reportedMetric = new ReportedMetricImpl();
            reportedMetric.setTime(now).setClassName(argKey.getClassName()).setMethodName(argKey.getMethodName()).setTags(entry.getKey().getTags());
            entry.getValue().reportMetric(new MetricReporter(){

                @Override
                public void put(String field, MetricValue value) {
                    reportedMetric.addSample(field, value);
                }

                @Override
                public void put(String field, MetricValue value, Instant time) {
                    reportedMetric.addSample(field, value, time);
                }
            });
            ret.add(reportedMetric);
        }
        return ret;
    }
}

