/*
 * Decompiled with CFR 0.152.
 */
package io.logz.logback-appender.sender.org.kairosdb.metrics4j.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TagKey {
    private final Map<String, String> m_tags;
    private final String m_key;

    private TagKey(Map<String, String> tags, String key) {
        this.m_tags = Collections.unmodifiableMap(tags);
        this.m_key = key;
    }

    public Map<String, String> getTags() {
        return this.m_tags;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagKey tagKey = (TagKey)o;
        return this.m_key.equals(tagKey.m_key);
    }

    public int hashCode() {
        return Objects.hash(this.m_key);
    }

    public String toString() {
        return "TagKey{m_key='" + this.m_key + '\'' + '}';
    }

    public static class Builder {
        private final Map<String, String> m_tags = new HashMap<String, String>();
        private final StringBuilder m_keyBuilder = new StringBuilder();

        private Builder() {
        }

        public void addTag(String key, String value) {
            this.m_tags.put(key, value);
            this.m_keyBuilder.append(key).append(value);
        }

        public TagKey build() {
            return new TagKey(this.m_tags, this.m_keyBuilder.toString());
        }
    }
}

