/*
 * Decompiled with CFR 0.152.
 */
package io.logz.logback-appender.sender.org.kairosdb.metrics4j.shaded.config.impl;

import io.logz.logback-appender.sender.org.kairosdb.metrics4j.shaded.config.ConfigException;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.shaded.config.impl.AbstractConfigNodeValue;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.shaded.config.impl.AbstractConfigValue;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.shaded.config.impl.ConfigReference;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.shaded.config.impl.ConfigString;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.shaded.config.impl.Path;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.shaded.config.impl.PathParser;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.shaded.config.impl.SubstitutionExpression;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.shaded.config.impl.Token;
import io.logz.logback-appender.sender.org.kairosdb.metrics4j.shaded.config.impl.Tokens;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

final class ConfigNodeSimpleValue
extends AbstractConfigNodeValue {
    final Token token;

    ConfigNodeSimpleValue(Token value) {
        this.token = value;
    }

    @Override
    protected Collection<Token> tokens() {
        return Collections.singletonList(this.token);
    }

    protected Token token() {
        return this.token;
    }

    protected AbstractConfigValue value() {
        if (Tokens.isValue(this.token)) {
            return Tokens.getValue(this.token);
        }
        if (Tokens.isUnquotedText(this.token)) {
            return new ConfigString.Unquoted(this.token.origin(), Tokens.getUnquotedText(this.token));
        }
        if (Tokens.isSubstitution(this.token)) {
            List<Token> expression = Tokens.getSubstitutionPathExpression(this.token);
            Path path = PathParser.parsePathExpression(expression.iterator(), this.token.origin());
            boolean optional = Tokens.getSubstitutionOptional(this.token);
            return new ConfigReference(this.token.origin(), new SubstitutionExpression(path, optional));
        }
        throw new ConfigException.BugOrBroken("ConfigNodeSimpleValue did not contain a valid value token");
    }
}

