/*
 * Decompiled with CFR 0.152.
 */
package io.logz.logback;

import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import io.logz.com.bluejeans.common.bigqueue.BigQueue;
import io.logz.com.google.common.base.Splitter;
import io.logz.com.google.gson.JsonObject;
import io.logz.logback.FormattedLogMessage;
import io.logz.logback.LogzioLogbackAppender;
import io.logz.logback.exceptions.LogzioServerErrorException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class LogzioSender {
    private final int MAX_SIZE_IN_BYTES = 0x300000;
    private final int INITIAL_WAIT_BEFORE_RETRY_MS = 2000;
    private final int MAX_RETRIES_ATTEMPTS = 3;
    private final BigQueue logsBuffer;
    private final File queueDirectory;
    private final URL logzioListenerUrl;
    private HttpURLConnection conn;
    private boolean dontCheckEnoughDiskSpace = false;
    private final String logzioToken;
    private final String logzioType;
    private final int drainTimeout;
    private final int fsPercentThreshold;
    private final String logzioUrl;
    private final int socketTimeout;
    private final int connectTimeout;
    private final boolean debug;
    private final LogzioLogbackAppender.StatusReporter reporter;
    private final ScheduledExecutorService tasksExecutor;
    private final Map<String, String> additionalFieldsMap;
    private final List<String> throwableProxyConversionOptions = Arrays.asList("full");
    private final ThrowableProxyConverter throwableProxyConverter;

    public LogzioSender(String logzioToken, String logzioType, int drainTimeout, int fsPercentThreshold, String bufferDir, String logzioUrl, int socketTimeout, int connectTimeout, boolean debug, LogzioLogbackAppender.StatusReporter reporter, ScheduledExecutorService tasksExecutor, boolean addHostname, String additionalFields) throws IllegalArgumentException {
        this.logzioToken = logzioToken;
        this.logzioType = logzioType;
        this.drainTimeout = drainTimeout;
        this.fsPercentThreshold = fsPercentThreshold;
        this.logzioUrl = logzioUrl;
        this.socketTimeout = socketTimeout;
        this.connectTimeout = connectTimeout;
        this.debug = debug;
        this.reporter = reporter;
        this.additionalFieldsMap = new HashMap<String, String>();
        if (this.fsPercentThreshold == -1) {
            this.dontCheckEnoughDiskSpace = true;
        }
        this.logsBuffer = new BigQueue(bufferDir, "logzio-logback-appender");
        this.queueDirectory = new File(bufferDir);
        if (additionalFields != null) {
            JsonObject reservedFieldsTestLogMessage = this.formatMessageAsJson(new Date().getTime(), "Level", "Message", "Logger", "Thread", Optional.empty(), Optional.empty());
            Splitter.on(';').omitEmptyStrings().withKeyValueSeparator('=').split(additionalFields).forEach((k, v) -> {
                if (reservedFieldsTestLogMessage.get((String)k) != null) {
                    reporter.warning("The field name '" + k + "' defined in additionalFields configuration can't be used since it's a reserved field name. This field will not be added to the outgoing log messages");
                } else if (v.startsWith("$")) {
                    String environmentValue = System.getenv(v.replace("$", ""));
                    if (environmentValue != null) {
                        this.additionalFieldsMap.put((String)k, environmentValue);
                    }
                } else {
                    this.additionalFieldsMap.put((String)k, (String)v);
                }
            });
            reporter.info("The additional fields that would be added: " + this.additionalFieldsMap.toString());
        }
        try {
            if (addHostname) {
                String hostname = InetAddress.getLocalHost().getHostName();
                this.additionalFieldsMap.put("hostname", hostname);
            }
        }
        catch (UnknownHostException e) {
            reporter.warning("The configuration addHostName was specified but the host could not be resolved, thus the field 'hostname' will not be added", e);
        }
        try {
            this.logzioListenerUrl = new URL(this.logzioUrl + "/?token=" + this.logzioToken + "&type=" + this.logzioType);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("For some reason could not initialize URL. Cant recover..");
        }
        this.tasksExecutor = tasksExecutor;
        this.throwableProxyConverter = new ThrowableProxyConverter();
        this.throwableProxyConverter.setOptionList(this.throwableProxyConversionOptions);
        this.throwableProxyConverter.start();
        this.debug("Created new LogzioSender class");
    }

    public void start() {
        this.tasksExecutor.scheduleWithFixedDelay(this::drainQueueAndSend, 0L, this.drainTimeout, TimeUnit.SECONDS);
        this.tasksExecutor.scheduleWithFixedDelay(this::gcBigQueue, 0L, 30L, TimeUnit.SECONDS);
    }

    public void stop() {
        try {
            this.debug("Got stop request, stopping new executions");
            this.tasksExecutor.shutdown();
            this.debug("Waiting up to 20 seconds for tasks to finish");
            this.tasksExecutor.awaitTermination(20L, TimeUnit.SECONDS);
            this.debug("Shutting all tasks forcefully");
            this.tasksExecutor.shutdownNow();
            this.drainQueue();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void gcBigQueue() {
        try {
            this.logsBuffer.gc();
        }
        catch (Exception e) {
            this.reporter.error("Uncaught error from BigQueue.gc()", e);
        }
    }

    public void drainQueueAndSend() {
        try {
            this.drainQueue();
        }
        catch (Exception e) {
            this.reporter.error("Uncaught error from Logz.io sender", e);
        }
    }

    public void send(ILoggingEvent message) {
        if (!message.getLoggerName().contains("io.logz.com.bluejeans.common.bigqueue")) {
            this.enqueue(this.formatMessage(message).getBytes());
        }
    }

    private void enqueue(byte[] message) {
        if (this.isEnoughDiskSpace()) {
            this.logsBuffer.enqueue(message);
        }
    }

    private boolean isEnoughDiskSpace() {
        if (this.dontCheckEnoughDiskSpace) {
            return true;
        }
        int actualFsPercent = (int)((double)this.queueDirectory.getUsableSpace() / (double)this.queueDirectory.getTotalSpace() * 100.0);
        if (actualFsPercent >= this.fsPercentThreshold) {
            this.reporter.warning(String.format("Logz.io: Dropping logs, as FS free usable space on %s is %d percent, and the drop threshold is %d percent", this.queueDirectory.getAbsolutePath(), actualFsPercent, this.fsPercentThreshold));
            return false;
        }
        return true;
    }

    private List dequeueUpToMaxBatchSize() {
        ArrayList<FormattedLogMessage> logsList = new ArrayList<FormattedLogMessage>();
        while (!this.logsBuffer.isEmpty()) {
            logsList.add(new FormattedLogMessage(this.logsBuffer.dequeue()));
            if (this.sizeInBytes(logsList) < 0x300000) continue;
            break;
        }
        return logsList;
    }

    private void drainQueue() {
        this.debug("Attempting to drain queue");
        if (!this.logsBuffer.isEmpty()) {
            while (!this.logsBuffer.isEmpty()) {
                List logsList = this.dequeueUpToMaxBatchSize();
                try {
                    this.sendToLogzio(logsList);
                }
                catch (LogzioServerErrorException e) {
                    this.debug("Could not send log to logz.io: ", e);
                    this.debug("Will retry in the next interval");
                    logsList.forEach(logMessage -> this.enqueue(logMessage.getMessage()));
                    break;
                }
            }
        }
    }

    private int sizeInBytes(List<FormattedLogMessage> logMessages) {
        int totalSize = 0;
        for (FormattedLogMessage currLog : logMessages) {
            totalSize += currLog.getSize();
        }
        return totalSize;
    }

    private byte[] toNewLineSeparatedByteArray(List<FormattedLogMessage> messages) {
        try {
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream(this.sizeInBytes(messages));
            for (FormattedLogMessage currMessage : messages) {
                byteOutputStream.write(currMessage.getMessage());
            }
            return byteOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean shouldRetry(int statusCode) {
        boolean shouldRetry = true;
        switch (statusCode) {
            case 200: 
            case 400: 
            case 401: {
                shouldRetry = false;
            }
        }
        return shouldRetry;
    }

    private void sendToLogzio(List<FormattedLogMessage> messages) throws LogzioServerErrorException {
        try {
            byte[] payload = this.toNewLineSeparatedByteArray(messages);
            int currentRetrySleep = 2000;
            for (int currTry = 1; currTry <= 3; ++currTry) {
                boolean shouldRetry = true;
                int responseCode = 0;
                String responseMessage = "";
                IOException savedException = null;
                try {
                    this.conn = (HttpURLConnection)this.logzioListenerUrl.openConnection();
                    this.conn.setRequestMethod("POST");
                    this.conn.setRequestProperty("Content-length", String.valueOf(payload.length));
                    this.conn.setRequestProperty("Content-Type", "text/plain");
                    this.conn.setReadTimeout(this.socketTimeout);
                    this.conn.setConnectTimeout(this.connectTimeout);
                    this.conn.setDoOutput(true);
                    this.conn.setDoInput(true);
                    this.conn.getOutputStream().write(payload);
                    responseCode = this.conn.getResponseCode();
                    responseMessage = this.conn.getResponseMessage();
                    if (responseCode == 400) {
                        this.reporter.warning("Got 400 from logzio, here is the output: \n " + responseMessage);
                    }
                    if (responseCode == 401) {
                        this.reporter.error("Logz.io: Got forbidden! Your token is not right. Unfortunately, dropping logs. Message: " + responseMessage);
                    }
                    shouldRetry = this.shouldRetry(responseCode);
                }
                catch (IOException e) {
                    savedException = e;
                    this.debug("Got IO exception - " + e.getMessage());
                }
                if (!shouldRetry) {
                    this.debug("Successfully sent bulk to logz.io, size: " + payload.length);
                    break;
                }
                if (currTry == 3) {
                    if (savedException != null) {
                        this.reporter.error("Got IO exception on the last bulk try to logz.io", savedException);
                    }
                    throw new LogzioServerErrorException("Got HTTP " + responseCode + " code from logz.io, with message: " + responseMessage);
                }
                this.debug("Could not send log to logz.io, retry (" + currTry + "/" + 3 + ")");
                this.debug("Sleeping for " + currentRetrySleep + " ms and will try again.");
                Thread.sleep(currentRetrySleep);
                currentRetrySleep *= 2;
            }
        }
        catch (InterruptedException e) {
            this.debug("Got interrupted exception");
            Thread.currentThread().interrupt();
        }
    }

    private void debug(String message) {
        if (this.debug) {
            this.reporter.info("DEBUG: " + message);
        }
    }

    private void debug(String message, Throwable e) {
        if (this.debug) {
            this.reporter.info("DEBUG: " + message, e);
        }
    }

    private String formatMessage(ILoggingEvent loggingEvent) {
        JsonObject logMessage = this.formatMessageAsJson(loggingEvent.getTimeStamp(), loggingEvent.getLevel().levelStr, loggingEvent.getFormattedMessage(), loggingEvent.getLoggerName(), loggingEvent.getThreadName(), Optional.ofNullable(loggingEvent.getMDCPropertyMap()), Optional.ofNullable(loggingEvent));
        return logMessage.toString() + "\n";
    }

    private JsonObject formatMessageAsJson(long timestamp, String logLevelName, String message, String loggerName, String threadName, Optional<Map<String, String>> mdcPropertyMap, Optional<ILoggingEvent> loggingEvent) {
        JsonObject logMessage = new JsonObject();
        if (mdcPropertyMap.isPresent()) {
            mdcPropertyMap.get().forEach(logMessage::addProperty);
        }
        logMessage.addProperty("@timestamp", new Date(timestamp).toInstant().toString());
        logMessage.addProperty("loglevel", logLevelName);
        logMessage.addProperty("message", message);
        logMessage.addProperty("logger", loggerName);
        logMessage.addProperty("thread", threadName);
        if (loggingEvent.isPresent() && loggingEvent.get().getThrowableProxy() != null) {
            logMessage.addProperty("exception", this.throwableProxyConverter.convert(loggingEvent.get()));
        }
        if (this.additionalFieldsMap != null) {
            this.additionalFieldsMap.forEach(logMessage::addProperty);
        }
        return logMessage;
    }
}

