/*
 * Decompiled with CFR 0.152.
 */
package io.logz.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import io.logz.logback.LogzioSender;
import java.io.File;

public class LogzioLogbackAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private LogzioSender logzioSender;
    private String logzioToken;
    private String logzioType = "java";
    private int drainTimeoutSec = 5;
    private int fileSystemFullPercentThreshold = 98;
    private String bufferDir;
    private String logzioUrl = "https://listener.logz.io:8071";
    private int connectTimeout = 10000;
    private int socketTimeout = 10000;
    private boolean debug = false;
    private boolean addHostname = false;
    private String additionalFields;
    private int gcPersistedQueueFilesIntervalSeconds = 30;

    public void setToken(String logzioToken) {
        this.logzioToken = logzioToken;
    }

    public String getToken() {
        return this.logzioToken;
    }

    public void setLogzioType(String logzioType) {
        this.logzioType = logzioType;
    }

    public String getLogzioType() {
        return this.logzioType;
    }

    public void setDrainTimeoutSec(int drainTimeoutSec) {
        if (drainTimeoutSec < 1) {
            this.drainTimeoutSec = 1;
            this.addInfo("Got unsupported drain timeout " + drainTimeoutSec + ". The timeout must be number greater then 1. I have set to 1 as fallback.");
        } else {
            this.drainTimeoutSec = drainTimeoutSec;
        }
    }

    public int getDrainTimeoutSec() {
        return this.drainTimeoutSec;
    }

    public void setFileSystemFullPercentThreshold(int fileSystemFullPercentThreshold) {
        this.fileSystemFullPercentThreshold = fileSystemFullPercentThreshold;
    }

    public int getFileSystemFullPercentThreshold() {
        return this.fileSystemFullPercentThreshold;
    }

    public void setBufferDir(String bufferDir) {
        this.bufferDir = bufferDir;
    }

    public String getBufferDir() {
        return this.bufferDir;
    }

    public void setLogzioUrl(String logzioUrl) {
        this.logzioUrl = logzioUrl;
    }

    public String getLogzioUrl() {
        return this.logzioUrl;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getAdditionalFields() {
        return this.additionalFields;
    }

    public void setAdditionalFields(String additionalFields) {
        this.additionalFields = additionalFields;
    }

    public boolean isAddHostname() {
        return this.addHostname;
    }

    public void setAddHostname(boolean addHostname) {
        this.addHostname = addHostname;
    }

    public void setGcPersistedQueueFilesIntervalSeconds(int gcPersistedQueueFilesIntervalSeconds) {
        this.gcPersistedQueueFilesIntervalSeconds = gcPersistedQueueFilesIntervalSeconds;
    }

    public int getGcPersistedQueueFilesIntervalSeconds() {
        return this.gcPersistedQueueFilesIntervalSeconds;
    }

    public void start() {
        if (this.logzioToken == null) {
            this.addError("Logz.io Token is missing! Bailing out..");
            return;
        }
        if ((this.fileSystemFullPercentThreshold < 1 || this.fileSystemFullPercentThreshold > 100) && this.fileSystemFullPercentThreshold != -1) {
            this.addError("fileSystemFullPercentThreshold should be a number between 1 and 100, or -1");
            return;
        }
        if (this.bufferDir != null) {
            File bufferFile = new File(this.bufferDir);
            if (bufferFile.exists()) {
                if (!bufferFile.canWrite()) {
                    this.addError("We cant write to your bufferDir location: " + bufferFile.getAbsolutePath());
                    return;
                }
            } else if (!bufferFile.mkdirs()) {
                this.addError("We cant create your bufferDir location: " + bufferFile.getAbsolutePath());
                return;
            }
        } else {
            this.bufferDir = System.getProperty("java.io.tmpdir") + "/logzio-logback-buffer";
        }
        try {
            StatusReporter reporter = new StatusReporter();
            this.logzioSender = new LogzioSender(this.logzioToken, this.logzioType, this.drainTimeoutSec, this.fileSystemFullPercentThreshold, this.bufferDir, this.logzioUrl, this.socketTimeout, this.connectTimeout, this.debug, reporter, this.context.getScheduledExecutorService(), this.addHostname, this.additionalFields, this.gcPersistedQueueFilesIntervalSeconds);
            this.logzioSender.start();
        }
        catch (IllegalArgumentException e) {
            this.addError("Something unexpected happened while generating connection to logz.io");
            this.addError("Exception: " + e.getMessage(), e);
            return;
        }
        super.start();
    }

    public void stop() {
        if (this.logzioSender != null) {
            this.logzioSender.stop();
        }
        super.stop();
    }

    protected void append(ILoggingEvent loggingEvent) {
        this.logzioSender.send(loggingEvent);
    }

    public class StatusReporter {
        public void error(String msg) {
            LogzioLogbackAppender.this.addError(msg);
        }

        public void error(String msg, Throwable e) {
            LogzioLogbackAppender.this.addError(msg, e);
        }

        public void warning(String msg) {
            LogzioLogbackAppender.this.addWarn(msg);
        }

        public void warning(String msg, Throwable e) {
            LogzioLogbackAppender.this.addWarn(msg, e);
        }

        public void info(String msg) {
            LogzioLogbackAppender.this.addInfo(msg);
        }

        public void info(String msg, Throwable e) {
            LogzioLogbackAppender.this.addInfo(msg, e);
        }
    }
}

