/*
 * Decompiled with CFR 0.152.
 */
package io.logz.logback-appender.sender.com.bluejeans.common.bigqueue;

import io.logz.logback-appender.sender.com.bluejeans.common.bigqueue.BigArray;
import io.logz.logback-appender.sender.com.bluejeans.common.bigqueue.ItemIterator;
import io.logz.logback-appender.sender.com.bluejeans.common.bigqueue.MappedPage;
import io.logz.logback-appender.sender.com.bluejeans.common.bigqueue.MappedPageFactory;
import io.logz.logback-appender.sender.com.google.common.util.concurrent.ListenableFuture;
import io.logz.logback-appender.sender.com.google.common.util.concurrent.SettableFuture;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class BigQueue
implements Closeable {
    final BigArray innerArray;
    static final int QUEUE_FRONT_INDEX_ITEM_LENGTH_BITS = 3;
    static final int QUEUE_FRONT_INDEX_PAGE_SIZE = 8;
    static final long QUEUE_FRONT_PAGE_INDEX = 0L;
    static final String QUEUE_FRONT_INDEX_PAGE_FOLDER = "front_index";
    final AtomicLong queueFrontIndex = new AtomicLong();
    MappedPageFactory queueFrontIndexPageFactory;
    final Lock queueFrontWriteLock = new ReentrantLock();
    private final Object futureLock = new Object();
    private SettableFuture<byte[]> dequeueFuture;
    private SettableFuture<byte[]> peekFuture;

    public BigQueue(String queueDir, String queueName) {
        this(queueDir, queueName, 0x8000000);
    }

    public BigQueue(String queueDir, String queueName, int pageSize) {
        this.innerArray = new BigArray(queueDir, queueName, pageSize);
        this.queueFrontIndexPageFactory = new MappedPageFactory(8, this.innerArray.getArrayDirectory() + QUEUE_FRONT_INDEX_PAGE_FOLDER, 10000L);
        MappedPage queueFrontIndexPage = this.queueFrontIndexPageFactory.acquirePage(0L);
        ByteBuffer queueFrontIndexBuffer = queueFrontIndexPage.getLocal(0);
        long front = queueFrontIndexBuffer.getLong();
        this.queueFrontIndex.set(front);
    }

    public boolean isEmpty() {
        return this.queueFrontIndex.get() == this.innerArray.getHeadIndex();
    }

    public void enqueue(byte[] data) {
        this.innerArray.append(data);
        this.completeFutures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] dequeue() {
        long queueFrontIndex = -1L;
        try {
            this.queueFrontWriteLock.lock();
            if (this.isEmpty()) {
                byte[] byArray = null;
                return byArray;
            }
            queueFrontIndex = this.queueFrontIndex.get();
            byte[] data = this.innerArray.get(queueFrontIndex);
            long nextQueueFrontIndex = queueFrontIndex;
            nextQueueFrontIndex = nextQueueFrontIndex == Long.MAX_VALUE ? 0L : ++nextQueueFrontIndex;
            this.queueFrontIndex.set(nextQueueFrontIndex);
            MappedPage queueFrontIndexPage = this.queueFrontIndexPageFactory.acquirePage(0L);
            ByteBuffer queueFrontIndexBuffer = queueFrontIndexPage.getLocal(0);
            queueFrontIndexBuffer.putLong(nextQueueFrontIndex);
            queueFrontIndexPage.setDirty(true);
            byte[] byArray = data;
            return byArray;
        }
        finally {
            this.queueFrontWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> dequeueMulti(int max) {
        long queueFrontIndex = -1L;
        ArrayList<byte[]> dataList = new ArrayList<byte[]>();
        try {
            this.queueFrontWriteLock.lock();
            long size = this.size();
            for (int i = 0; i < max && (long)i < size; ++i) {
                if (this.isEmpty()) continue;
                queueFrontIndex = this.queueFrontIndex.get();
                byte[] data = this.innerArray.get(queueFrontIndex);
                dataList.add(data);
                long nextQueueFrontIndex = queueFrontIndex;
                nextQueueFrontIndex = nextQueueFrontIndex == Long.MAX_VALUE ? 0L : ++nextQueueFrontIndex;
                this.queueFrontIndex.set(nextQueueFrontIndex);
                MappedPage queueFrontIndexPage = this.queueFrontIndexPageFactory.acquirePage(0L);
                ByteBuffer queueFrontIndexBuffer = queueFrontIndexPage.getLocal(0);
                queueFrontIndexBuffer.putLong(nextQueueFrontIndex);
                queueFrontIndexPage.setDirty(true);
            }
            ArrayList<byte[]> arrayList = dataList;
            return arrayList;
        }
        finally {
            this.queueFrontWriteLock.unlock();
        }
    }

    public ListenableFuture<byte[]> dequeueAsync() {
        this.initializeDequeueFutureIfNecessary();
        return this.dequeueFuture;
    }

    public void removeAll() {
        try {
            this.queueFrontWriteLock.lock();
            this.innerArray.removeAll();
            this.queueFrontIndex.set(0L);
            MappedPage queueFrontIndexPage = this.queueFrontIndexPageFactory.acquirePage(0L);
            ByteBuffer queueFrontIndexBuffer = queueFrontIndexPage.getLocal(0);
            queueFrontIndexBuffer.putLong(0L);
            queueFrontIndexPage.setDirty(true);
        }
        finally {
            this.queueFrontWriteLock.unlock();
        }
    }

    public byte[] peek() {
        if (this.isEmpty()) {
            return null;
        }
        byte[] data = this.innerArray.get(this.queueFrontIndex.get());
        return data;
    }

    public List<byte[]> peekMulti(int max) {
        ArrayList<byte[]> dataList = new ArrayList<byte[]>();
        long size = this.size();
        long queueFront = this.queueFrontIndex.get();
        byte[] data = null;
        try {
            for (int i = 0; i < max && (long)i < size && (data = this.innerArray.get(queueFront - (long)i)) != null; ++i) {
                dataList.add(data);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return dataList;
    }

    public ListenableFuture<byte[]> peekAsync() {
        this.initializePeekFutureIfNecessary();
        return this.peekFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyForEach(ItemIterator iterator) {
        try {
            long index;
            this.queueFrontWriteLock.lock();
            if (this.isEmpty()) {
                return;
            }
            for (long i = index = this.queueFrontIndex.get(); i < this.innerArray.size(); ++i) {
                iterator.forEach(this.innerArray.get(i));
            }
        }
        finally {
            this.queueFrontWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.queueFrontIndexPageFactory != null) {
            this.queueFrontIndexPageFactory.releaseCachedPages();
        }
        Object object = this.futureLock;
        synchronized (object) {
            if (this.peekFuture != null) {
                this.peekFuture.cancel(false);
            }
            if (this.dequeueFuture != null) {
                this.dequeueFuture.cancel(false);
            }
        }
        this.innerArray.close();
    }

    public void gc() {
        long beforeIndex = this.queueFrontIndex.get();
        beforeIndex = beforeIndex == 0L ? Long.MAX_VALUE : --beforeIndex;
        try {
            this.innerArray.removeBeforeIndex(beforeIndex);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void flush() {
        try {
            this.queueFrontWriteLock.lock();
            this.queueFrontIndexPageFactory.flush();
            this.innerArray.flush();
        }
        finally {
            this.queueFrontWriteLock.unlock();
        }
    }

    public long size() {
        long qRear;
        long qFront = this.queueFrontIndex.get();
        if (qFront <= (qRear = this.innerArray.getHeadIndex())) {
            return qRear - qFront;
        }
        return Long.MAX_VALUE - qFront + 1L + qRear;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeFutures() {
        Object object = this.futureLock;
        synchronized (object) {
            if (this.peekFuture != null && !this.peekFuture.isDone()) {
                this.peekFuture.set(this.peek());
            }
            if (this.dequeueFuture != null && !this.dequeueFuture.isDone()) {
                this.dequeueFuture.set(this.dequeue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeDequeueFutureIfNecessary() {
        Object object = this.futureLock;
        synchronized (object) {
            if (this.dequeueFuture == null || this.dequeueFuture.isDone()) {
                this.dequeueFuture = SettableFuture.create();
            }
            if (!this.isEmpty()) {
                this.dequeueFuture.set(this.dequeue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePeekFutureIfNecessary() {
        Object object = this.futureLock;
        synchronized (object) {
            if (this.peekFuture == null || this.peekFuture.isDone()) {
                this.peekFuture = SettableFuture.create();
            }
            if (!this.isEmpty()) {
                this.peekFuture.set(this.peek());
            }
        }
    }
}

