/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender;

import io.logz.sender.exceptions.LogzioParameterErrorException;
import io.logz.sender.java.lang.Object;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.net.MalformedURLException;
import io.logz.sender.java.net.URL;

public class HttpsRequestConfiguration
extends Object {
    private final int initialWaitBeforeRetryMS;
    private final int maxRetriesAttempts;
    private final int socketTimeout;
    private final int connectTimeout;
    private final String requestMethod;
    private final String logzioToken;
    private final String logzioType;
    private final URL logzioListenerUrl;
    private final boolean compressRequests;

    public int getInitialWaitBeforeRetryMS() {
        return this.initialWaitBeforeRetryMS;
    }

    public int getMaxRetriesAttempts() {
        return this.maxRetriesAttempts;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public String getLogzioToken() {
        return this.logzioToken;
    }

    public String getLogzioType() {
        return this.logzioType;
    }

    public URL getLogzioListenerUrl() {
        return this.logzioListenerUrl;
    }

    public boolean isCompressRequests() {
        return this.compressRequests;
    }

    private HttpsRequestConfiguration(String logzioToken, int maxRetriesAttempts, int initialWaitBeforeRetryMS, int socketTimeout, int connectTimeout, String requestMethod, String logzioListenerUrl, boolean compressRequests, String logzioType) throws LogzioParameterErrorException {
        this.maxRetriesAttempts = maxRetriesAttempts;
        this.initialWaitBeforeRetryMS = initialWaitBeforeRetryMS;
        this.socketTimeout = socketTimeout;
        this.connectTimeout = connectTimeout;
        this.requestMethod = requestMethod;
        if (logzioToken == null || logzioToken.isEmpty()) {
            throw new LogzioParameterErrorException(new StringBuilder().append((String)"io.logz.sender.logzioToken = ").append(logzioToken).toString(), (String)"io.logz.sender.logzioToken can't be empty string or null ");
        }
        this.logzioToken = logzioToken;
        this.compressRequests = compressRequests;
        this.logzioType = logzioType;
        try {
            this.logzioListenerUrl = this.createURL(logzioListenerUrl);
        }
        catch (MalformedURLException e) {
            throw new LogzioParameterErrorException(new StringBuilder().append((String)"io.logz.sender.logzioUrl=").append(logzioListenerUrl).append((String)"io.logz.sender. token=").append(logzioToken).append((String)"io.logz.sender. type=").append(logzioType).toString(), new StringBuilder().append((String)"io.logz.sender.URL is malformed. Cant recover..").append((Object)e).toString());
        }
    }

    private URL createURL(String url) throws MalformedURLException {
        if (url == null || url.isEmpty()) {
            throw new MalformedURLException((String)"io.logz.sender.Empty or null URL");
        }
        return this.logzioType == null ? new URL(new StringBuilder().append(url).append((String)"io/logz/sender//?token=").append(this.logzioToken).toString()) : new URL(new StringBuilder().append(url).append((String)"io/logz/sender//?token=").append(this.logzioToken).append((String)"io.logz.sender.&type=").append(this.logzioType).toString());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Object {
        private int maxRetriesAttempts = 3;
        private int initialWaitBeforeRetryMS = 2000;
        private int socketTimeout = 10000;
        private int connectTimeout = 10000;
        private String requestMethod = "io.logz.sender.POST";
        private String logzioType;
        private String logzioListenerUrl = "io/logz/sender/https://listener.logz.io:8071";
        private String logzioToken;
        private boolean compressRequests = false;

        public Builder setLogzioToken(String logzioToken) {
            this.logzioToken = logzioToken;
            return this;
        }

        public Builder setInitialWaitBeforeRetryMS(int initialWaitBeforeRetryMS) {
            this.initialWaitBeforeRetryMS = initialWaitBeforeRetryMS;
            return this;
        }

        public Builder setSocketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder setMaxRetriesAttempts(int maxRetriesAttempts) {
            this.maxRetriesAttempts = maxRetriesAttempts;
            return this;
        }

        public Builder setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setRequestMethod(String requestMethod) {
            this.requestMethod = requestMethod;
            return this;
        }

        public Builder setLogzioType(String logzioType) {
            this.logzioType = logzioType;
            return this;
        }

        public Builder setLogzioListenerUrl(String logzioListenerUrl) {
            this.logzioListenerUrl = logzioListenerUrl;
            return this;
        }

        public Builder setCompressRequests(boolean compressRequests) {
            this.compressRequests = compressRequests;
            return this;
        }

        public HttpsRequestConfiguration build() throws LogzioParameterErrorException {
            return new HttpsRequestConfiguration(this.logzioToken, this.maxRetriesAttempts, this.initialWaitBeforeRetryMS, this.socketTimeout, this.connectTimeout, this.requestMethod, this.logzioListenerUrl, this.compressRequests, this.logzioType);
        }
    }
}

