/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.bluejeans.common.bigqueue;

import io.logz.sender.com.bluejeans.common.bigqueue.CloseCommand;
import io.logz.sender.java.io.Closeable;
import io.logz.sender.java.lang.Runnable;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.lang.System;
import io.logz.sender.java.util.ArrayList;
import io.logz.sender.java.util.Collection;
import io.logz.sender.java.util.HashMap;
import io.logz.sender.java.util.HashSet;
import io.logz.sender.java.util.Iterator;
import io.logz.sender.java.util.Map;
import io.logz.sender.java.util.Set;
import io.logz.sender.java.util.concurrent.ExecutorService;
import io.logz.sender.java.util.concurrent.Executors;
import io.logz.sender.java.util.concurrent.atomic.AtomicLong;
import io.logz.sender.java.util.concurrent.locks.Lock;
import io.logz.sender.java.util.concurrent.locks.ReadWriteLock;
import io.logz.sender.java.util.concurrent.locks.ReentrantReadWriteLock;
import io.logz.sender.org.slf4j.Logger;
import io.logz.sender.org.slf4j.LoggerFactory;

class LRUCache<K extends io.logz.sender.java.lang.Object, V extends Closeable>
extends io.logz.sender.java.lang.Object {
    private static final Logger logger = LoggerFactory.getLogger(LRUCache.class);
    public static final long DEFAULT_TTL = 10000L;
    private final Map<K, V> map;
    private final Map<K, TTLValue> ttlMap;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private static final ExecutorService executorService = Executors.newCachedThreadPool();
    private final Set<K> keysToRemove = new HashSet();

    public LRUCache() {
        this.map = new HashMap();
        this.ttlMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value, long ttlInMilliSeconds) {
        Collection<V> valuesToClose = null;
        try {
            this.writeLock.lock();
            valuesToClose = this.markAndSweep();
            if (valuesToClose != null && valuesToClose.contains(value)) {
                valuesToClose.remove(value);
            }
            this.map.put(key, value);
            TTLValue ttl = new TTLValue(System.currentTimeMillis(), ttlInMilliSeconds);
            ttl.refCount.incrementAndGet();
            this.ttlMap.put(key, (io.logz.sender.java.lang.Object)ttl);
        }
        finally {
            this.writeLock.unlock();
        }
        if (valuesToClose != null && valuesToClose.size() > 0) {
            if (logger.isDebugEnabled()) {
                int size = valuesToClose.size();
                logger.info(new StringBuilder().append((String)"io.logz.sender.Mark&Sweep found ").append(size).append((String)(size > 1 ? "io.logz.sender. resources" : "io.logz.sender. resource")).append((String)"io.logz.sender. to close.").toString());
            }
            executorService.execute(new ValueCloser<V>(valuesToClose));
        }
    }

    public void put(K key, V value) {
        this.put(key, value, 10000L);
    }

    private Collection<V> markAndSweep() {
        HashSet valuesToClose = null;
        this.keysToRemove.clear();
        Set keys = this.ttlMap.keySet();
        long currentTS = System.currentTimeMillis();
        for (io.logz.sender.java.lang.Object key : keys) {
            TTLValue ttl = (TTLValue)this.ttlMap.get(key);
            if (ttl.refCount.get() > 0L || currentTS - ttl.lastAccessedTimestamp.get() <= ttl.ttl) continue;
            this.keysToRemove.add(key);
        }
        if (this.keysToRemove.size() > 0) {
            valuesToClose = new HashSet();
            for (io.logz.sender.java.lang.Object key : this.keysToRemove) {
                Closeable v = (Closeable)this.map.remove(key);
                valuesToClose.add((io.logz.sender.java.lang.Object)v);
                this.ttlMap.remove(key);
            }
        }
        return valuesToClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        try {
            this.readLock.lock();
            TTLValue ttl = (TTLValue)this.ttlMap.get(key);
            if (ttl != null) {
                ttl.lastAccessedTimestamp.set(System.currentTimeMillis());
                ttl.refCount.incrementAndGet();
            }
            Closeable closeable = (Closeable)this.map.get(key);
            return (V)closeable;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void release(K key) {
        try {
            this.readLock.lock();
            TTLValue ttl = (TTLValue)this.ttlMap.get(key);
            if (ttl != null) {
                ttl.refCount.decrementAndGet();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int size() {
        try {
            this.readLock.lock();
            int n = this.map.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        try {
            this.writeLock.lock();
            HashSet valuesToClose = new HashSet();
            valuesToClose.addAll(this.map.values());
            if (valuesToClose != null && valuesToClose.size() > 0) {
                for (Closeable v : valuesToClose) {
                    CloseCommand.close(v);
                }
            }
            this.map.clear();
            this.ttlMap.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        try {
            this.writeLock.lock();
            this.ttlMap.remove(key);
            Closeable value = (Closeable)this.map.remove(key);
            if (value != null) {
                CloseCommand.close(value);
            }
            Closeable closeable = value;
            return (V)closeable;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<V> getValues() {
        try {
            this.readLock.lock();
            ArrayList col = new ArrayList();
            for (Closeable v : this.map.values()) {
                col.add((io.logz.sender.java.lang.Object)v);
            }
            Iterator iterator = col;
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private static class ValueCloser<V extends Closeable>
    extends io.logz.sender.java.lang.Object
    implements Runnable {
        Collection<V> valuesToClose;

        public ValueCloser(Collection<V> valuesToClose) {
            this.valuesToClose = valuesToClose;
        }

        public void run() {
            int size = this.valuesToClose.size();
            for (Closeable v : this.valuesToClose) {
                if (v == null) continue;
                CloseCommand.close(v);
            }
            if (logger.isDebugEnabled()) {
                logger.debug(new StringBuilder().append((String)"io.logz.sender.ResourceCloser closed ").append(size).append((String)(size > 1 ? "io.logz.sender. resources." : "io.logz.sender. resource.")).toString());
            }
        }
    }

    private static class TTLValue
    extends io.logz.sender.java.lang.Object {
        AtomicLong lastAccessedTimestamp;
        AtomicLong refCount = new AtomicLong(0L);
        long ttl;

        public TTLValue(long ts, long ttl) {
            this.lastAccessedTimestamp = new AtomicLong(ts);
            this.ttl = ttl;
        }
    }
}

