/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.bluejeans.common.bigqueue;

import io.logz.sender.java.io.Closeable;
import io.logz.sender.java.lang.Class;
import io.logz.sender.java.lang.Exception;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.lang.ThreadLocal;
import io.logz.sender.java.lang.reflect.Method;
import io.logz.sender.java.nio.ByteBuffer;
import io.logz.sender.java.nio.MappedByteBuffer;
import io.logz.sender.org.slf4j.Logger;
import io.logz.sender.org.slf4j.LoggerFactory;

class MappedPage
extends io.logz.sender.java.lang.Object
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(MappedPage.class);
    private ThreadLocalByteBuffer threadLocalBuffer;
    private volatile boolean dirty = false;
    private volatile boolean closed = false;
    private final String pageFile;
    private final long index;

    public MappedPage(MappedByteBuffer mbb, String pageFile, long index) {
        this.threadLocalBuffer = new ThreadLocalByteBuffer((ByteBuffer)mbb);
        this.pageFile = pageFile;
        this.index = index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        MappedPage mappedPage = this;
        synchronized (mappedPage) {
            if (this.closed) {
                return;
            }
            this.flush();
            MappedByteBuffer srcBuf = (MappedByteBuffer)this.threadLocalBuffer.getSourceBuffer();
            MappedPage.unmap(srcBuf);
            this.threadLocalBuffer = null;
            this.closed = true;
            if (logger.isDebugEnabled()) {
                logger.debug(new StringBuilder().append((String)"io.logz.sender.Mapped page for ").append(this.pageFile).append((String)"io.logz.sender. was just unmapped and closed.").toString());
            }
        }
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        MappedPage mappedPage = this;
        synchronized (mappedPage) {
            if (this.closed) {
                return;
            }
            if (this.dirty) {
                MappedByteBuffer srcBuf = (MappedByteBuffer)this.threadLocalBuffer.getSourceBuffer();
                srcBuf.force();
                this.dirty = false;
                if (logger.isDebugEnabled()) {
                    logger.debug(new StringBuilder().append((String)"io.logz.sender.Mapped page for ").append(this.pageFile).append((String)"io.logz.sender. was just flushed.").toString());
                }
            }
        }
    }

    public byte[] getLocal(int position, int length) {
        ByteBuffer buf = this.getLocal(position);
        byte[] data = new byte[length];
        buf.get(data);
        return data;
    }

    public ByteBuffer getLocal(int position) {
        ByteBuffer buf = (ByteBuffer)this.threadLocalBuffer.get();
        buf.position(position);
        return buf;
    }

    private static void unmap(MappedByteBuffer buffer) {
        Cleaner.clean((ByteBuffer)buffer);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String toString() {
        return new StringBuilder().append((String)"io.logz.sender.Mapped page for ").append(this.pageFile).append((String)"io.logz.sender., index = ").append(this.index).append((String)"io.logz.sender..").toString();
    }

    public String getPageFile() {
        return this.pageFile;
    }

    public long getPageIndex() {
        return this.index;
    }

    private static class ThreadLocalByteBuffer
    extends ThreadLocal<ByteBuffer> {
        private final ByteBuffer _src;

        public ThreadLocalByteBuffer(ByteBuffer src) {
            this._src = src;
        }

        public ByteBuffer getSourceBuffer() {
            return this._src;
        }

        protected synchronized ByteBuffer initialValue() {
            ByteBuffer dup = this._src.duplicate();
            return dup;
        }
    }

    private static class Cleaner
    extends io.logz.sender.java.lang.Object {
        public static final boolean CLEAN_SUPPORTED;
        private static final Method directBufferCleaner;
        private static final Method directBufferCleanerClean;

        private Cleaner() {
        }

        public static void clean(ByteBuffer buffer) {
            if (buffer == null) {
                return;
            }
            if (CLEAN_SUPPORTED && buffer.isDirect()) {
                try {
                    io.logz.sender.java.lang.Object cleaner = directBufferCleaner.invoke((io.logz.sender.java.lang.Object)buffer, new io.logz.sender.java.lang.Object[0]);
                    directBufferCleanerClean.invoke(cleaner, new io.logz.sender.java.lang.Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        static {
            boolean v;
            Method directBufferCleanerX = null;
            Method directBufferCleanerCleanX = null;
            try {
                directBufferCleanerX = Class.forName((String)"io.logz.sender.java.nio.DirectByteBuffer").getMethod((String)"io.logz.sender.cleaner", new Class[0]);
                directBufferCleanerX.setAccessible(true);
                directBufferCleanerCleanX = Class.forName((String)"io.logz.sender.sun.misc.Cleaner").getMethod((String)"io.logz.sender.clean", new Class[0]);
                directBufferCleanerCleanX.setAccessible(true);
                v = true;
            }
            catch (Exception e) {
                v = false;
            }
            CLEAN_SUPPORTED = v;
            directBufferCleaner = directBufferCleanerX;
            directBufferCleanerClean = directBufferCleanerCleanX;
        }
    }
}

