/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.base;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.base.Function;
import io.logz.sender.com.google.common.base.Optional;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.base.Supplier;
import io.logz.sender.java.lang.IllegalStateException;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.util.Collections;
import io.logz.sender.java.util.Set;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible
final class Absent<T extends io.logz.sender.java.lang.Object>
extends Optional<T> {
    static final Absent<io.logz.sender.java.lang.Object> INSTANCE = new Absent();
    private static final long serialVersionUID = 0L;

    static <T extends io.logz.sender.java.lang.Object> Optional<T> withType() {
        return INSTANCE;
    }

    private Absent() {
    }

    @Override
    public boolean isPresent() {
        return false;
    }

    @Override
    public T get() {
        throw new IllegalStateException((String)"io.logz.sender.Optional.get() cannot be called on an absent value");
    }

    @Override
    public T or(T defaultValue) {
        return Preconditions.checkNotNull(defaultValue, (io.logz.sender.java.lang.Object)"io.logz.sender.use Optional.orNull() instead of Optional.or(null)");
    }

    @Override
    public Optional<T> or(Optional<? extends T> secondChoice) {
        return Preconditions.checkNotNull(secondChoice);
    }

    @Override
    public T or(Supplier<? extends T> supplier) {
        return Preconditions.checkNotNull(supplier.get(), (io.logz.sender.java.lang.Object)"io.logz.sender.use Optional.orNull() instead of a Supplier that returns null");
    }

    @Override
    @NullableDecl
    public T orNull() {
        return null;
    }

    @Override
    public Set<T> asSet() {
        return Collections.emptySet();
    }

    @Override
    public <V extends io.logz.sender.java.lang.Object> Optional<V> transform(Function<? super T, V> function) {
        Preconditions.checkNotNull(function);
        return Optional.absent();
    }

    @Override
    public boolean equals(@NullableDecl io.logz.sender.java.lang.Object object) {
        return object == this;
    }

    @Override
    public int hashCode() {
        return 2040732332;
    }

    @Override
    public String toString() {
        return "io.logz.sender.Optional.absent()";
    }

    private io.logz.sender.java.lang.Object readResolve() {
        return INSTANCE;
    }
}

