/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.base;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.logz.sender.java.lang.Enum;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.UnsupportedOperationException;
import io.logz.sender.java.util.Iterator;
import io.logz.sender.java.util.NoSuchElementException;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible
abstract class AbstractIterator<T extends io.logz.sender.java.lang.Object>
extends io.logz.sender.java.lang.Object
implements Iterator<T> {
    private State state = State.NOT_READY;
    @NullableDecl
    private T next;

    protected AbstractIterator() {
    }

    protected abstract T computeNext();

    @NullableDecl
    @CanIgnoreReturnValue
    protected final T endOfData() {
        this.state = State.DONE;
        return null;
    }

    public final boolean hasNext() {
        Preconditions.checkState(this.state != State.FAILED);
        switch (this.state) {
            case READY: {
                return true;
            }
            case DONE: {
                return false;
            }
        }
        return this.tryToComputeNext();
    }

    private boolean tryToComputeNext() {
        this.state = State.FAILED;
        this.next = this.computeNext();
        if (this.state != State.DONE) {
            this.state = State.READY;
            return true;
        }
        return false;
    }

    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = State.NOT_READY;
        T result = this.next;
        this.next = null;
        return result;
    }

    public final void remove() {
        throw new UnsupportedOperationException();
    }

    private static final class State
    extends Enum<State> {
        public static final /* enum */ State READY = new State((String)"io.logz.sender.READY", 0);
        public static final /* enum */ State NOT_READY = new State((String)"io.logz.sender.NOT_READY", 1);
        public static final /* enum */ State DONE = new State((String)"io.logz.sender.DONE", 2);
        public static final /* enum */ State FAILED = new State((String)"io.logz.sender.FAILED", 3);
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String name) {
            return (State)Enum.valueOf(State.class, (String)name);
        }

        private State() {
            super((String)string, n);
        }

        static {
            $VALUES = new State[]{READY, NOT_READY, DONE, FAILED};
        }
    }
}

