/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.base;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.logz.sender.java.lang.CharSequence;
import io.logz.sender.java.lang.Class;
import io.logz.sender.java.lang.NullPointerException;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.util.Arrays;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible
public final class MoreObjects
extends io.logz.sender.java.lang.Object {
    public static <T extends io.logz.sender.java.lang.Object> T firstNonNull(@NullableDecl T first, @NullableDecl T second) {
        if (first != null) {
            return first;
        }
        if (second != null) {
            return second;
        }
        throw new NullPointerException((String)"io.logz.sender.Both parameters are null");
    }

    public static ToStringHelper toStringHelper(io.logz.sender.java.lang.Object self) {
        return new ToStringHelper(self.getClass().getSimpleName());
    }

    public static ToStringHelper toStringHelper(Class<?> clazz) {
        return new ToStringHelper(clazz.getSimpleName());
    }

    public static ToStringHelper toStringHelper(String className) {
        return new ToStringHelper(className);
    }

    private MoreObjects() {
    }

    public static final class ToStringHelper
    extends io.logz.sender.java.lang.Object {
        private final String className;
        private final ValueHolder holderHead;
        private ValueHolder holderTail;
        private boolean omitNullValues;

        private ToStringHelper(String className) {
            this.holderTail = this.holderHead = new ValueHolder();
            this.omitNullValues = false;
            this.className = Preconditions.checkNotNull(className);
        }

        @CanIgnoreReturnValue
        public ToStringHelper omitNullValues() {
            this.omitNullValues = true;
            return this;
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String name, @NullableDecl io.logz.sender.java.lang.Object value) {
            return this.addHolder(name, value);
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String name, boolean value) {
            return this.addHolder(name, (io.logz.sender.java.lang.Object)String.valueOf((boolean)value));
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String name, char value) {
            return this.addHolder(name, (io.logz.sender.java.lang.Object)String.valueOf((char)value));
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String name, double value) {
            return this.addHolder(name, (io.logz.sender.java.lang.Object)String.valueOf((double)value));
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String name, float value) {
            return this.addHolder(name, (io.logz.sender.java.lang.Object)String.valueOf((float)value));
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String name, int value) {
            return this.addHolder(name, (io.logz.sender.java.lang.Object)String.valueOf((int)value));
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String name, long value) {
            return this.addHolder(name, (io.logz.sender.java.lang.Object)String.valueOf((long)value));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(@NullableDecl io.logz.sender.java.lang.Object value) {
            return this.addHolder(value);
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(boolean value) {
            return this.addHolder((io.logz.sender.java.lang.Object)String.valueOf((boolean)value));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(char value) {
            return this.addHolder((io.logz.sender.java.lang.Object)String.valueOf((char)value));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(double value) {
            return this.addHolder((io.logz.sender.java.lang.Object)String.valueOf((double)value));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(float value) {
            return this.addHolder((io.logz.sender.java.lang.Object)String.valueOf((float)value));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(int value) {
            return this.addHolder((io.logz.sender.java.lang.Object)String.valueOf((int)value));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(long value) {
            return this.addHolder((io.logz.sender.java.lang.Object)String.valueOf((long)value));
        }

        public String toString() {
            boolean omitNullValuesSnapshot = this.omitNullValues;
            java.lang.String nextSeparator = "io.logz.sender.";
            StringBuilder builder = new StringBuilder(32).append(this.className).append('{');
            ValueHolder valueHolder = this.holderHead.next;
            while (valueHolder != null) {
                io.logz.sender.java.lang.Object value = valueHolder.value;
                if (!omitNullValuesSnapshot || value != null) {
                    builder.append((String)nextSeparator);
                    nextSeparator = "io.logz.sender., ";
                    if (valueHolder.name != null) {
                        builder.append(valueHolder.name).append('=');
                    }
                    if (value != null && value.getClass().isArray()) {
                        io.logz.sender.java.lang.Object[] objectArray = new io.logz.sender.java.lang.Object[]{value};
                        String arrayString = Arrays.deepToString((io.logz.sender.java.lang.Object[])objectArray);
                        builder.append((CharSequence)arrayString, 1, arrayString.length() - 1);
                    } else {
                        builder.append(value);
                    }
                }
                valueHolder = valueHolder.next;
            }
            return builder.append('}').toString();
        }

        private ValueHolder addHolder() {
            ValueHolder valueHolder;
            this.holderTail = this.holderTail.next = (valueHolder = new ValueHolder());
            return valueHolder;
        }

        private ToStringHelper addHolder(@NullableDecl io.logz.sender.java.lang.Object value) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.value = value;
            return this;
        }

        private ToStringHelper addHolder(String name, @NullableDecl io.logz.sender.java.lang.Object value) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.value = value;
            valueHolder.name = Preconditions.checkNotNull(name);
            return this;
        }

        private static final class ValueHolder
        extends io.logz.sender.java.lang.Object {
            @NullableDecl
            String name;
            @NullableDecl
            io.logz.sender.java.lang.Object value;
            @NullableDecl
            ValueHolder next;

            private ValueHolder() {
            }
        }
    }
}

