/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.base;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.logz.sender.java.lang.CharSequence;
import io.logz.sender.java.lang.Character;
import io.logz.sender.java.lang.IllegalArgumentException;
import io.logz.sender.java.lang.IllegalStateException;
import io.logz.sender.java.lang.IndexOutOfBoundsException;
import io.logz.sender.java.lang.Integer;
import io.logz.sender.java.lang.Long;
import io.logz.sender.java.lang.NullPointerException;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible
public final class Preconditions
extends io.logz.sender.java.lang.Object {
    private Preconditions() {
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, @NullableDecl io.logz.sender.java.lang.Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf((io.logz.sender.java.lang.Object)errorMessage));
        }
    }

    public static void checkArgument(boolean expression, @NullableDecl String errorMessageTemplate, io.logz.sender.java.lang.Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkArgument(boolean b, @NullableDecl String errorMessageTemplate, char p1) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Character.valueOf((char)p1)}));
        }
    }

    public static void checkArgument(boolean b, @NullableDecl String errorMessageTemplate, int p1) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Integer.valueOf((int)p1)}));
        }
    }

    public static void checkArgument(boolean b, @NullableDecl String errorMessageTemplate, long p1) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Long.valueOf((long)p1)}));
        }
    }

    public static void checkArgument(boolean b, @NullableDecl String errorMessageTemplate, @NullableDecl io.logz.sender.java.lang.Object p1) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1));
        }
    }

    public static void checkArgument(boolean b, @NullableDecl String errorMessageTemplate, char p1, char p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Character.valueOf((char)p1), Character.valueOf((char)p2)}));
        }
    }

    public static void checkArgument(boolean b, @NullableDecl String errorMessageTemplate, char p1, int p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Character.valueOf((char)p1), Integer.valueOf((int)p2)}));
        }
    }

    public static void checkArgument(boolean b, @NullableDecl String errorMessageTemplate, char p1, long p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Character.valueOf((char)p1), Long.valueOf((long)p2)}));
        }
    }

    public static void checkArgument(boolean b, @NullableDecl String errorMessageTemplate, char p1, @NullableDecl io.logz.sender.java.lang.Object p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Character.valueOf((char)p1), p2}));
        }
    }

    public static void checkArgument(boolean b, @NullableDecl String errorMessageTemplate, int p1, char p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Integer.valueOf((int)p1), Character.valueOf((char)p2)}));
        }
    }

    public static void checkArgument(boolean b, @NullableDecl String errorMessageTemplate, int p1, int p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Integer.valueOf((int)p1), Integer.valueOf((int)p2)}));
        }
    }

    public static void checkArgument(boolean b, @NullableDecl String errorMessageTemplate, int p1, long p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Integer.valueOf((int)p1), Long.valueOf((long)p2)}));
        }
    }

    public static void checkArgument(boolean b, @NullableDecl String errorMessageTemplate, int p1, @NullableDecl io.logz.sender.java.lang.Object p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Integer.valueOf((int)p1), p2}));
        }
    }

    public static void checkArgument(boolean b, @NullableDecl String errorMessageTemplate, long p1, char p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Long.valueOf((long)p1), Character.valueOf((char)p2)}));
        }
    }

    public static void checkArgument(boolean b, @NullableDecl String errorMessageTemplate, long p1, int p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Long.valueOf((long)p1), Integer.valueOf((int)p2)}));
        }
    }

    public static void checkArgument(boolean b, @NullableDecl String errorMessageTemplate, long p1, long p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Long.valueOf((long)p1), Long.valueOf((long)p2)}));
        }
    }

    public static void checkArgument(boolean b, @NullableDecl String errorMessageTemplate, long p1, @NullableDecl io.logz.sender.java.lang.Object p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Long.valueOf((long)p1), p2}));
        }
    }

    public static void checkArgument(boolean b, @NullableDecl String errorMessageTemplate, @NullableDecl io.logz.sender.java.lang.Object p1, char p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{p1, Character.valueOf((char)p2)}));
        }
    }

    public static void checkArgument(boolean b, @NullableDecl String errorMessageTemplate, @NullableDecl io.logz.sender.java.lang.Object p1, int p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{p1, Integer.valueOf((int)p2)}));
        }
    }

    public static void checkArgument(boolean b, @NullableDecl String errorMessageTemplate, @NullableDecl io.logz.sender.java.lang.Object p1, long p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{p1, Long.valueOf((long)p2)}));
        }
    }

    public static void checkArgument(boolean b, @NullableDecl String errorMessageTemplate, @NullableDecl io.logz.sender.java.lang.Object p1, @NullableDecl io.logz.sender.java.lang.Object p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(boolean b, @NullableDecl String errorMessageTemplate, @NullableDecl io.logz.sender.java.lang.Object p1, @NullableDecl io.logz.sender.java.lang.Object p2, @NullableDecl io.logz.sender.java.lang.Object p3) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, p2, p3));
        }
    }

    public static void checkArgument(boolean b, @NullableDecl String errorMessageTemplate, @NullableDecl io.logz.sender.java.lang.Object p1, @NullableDecl io.logz.sender.java.lang.Object p2, @NullableDecl io.logz.sender.java.lang.Object p3, @NullableDecl io.logz.sender.java.lang.Object p4) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, p2, p3, p4));
        }
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression, @NullableDecl io.logz.sender.java.lang.Object errorMessage) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf((io.logz.sender.java.lang.Object)errorMessage));
        }
    }

    public static void checkState(boolean expression, @NullableDecl String errorMessageTemplate, io.logz.sender.java.lang.Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkState(boolean b, @NullableDecl String errorMessageTemplate, char p1) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Character.valueOf((char)p1)}));
        }
    }

    public static void checkState(boolean b, @NullableDecl String errorMessageTemplate, int p1) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Integer.valueOf((int)p1)}));
        }
    }

    public static void checkState(boolean b, @NullableDecl String errorMessageTemplate, long p1) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Long.valueOf((long)p1)}));
        }
    }

    public static void checkState(boolean b, @NullableDecl String errorMessageTemplate, @NullableDecl io.logz.sender.java.lang.Object p1) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1));
        }
    }

    public static void checkState(boolean b, @NullableDecl String errorMessageTemplate, char p1, char p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Character.valueOf((char)p1), Character.valueOf((char)p2)}));
        }
    }

    public static void checkState(boolean b, @NullableDecl String errorMessageTemplate, char p1, int p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Character.valueOf((char)p1), Integer.valueOf((int)p2)}));
        }
    }

    public static void checkState(boolean b, @NullableDecl String errorMessageTemplate, char p1, long p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Character.valueOf((char)p1), Long.valueOf((long)p2)}));
        }
    }

    public static void checkState(boolean b, @NullableDecl String errorMessageTemplate, char p1, @NullableDecl io.logz.sender.java.lang.Object p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Character.valueOf((char)p1), p2}));
        }
    }

    public static void checkState(boolean b, @NullableDecl String errorMessageTemplate, int p1, char p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Integer.valueOf((int)p1), Character.valueOf((char)p2)}));
        }
    }

    public static void checkState(boolean b, @NullableDecl String errorMessageTemplate, int p1, int p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Integer.valueOf((int)p1), Integer.valueOf((int)p2)}));
        }
    }

    public static void checkState(boolean b, @NullableDecl String errorMessageTemplate, int p1, long p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Integer.valueOf((int)p1), Long.valueOf((long)p2)}));
        }
    }

    public static void checkState(boolean b, @NullableDecl String errorMessageTemplate, int p1, @NullableDecl io.logz.sender.java.lang.Object p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Integer.valueOf((int)p1), p2}));
        }
    }

    public static void checkState(boolean b, @NullableDecl String errorMessageTemplate, long p1, char p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Long.valueOf((long)p1), Character.valueOf((char)p2)}));
        }
    }

    public static void checkState(boolean b, @NullableDecl String errorMessageTemplate, long p1, int p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Long.valueOf((long)p1), Integer.valueOf((int)p2)}));
        }
    }

    public static void checkState(boolean b, @NullableDecl String errorMessageTemplate, long p1, long p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Long.valueOf((long)p1), Long.valueOf((long)p2)}));
        }
    }

    public static void checkState(boolean b, @NullableDecl String errorMessageTemplate, long p1, @NullableDecl io.logz.sender.java.lang.Object p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Long.valueOf((long)p1), p2}));
        }
    }

    public static void checkState(boolean b, @NullableDecl String errorMessageTemplate, @NullableDecl io.logz.sender.java.lang.Object p1, char p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{p1, Character.valueOf((char)p2)}));
        }
    }

    public static void checkState(boolean b, @NullableDecl String errorMessageTemplate, @NullableDecl io.logz.sender.java.lang.Object p1, int p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{p1, Integer.valueOf((int)p2)}));
        }
    }

    public static void checkState(boolean b, @NullableDecl String errorMessageTemplate, @NullableDecl io.logz.sender.java.lang.Object p1, long p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{p1, Long.valueOf((long)p2)}));
        }
    }

    public static void checkState(boolean b, @NullableDecl String errorMessageTemplate, @NullableDecl io.logz.sender.java.lang.Object p1, @NullableDecl io.logz.sender.java.lang.Object p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(boolean b, @NullableDecl String errorMessageTemplate, @NullableDecl io.logz.sender.java.lang.Object p1, @NullableDecl io.logz.sender.java.lang.Object p2, @NullableDecl io.logz.sender.java.lang.Object p3) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, p2, p3));
        }
    }

    public static void checkState(boolean b, @NullableDecl String errorMessageTemplate, @NullableDecl io.logz.sender.java.lang.Object p1, @NullableDecl io.logz.sender.java.lang.Object p2, @NullableDecl io.logz.sender.java.lang.Object p3, @NullableDecl io.logz.sender.java.lang.Object p4) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, p2, p3, p4));
        }
    }

    @CanIgnoreReturnValue
    public static <T extends io.logz.sender.java.lang.Object> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T extends io.logz.sender.java.lang.Object> T checkNotNull(T reference, @NullableDecl io.logz.sender.java.lang.Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf((io.logz.sender.java.lang.Object)errorMessage));
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T extends io.logz.sender.java.lang.Object> T checkNotNull(T reference, @NullableDecl String errorMessageTemplate, io.logz.sender.java.lang.Object ... errorMessageArgs) {
        if (reference == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T extends io.logz.sender.java.lang.Object> T checkNotNull(T obj, @NullableDecl String errorMessageTemplate, char p1) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Character.valueOf((char)p1)}));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T extends io.logz.sender.java.lang.Object> T checkNotNull(T obj, @NullableDecl String errorMessageTemplate, int p1) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Integer.valueOf((int)p1)}));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T extends io.logz.sender.java.lang.Object> T checkNotNull(T obj, @NullableDecl String errorMessageTemplate, long p1) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Long.valueOf((long)p1)}));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T extends io.logz.sender.java.lang.Object> T checkNotNull(T obj, @NullableDecl String errorMessageTemplate, @NullableDecl io.logz.sender.java.lang.Object p1) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T extends io.logz.sender.java.lang.Object> T checkNotNull(T obj, @NullableDecl String errorMessageTemplate, char p1, char p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Character.valueOf((char)p1), Character.valueOf((char)p2)}));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T extends io.logz.sender.java.lang.Object> T checkNotNull(T obj, @NullableDecl String errorMessageTemplate, char p1, int p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Character.valueOf((char)p1), Integer.valueOf((int)p2)}));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T extends io.logz.sender.java.lang.Object> T checkNotNull(T obj, @NullableDecl String errorMessageTemplate, char p1, long p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Character.valueOf((char)p1), Long.valueOf((long)p2)}));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T extends io.logz.sender.java.lang.Object> T checkNotNull(T obj, @NullableDecl String errorMessageTemplate, char p1, @NullableDecl io.logz.sender.java.lang.Object p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Character.valueOf((char)p1), p2}));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T extends io.logz.sender.java.lang.Object> T checkNotNull(T obj, @NullableDecl String errorMessageTemplate, int p1, char p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Integer.valueOf((int)p1), Character.valueOf((char)p2)}));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T extends io.logz.sender.java.lang.Object> T checkNotNull(T obj, @NullableDecl String errorMessageTemplate, int p1, int p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Integer.valueOf((int)p1), Integer.valueOf((int)p2)}));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T extends io.logz.sender.java.lang.Object> T checkNotNull(T obj, @NullableDecl String errorMessageTemplate, int p1, long p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Integer.valueOf((int)p1), Long.valueOf((long)p2)}));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T extends io.logz.sender.java.lang.Object> T checkNotNull(T obj, @NullableDecl String errorMessageTemplate, int p1, @NullableDecl io.logz.sender.java.lang.Object p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Integer.valueOf((int)p1), p2}));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T extends io.logz.sender.java.lang.Object> T checkNotNull(T obj, @NullableDecl String errorMessageTemplate, long p1, char p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Long.valueOf((long)p1), Character.valueOf((char)p2)}));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T extends io.logz.sender.java.lang.Object> T checkNotNull(T obj, @NullableDecl String errorMessageTemplate, long p1, int p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Long.valueOf((long)p1), Integer.valueOf((int)p2)}));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T extends io.logz.sender.java.lang.Object> T checkNotNull(T obj, @NullableDecl String errorMessageTemplate, long p1, long p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Long.valueOf((long)p1), Long.valueOf((long)p2)}));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T extends io.logz.sender.java.lang.Object> T checkNotNull(T obj, @NullableDecl String errorMessageTemplate, long p1, @NullableDecl io.logz.sender.java.lang.Object p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{Long.valueOf((long)p1), p2}));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T extends io.logz.sender.java.lang.Object> T checkNotNull(T obj, @NullableDecl String errorMessageTemplate, @NullableDecl io.logz.sender.java.lang.Object p1, char p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{p1, Character.valueOf((char)p2)}));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T extends io.logz.sender.java.lang.Object> T checkNotNull(T obj, @NullableDecl String errorMessageTemplate, @NullableDecl io.logz.sender.java.lang.Object p1, int p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{p1, Integer.valueOf((int)p2)}));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T extends io.logz.sender.java.lang.Object> T checkNotNull(T obj, @NullableDecl String errorMessageTemplate, @NullableDecl io.logz.sender.java.lang.Object p1, long p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, new io.logz.sender.java.lang.Object[]{p1, Long.valueOf((long)p2)}));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T extends io.logz.sender.java.lang.Object> T checkNotNull(T obj, @NullableDecl String errorMessageTemplate, @NullableDecl io.logz.sender.java.lang.Object p1, @NullableDecl io.logz.sender.java.lang.Object p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T extends io.logz.sender.java.lang.Object> T checkNotNull(T obj, @NullableDecl String errorMessageTemplate, @NullableDecl io.logz.sender.java.lang.Object p1, @NullableDecl io.logz.sender.java.lang.Object p2, @NullableDecl io.logz.sender.java.lang.Object p3) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, p2, p3));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static <T extends io.logz.sender.java.lang.Object> T checkNotNull(T obj, @NullableDecl String errorMessageTemplate, @NullableDecl io.logz.sender.java.lang.Object p1, @NullableDecl io.logz.sender.java.lang.Object p2, @NullableDecl io.logz.sender.java.lang.Object p3, @NullableDecl io.logz.sender.java.lang.Object p4) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, p2, p3, p4));
        }
        return obj;
    }

    @CanIgnoreReturnValue
    public static int checkElementIndex(int index, int size) {
        return Preconditions.checkElementIndex(index, size, (String)"io.logz.sender.index");
    }

    @CanIgnoreReturnValue
    public static int checkElementIndex(int index, int size, @NullableDecl String desc) {
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException(Preconditions.badElementIndex(index, size, desc));
        }
        return index;
    }

    private static String badElementIndex(int index, int size, @NullableDecl String desc) {
        if (index < 0) {
            return Preconditions.format((String)"io.logz.sender.%s (%s) must not be negative", new io.logz.sender.java.lang.Object[]{desc, Integer.valueOf((int)index)});
        }
        if (size < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((String)"io.logz.sender.negative size: ").append(size).toString());
        }
        return Preconditions.format((String)"io.logz.sender.%s (%s) must be less than size (%s)", new io.logz.sender.java.lang.Object[]{desc, Integer.valueOf((int)index), Integer.valueOf((int)size)});
    }

    @CanIgnoreReturnValue
    public static int checkPositionIndex(int index, int size) {
        return Preconditions.checkPositionIndex(index, size, (String)"io.logz.sender.index");
    }

    @CanIgnoreReturnValue
    public static int checkPositionIndex(int index, int size, @NullableDecl String desc) {
        if (index < 0 || index > size) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndex(index, size, desc));
        }
        return index;
    }

    private static String badPositionIndex(int index, int size, @NullableDecl String desc) {
        if (index < 0) {
            return Preconditions.format((String)"io.logz.sender.%s (%s) must not be negative", new io.logz.sender.java.lang.Object[]{desc, Integer.valueOf((int)index)});
        }
        if (size < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((String)"io.logz.sender.negative size: ").append(size).toString());
        }
        return Preconditions.format((String)"io.logz.sender.%s (%s) must not be greater than size (%s)", new io.logz.sender.java.lang.Object[]{desc, Integer.valueOf((int)index), Integer.valueOf((int)size)});
    }

    public static void checkPositionIndexes(int start, int end, int size) {
        if (start < 0 || end < start || end > size) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndexes(start, end, size));
        }
    }

    private static String badPositionIndexes(int start, int end, int size) {
        if (start < 0 || start > size) {
            return Preconditions.badPositionIndex(start, size, (String)"io.logz.sender.start index");
        }
        if (end < 0 || end > size) {
            return Preconditions.badPositionIndex(end, size, (String)"io.logz.sender.end index");
        }
        return Preconditions.format((String)"io.logz.sender.end index (%s) must not be less than start index (%s)", new io.logz.sender.java.lang.Object[]{Integer.valueOf((int)end), Integer.valueOf((int)start)});
    }

    static String format(@NullableDecl String template, io.logz.sender.java.lang.Object ... args) {
        int placeholderStart;
        io.logz.sender.java.lang.Object[] objectArray;
        template = String.valueOf((io.logz.sender.java.lang.Object)template);
        if (args == null) {
            io.logz.sender.java.lang.Object[] objectArray2 = new io.logz.sender.java.lang.Object[1];
            objectArray = objectArray2;
            objectArray2[0] = "io.logz.sender.(Object[])null";
        } else {
            objectArray = args;
        }
        args = objectArray;
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf((String)"io.logz.sender.%s", templateStart)) != -1) {
            builder.append((CharSequence)template, templateStart, placeholderStart);
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append((CharSequence)template, templateStart, template.length());
        if (i < args.length) {
            builder.append((String)"io.logz.sender. [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append((String)"io.logz.sender., ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }
}

