/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.base;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.annotations.VisibleForTesting;
import io.logz.sender.com.google.common.base.Platform;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.java.lang.ArrayIndexOutOfBoundsException;
import io.logz.sender.java.lang.CharSequence;
import io.logz.sender.java.lang.Character;
import io.logz.sender.java.lang.Math;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.lang.System;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible
public final class Strings
extends io.logz.sender.java.lang.Object {
    private Strings() {
    }

    public static String nullToEmpty(@NullableDecl String string) {
        return Platform.nullToEmpty(string);
    }

    @NullableDecl
    public static String emptyToNull(@NullableDecl String string) {
        return Platform.emptyToNull(string);
    }

    public static boolean isNullOrEmpty(@NullableDecl String string) {
        return Platform.stringIsNullOrEmpty(string);
    }

    public static String padStart(String string, int minLength, char padChar) {
        Preconditions.checkNotNull(string);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder sb = new StringBuilder(minLength);
        for (int i = string.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        sb.append(string);
        return sb.toString();
    }

    public static String padEnd(String string, int minLength, char padChar) {
        Preconditions.checkNotNull(string);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder sb = new StringBuilder(minLength);
        sb.append(string);
        for (int i = string.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    public static String repeat(String string, int count) {
        int n;
        Preconditions.checkNotNull(string);
        if (count <= 1) {
            Preconditions.checkArgument(count >= 0, (String)"io.logz.sender.invalid count: %s", count);
            return count == 0 ? "io.logz.sender." : string;
        }
        int len = string.length();
        long longSize = (long)len * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException(new StringBuilder().append((String)"io.logz.sender.Required array size too large: ").append(longSize).toString());
        }
        char[] array = new char[size];
        string.getChars(0, len, array, 0);
        for (n = len; n < size - n; n <<= 1) {
            System.arraycopy((io.logz.sender.java.lang.Object)array, (int)0, (io.logz.sender.java.lang.Object)array, (int)n, (int)n);
        }
        System.arraycopy((io.logz.sender.java.lang.Object)array, (int)0, (io.logz.sender.java.lang.Object)array, (int)n, (int)(size - n));
        return new String(array);
    }

    public static String commonPrefix(CharSequence a, CharSequence b) {
        int p;
        Preconditions.checkNotNull(a);
        Preconditions.checkNotNull(b);
        int maxPrefixLength = Math.min((int)a.length(), (int)b.length());
        for (p = 0; p < maxPrefixLength && a.charAt(p) == b.charAt(p); ++p) {
        }
        if (Strings.validSurrogatePairAt(a, p - 1) || Strings.validSurrogatePairAt(b, p - 1)) {
            --p;
        }
        return a.subSequence(0, p).toString();
    }

    public static String commonSuffix(CharSequence a, CharSequence b) {
        int s;
        Preconditions.checkNotNull(a);
        Preconditions.checkNotNull(b);
        int maxSuffixLength = Math.min((int)a.length(), (int)b.length());
        for (s = 0; s < maxSuffixLength && a.charAt(a.length() - s - 1) == b.charAt(b.length() - s - 1); ++s) {
        }
        if (Strings.validSurrogatePairAt(a, a.length() - s - 1) || Strings.validSurrogatePairAt(b, b.length() - s - 1)) {
            --s;
        }
        return a.subSequence(a.length() - s, a.length()).toString();
    }

    @VisibleForTesting
    static boolean validSurrogatePairAt(CharSequence string, int index) {
        return index >= 0 && index <= string.length() - 2 && Character.isHighSurrogate((char)string.charAt(index)) && Character.isLowSurrogate((char)string.charAt(index + 1));
    }
}

