/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.base;

import io.logz.sender.com.google.common.annotations.Beta;
import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.annotations.GwtIncompatible;
import io.logz.sender.com.google.common.annotations.VisibleForTesting;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.logz.sender.java.io.PrintWriter;
import io.logz.sender.java.io.StringWriter;
import io.logz.sender.java.io.Writer;
import io.logz.sender.java.lang.Class;
import io.logz.sender.java.lang.ClassCastException;
import io.logz.sender.java.lang.Deprecated;
import io.logz.sender.java.lang.Error;
import io.logz.sender.java.lang.IllegalAccessException;
import io.logz.sender.java.lang.IllegalArgumentException;
import io.logz.sender.java.lang.Integer;
import io.logz.sender.java.lang.RuntimeException;
import io.logz.sender.java.lang.StackTraceElement;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.ThreadDeath;
import io.logz.sender.java.lang.Throwable;
import io.logz.sender.java.lang.UnsupportedOperationException;
import io.logz.sender.java.lang.reflect.InvocationTargetException;
import io.logz.sender.java.lang.reflect.Method;
import io.logz.sender.java.util.AbstractList;
import io.logz.sender.java.util.ArrayList;
import io.logz.sender.java.util.Arrays;
import io.logz.sender.java.util.Collections;
import io.logz.sender.java.util.List;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible(emulated=true)
public final class Throwables
extends io.logz.sender.java.lang.Object {
    @GwtIncompatible
    private static final String JAVA_LANG_ACCESS_CLASSNAME = "io.logz.sender.sun.misc.JavaLangAccess";
    @GwtIncompatible
    @VisibleForTesting
    static final String SHARED_SECRETS_CLASSNAME = "io.logz.sender.sun.misc.SharedSecrets";
    @NullableDecl
    @GwtIncompatible
    private static final io.logz.sender.java.lang.Object jla = Throwables.getJLA();
    @NullableDecl
    @GwtIncompatible
    private static final Method getStackTraceElementMethod = jla == null ? null : Throwables.getGetMethod();
    @NullableDecl
    @GwtIncompatible
    private static final Method getStackTraceDepthMethod = jla == null ? null : Throwables.getSizeMethod();

    private Throwables() {
    }

    @GwtIncompatible
    public static <X extends Throwable> void throwIfInstanceOf(Throwable throwable, Class<X> declaredType) throws X {
        Preconditions.checkNotNull(throwable);
        if (declaredType.isInstance((io.logz.sender.java.lang.Object)throwable)) {
            throw (Throwable)declaredType.cast((io.logz.sender.java.lang.Object)throwable);
        }
    }

    @Deprecated
    @GwtIncompatible
    public static <X extends Throwable> void propagateIfInstanceOf(@NullableDecl Throwable throwable, Class<X> declaredType) throws X {
        if (throwable != null) {
            Throwables.throwIfInstanceOf(throwable, declaredType);
        }
    }

    public static void throwIfUnchecked(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)((Object)throwable);
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
    }

    @Deprecated
    @GwtIncompatible
    public static void propagateIfPossible(@NullableDecl Throwable throwable) {
        if (throwable != null) {
            Throwables.throwIfUnchecked(throwable);
        }
    }

    @GwtIncompatible
    public static <X extends Throwable> void propagateIfPossible(@NullableDecl Throwable throwable, Class<X> declaredType) throws X {
        Throwables.propagateIfInstanceOf(throwable, declaredType);
        Throwables.propagateIfPossible(throwable);
    }

    @GwtIncompatible
    public static <X1 extends Throwable, X2 extends Throwable> void propagateIfPossible(@NullableDecl Throwable throwable, Class<X1> declaredType1, Class<X2> declaredType2) throws X1, X2 {
        Preconditions.checkNotNull(declaredType2);
        Throwables.propagateIfInstanceOf(throwable, declaredType1);
        Throwables.propagateIfPossible(throwable, declaredType2);
    }

    @Deprecated
    @CanIgnoreReturnValue
    @GwtIncompatible
    public static RuntimeException propagate(Throwable throwable) {
        Throwables.throwIfUnchecked(throwable);
        throw new RuntimeException(throwable);
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable cause;
        Throwable slowPointer = throwable;
        boolean advanceSlowPointer = false;
        while ((cause = throwable.getCause()) != null) {
            throwable = cause;
            if (throwable == slowPointer) {
                throw new IllegalArgumentException((String)"io.logz.sender.Loop in causal chain detected.", throwable);
            }
            if (advanceSlowPointer) {
                slowPointer = slowPointer.getCause();
            }
            advanceSlowPointer = !advanceSlowPointer;
        }
        return throwable;
    }

    @Beta
    public static List<Throwable> getCausalChain(Throwable throwable) {
        Throwable cause;
        Preconditions.checkNotNull(throwable);
        ArrayList causes = new ArrayList(4);
        causes.add((io.logz.sender.java.lang.Object)throwable);
        Throwable slowPointer = throwable;
        boolean advanceSlowPointer = false;
        while ((cause = throwable.getCause()) != null) {
            throwable = cause;
            causes.add((io.logz.sender.java.lang.Object)throwable);
            if (throwable == slowPointer) {
                throw new IllegalArgumentException((String)"io.logz.sender.Loop in causal chain detected.", throwable);
            }
            if (advanceSlowPointer) {
                slowPointer = slowPointer.getCause();
            }
            advanceSlowPointer = !advanceSlowPointer;
        }
        return Collections.unmodifiableList((List)causes);
    }

    @Beta
    @GwtIncompatible
    public static <X extends Throwable> X getCauseAs(Throwable throwable, Class<X> expectedCauseType) {
        try {
            return (X)((Object)((Throwable)expectedCauseType.cast((io.logz.sender.java.lang.Object)throwable.getCause())));
        }
        catch (ClassCastException e) {
            e.initCause(throwable);
            throw e;
        }
    }

    @GwtIncompatible
    public static String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)stringWriter));
        return stringWriter.toString();
    }

    @Beta
    @GwtIncompatible
    public static List<StackTraceElement> lazyStackTrace(Throwable throwable) {
        return Throwables.lazyStackTraceIsLazy() ? Throwables.jlaStackTrace(throwable) : Collections.unmodifiableList((List)Arrays.asList((io.logz.sender.java.lang.Object[])throwable.getStackTrace()));
    }

    @Beta
    @GwtIncompatible
    public static boolean lazyStackTraceIsLazy() {
        return getStackTraceElementMethod != null && getStackTraceDepthMethod != null;
    }

    @GwtIncompatible
    private static List<StackTraceElement> jlaStackTrace(final Throwable t) {
        Preconditions.checkNotNull(t);
        return new AbstractList<StackTraceElement>(){

            public StackTraceElement get(int n) {
                return (StackTraceElement)Throwables.invokeAccessibleNonThrowingMethod(getStackTraceElementMethod, jla, new io.logz.sender.java.lang.Object[]{t, Integer.valueOf((int)n)});
            }

            public int size() {
                return ((Integer)Throwables.invokeAccessibleNonThrowingMethod(getStackTraceDepthMethod, jla, new io.logz.sender.java.lang.Object[]{t})).intValue();
            }
        };
    }

    @GwtIncompatible
    private static io.logz.sender.java.lang.Object invokeAccessibleNonThrowingMethod(Method method, io.logz.sender.java.lang.Object receiver, io.logz.sender.java.lang.Object ... params) {
        try {
            return method.invoke(receiver, params);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
        catch (InvocationTargetException e) {
            throw Throwables.propagate(e.getCause());
        }
    }

    @NullableDecl
    @GwtIncompatible
    private static io.logz.sender.java.lang.Object getJLA() {
        try {
            Class sharedSecrets = Class.forName((String)"io.logz.sender.sun.misc.SharedSecrets", (boolean)false, null);
            Method langAccess = sharedSecrets.getMethod((String)"io.logz.sender.getJavaLangAccess", new Class[0]);
            return langAccess.invoke(null, new io.logz.sender.java.lang.Object[0]);
        }
        catch (ThreadDeath death) {
            throw death;
        }
        catch (Throwable t) {
            return null;
        }
    }

    @NullableDecl
    @GwtIncompatible
    private static Method getGetMethod() {
        return Throwables.getJlaMethod((String)"io.logz.sender.getStackTraceElement", new Class[]{Throwable.class, Integer.TYPE});
    }

    @NullableDecl
    @GwtIncompatible
    private static Method getSizeMethod() {
        try {
            Method getStackTraceDepth = Throwables.getJlaMethod((String)"io.logz.sender.getStackTraceDepth", new Class[]{Throwable.class});
            if (getStackTraceDepth == null) {
                return null;
            }
            getStackTraceDepth.invoke(Throwables.getJLA(), new io.logz.sender.java.lang.Object[]{new Throwable()});
            return getStackTraceDepth;
        }
        catch (IllegalAccessException | UnsupportedOperationException | InvocationTargetException e) {
            return null;
        }
    }

    @NullableDecl
    @GwtIncompatible
    private static Method getJlaMethod(String name, Class<?> ... parameterTypes) throws ThreadDeath {
        try {
            return Class.forName((String)"io.logz.sender.sun.misc.JavaLangAccess", (boolean)false, null).getMethod(name, parameterTypes);
        }
        catch (ThreadDeath death) {
            throw death;
        }
        catch (Throwable t) {
            return null;
        }
    }
}

