/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.GwtIncompatible;
import io.logz.sender.com.google.common.collect.Iterators;
import io.logz.sender.com.google.common.collect.Maps;
import io.logz.sender.java.util.Iterator;
import io.logz.sender.java.util.Map;
import io.logz.sender.java.util.NavigableMap;
import io.logz.sender.java.util.NavigableSet;
import io.logz.sender.java.util.NoSuchElementException;
import io.logz.sender.java.util.Set;
import io.logz.sender.java.util.SortedMap;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtIncompatible
abstract class AbstractNavigableMap<K extends io.logz.sender.java.lang.Object, V extends io.logz.sender.java.lang.Object>
extends Maps.IteratorBasedAbstractMap<K, V>
implements NavigableMap<K, V> {
    AbstractNavigableMap() {
    }

    @NullableDecl
    public abstract V get(@NullableDecl io.logz.sender.java.lang.Object var1);

    @NullableDecl
    public Map.Entry<K, V> firstEntry() {
        return Iterators.getNext(this.entryIterator(), null);
    }

    @NullableDecl
    public Map.Entry<K, V> lastEntry() {
        return Iterators.getNext(this.descendingEntryIterator(), null);
    }

    @NullableDecl
    public Map.Entry<K, V> pollFirstEntry() {
        return Iterators.pollNext(this.entryIterator());
    }

    @NullableDecl
    public Map.Entry<K, V> pollLastEntry() {
        return Iterators.pollNext(this.descendingEntryIterator());
    }

    public K firstKey() {
        Map.Entry<K, V> entry = this.firstEntry();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return (K)entry.getKey();
    }

    public K lastKey() {
        Map.Entry<K, V> entry = this.lastEntry();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return (K)entry.getKey();
    }

    @NullableDecl
    public Map.Entry<K, V> lowerEntry(K key) {
        return this.headMap((io.logz.sender.java.lang.Object)key, false).lastEntry();
    }

    @NullableDecl
    public Map.Entry<K, V> floorEntry(K key) {
        return this.headMap((io.logz.sender.java.lang.Object)key, true).lastEntry();
    }

    @NullableDecl
    public Map.Entry<K, V> ceilingEntry(K key) {
        return this.tailMap((io.logz.sender.java.lang.Object)key, true).firstEntry();
    }

    @NullableDecl
    public Map.Entry<K, V> higherEntry(K key) {
        return this.tailMap((io.logz.sender.java.lang.Object)key, false).firstEntry();
    }

    public K lowerKey(K key) {
        return Maps.keyOrNull(this.lowerEntry(key));
    }

    public K floorKey(K key) {
        return Maps.keyOrNull(this.floorEntry(key));
    }

    public K ceilingKey(K key) {
        return Maps.keyOrNull(this.ceilingEntry(key));
    }

    public K higherKey(K key) {
        return Maps.keyOrNull(this.higherEntry(key));
    }

    abstract Iterator<Map.Entry<K, V>> descendingEntryIterator();

    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap((io.logz.sender.java.lang.Object)fromKey, true, (io.logz.sender.java.lang.Object)toKey, false);
    }

    public SortedMap<K, V> headMap(K toKey) {
        return this.headMap((io.logz.sender.java.lang.Object)toKey, false);
    }

    public SortedMap<K, V> tailMap(K fromKey) {
        return this.tailMap((io.logz.sender.java.lang.Object)fromKey, true);
    }

    public NavigableSet<K> navigableKeySet() {
        return new Maps.NavigableKeySet(this);
    }

    public Set<K> keySet() {
        return this.navigableKeySet();
    }

    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    public NavigableMap<K, V> descendingMap() {
        return new DescendingMap();
    }

    private final class DescendingMap
    extends Maps.DescendingMap<K, V> {
        private DescendingMap() {
        }

        @Override
        NavigableMap<K, V> forward() {
            return AbstractNavigableMap.this;
        }

        @Override
        Iterator<Map.Entry<K, V>> entryIterator() {
            return AbstractNavigableMap.this.descendingEntryIterator();
        }
    }
}

