/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.logz.sender.java.lang.IllegalArgumentException;
import io.logz.sender.java.lang.NullPointerException;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;

@GwtCompatible
final class CollectPreconditions
extends io.logz.sender.java.lang.Object {
    CollectPreconditions() {
    }

    static void checkEntryNotNull(io.logz.sender.java.lang.Object key, io.logz.sender.java.lang.Object value) {
        if (key == null) {
            throw new NullPointerException(new StringBuilder().append((String)"io.logz.sender.null key in entry: null=").append(value).toString());
        }
        if (value == null) {
            throw new NullPointerException(new StringBuilder().append((String)"io.logz.sender.null value in entry: ").append(key).append((String)"io.logz.sender.=null").toString());
        }
    }

    @CanIgnoreReturnValue
    static int checkNonnegative(int value, String name) {
        if (value < 0) {
            throw new IllegalArgumentException(new StringBuilder().append(name).append((String)"io.logz.sender. cannot be negative but was: ").append(value).toString());
        }
        return value;
    }

    @CanIgnoreReturnValue
    static long checkNonnegative(long value, String name) {
        if (value < 0L) {
            throw new IllegalArgumentException(new StringBuilder().append(name).append((String)"io.logz.sender. cannot be negative but was: ").append(value).toString());
        }
        return value;
    }

    static void checkPositive(int value, String name) {
        if (value <= 0) {
            throw new IllegalArgumentException(new StringBuilder().append(name).append((String)"io.logz.sender. must be positive but was: ").append(value).toString());
        }
    }

    static void checkRemove(boolean canRemove) {
        Preconditions.checkState(canRemove, (io.logz.sender.java.lang.Object)"io.logz.sender.no calls to next() since the last call to remove()");
    }
}

