/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.GwtIncompatible;
import io.logz.sender.com.google.common.collect.ImmutableSortedSet;
import io.logz.sender.com.google.common.collect.Ordering;
import io.logz.sender.com.google.common.collect.UnmodifiableIterator;
import io.logz.sender.java.lang.AssertionError;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtIncompatible
final class DescendingImmutableSortedSet<E extends io.logz.sender.java.lang.Object>
extends ImmutableSortedSet<E> {
    private final ImmutableSortedSet<E> forward;

    DescendingImmutableSortedSet(ImmutableSortedSet<E> forward) {
        super(Ordering.from(forward.comparator()).reverse());
        this.forward = forward;
    }

    @Override
    public boolean contains(@NullableDecl io.logz.sender.java.lang.Object object) {
        return this.forward.contains(object);
    }

    public int size() {
        return this.forward.size();
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return this.forward.descendingIterator();
    }

    @Override
    ImmutableSortedSet<E> headSetImpl(E toElement, boolean inclusive) {
        return this.forward.tailSet((io.logz.sender.java.lang.Object)toElement, inclusive).descendingSet();
    }

    @Override
    ImmutableSortedSet<E> subSetImpl(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return this.forward.subSet((io.logz.sender.java.lang.Object)toElement, toInclusive, (io.logz.sender.java.lang.Object)fromElement, fromInclusive).descendingSet();
    }

    @Override
    ImmutableSortedSet<E> tailSetImpl(E fromElement, boolean inclusive) {
        return this.forward.headSet((io.logz.sender.java.lang.Object)fromElement, inclusive).descendingSet();
    }

    @Override
    @GwtIncompatible(value="io.logz.sender.NavigableSet")
    public ImmutableSortedSet<E> descendingSet() {
        return this.forward;
    }

    @Override
    @GwtIncompatible(value="io.logz.sender.NavigableSet")
    public UnmodifiableIterator<E> descendingIterator() {
        return this.forward.iterator();
    }

    @Override
    @GwtIncompatible(value="io.logz.sender.NavigableSet")
    ImmutableSortedSet<E> createDescendingSet() {
        throw new AssertionError((io.logz.sender.java.lang.Object)"io.logz.sender.should never be called");
    }

    @Override
    public E lower(E element) {
        return this.forward.higher(element);
    }

    @Override
    public E floor(E element) {
        return this.forward.ceiling(element);
    }

    @Override
    public E ceiling(E element) {
        return this.forward.floor(element);
    }

    @Override
    public E higher(E element) {
        return this.forward.lower(element);
    }

    @Override
    int indexOf(@NullableDecl io.logz.sender.java.lang.Object target) {
        int index = this.forward.indexOf(target);
        if (index == -1) {
            return index;
        }
        return this.size() - 1 - index;
    }

    @Override
    boolean isPartialView() {
        return this.forward.isPartialView();
    }
}

