/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.collect.CollectPreconditions;
import io.logz.sender.com.google.common.primitives.Ints;
import io.logz.sender.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.logz.sender.java.io.Serializable;
import io.logz.sender.java.lang.Comparable;
import io.logz.sender.java.lang.Integer;
import io.logz.sender.java.lang.Long;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.math.BigInteger;
import io.logz.sender.java.util.NoSuchElementException;

@GwtCompatible
public abstract class DiscreteDomain<C extends Comparable>
extends io.logz.sender.java.lang.Object {
    final boolean supportsFastOffset;

    public static DiscreteDomain<Integer> integers() {
        return IntegerDomain.INSTANCE;
    }

    public static DiscreteDomain<Long> longs() {
        return LongDomain.INSTANCE;
    }

    public static DiscreteDomain<BigInteger> bigIntegers() {
        return BigIntegerDomain.INSTANCE;
    }

    protected DiscreteDomain() {
        this(false);
    }

    private DiscreteDomain(boolean supportsFastOffset) {
        this.supportsFastOffset = supportsFastOffset;
    }

    C offset(C origin, long distance) {
        CollectPreconditions.checkNonnegative(distance, (String)"io.logz.sender.distance");
        for (long i = 0L; i < distance; ++i) {
            origin = this.next(origin);
        }
        return origin;
    }

    public abstract C next(C var1);

    public abstract C previous(C var1);

    public abstract long distance(C var1, C var2);

    @CanIgnoreReturnValue
    public C minValue() {
        throw new NoSuchElementException();
    }

    @CanIgnoreReturnValue
    public C maxValue() {
        throw new NoSuchElementException();
    }

    private static final class BigIntegerDomain
    extends DiscreteDomain<BigInteger>
    implements Serializable {
        private static final BigIntegerDomain INSTANCE = new BigIntegerDomain();
        private static final BigInteger MIN_LONG = BigInteger.valueOf((long)java.lang.Long.MIN_VALUE);
        private static final BigInteger MAX_LONG = BigInteger.valueOf((long)java.lang.Long.MAX_VALUE);
        private static final long serialVersionUID = 0L;

        BigIntegerDomain() {
            super(true);
        }

        @Override
        public BigInteger next(BigInteger value) {
            return value.add(BigInteger.ONE);
        }

        @Override
        public BigInteger previous(BigInteger value) {
            return value.subtract(BigInteger.ONE);
        }

        @Override
        BigInteger offset(BigInteger origin, long distance) {
            CollectPreconditions.checkNonnegative(distance, (String)"io.logz.sender.distance");
            return origin.add(BigInteger.valueOf((long)distance));
        }

        @Override
        public long distance(BigInteger start, BigInteger end) {
            return end.subtract(start).max(MIN_LONG).min(MAX_LONG).longValue();
        }

        private io.logz.sender.java.lang.Object readResolve() {
            return INSTANCE;
        }

        public String toString() {
            return "io.logz.sender.DiscreteDomain.bigIntegers()";
        }
    }

    private static final class LongDomain
    extends DiscreteDomain<Long>
    implements Serializable {
        private static final LongDomain INSTANCE = new LongDomain();
        private static final long serialVersionUID = 0L;

        LongDomain() {
            super(true);
        }

        @Override
        public Long next(Long value) {
            long l = value.longValue();
            return l == java.lang.Long.MAX_VALUE ? null : Long.valueOf((long)(l + 1L));
        }

        @Override
        public Long previous(Long value) {
            long l = value.longValue();
            return l == java.lang.Long.MIN_VALUE ? null : Long.valueOf((long)(l - 1L));
        }

        @Override
        Long offset(Long origin, long distance) {
            CollectPreconditions.checkNonnegative(distance, (String)"io.logz.sender.distance");
            long result = origin.longValue() + distance;
            if (result < 0L) {
                Preconditions.checkArgument(origin.longValue() < 0L, (io.logz.sender.java.lang.Object)"io.logz.sender.overflow");
            }
            return Long.valueOf((long)result);
        }

        @Override
        public long distance(Long start, Long end) {
            long result = end.longValue() - start.longValue();
            if (end.longValue() > start.longValue() && result < 0L) {
                return java.lang.Long.MAX_VALUE;
            }
            if (end.longValue() < start.longValue() && result > 0L) {
                return java.lang.Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public Long minValue() {
            return Long.valueOf((long)java.lang.Long.MIN_VALUE);
        }

        @Override
        public Long maxValue() {
            return Long.valueOf((long)java.lang.Long.MAX_VALUE);
        }

        private io.logz.sender.java.lang.Object readResolve() {
            return INSTANCE;
        }

        public String toString() {
            return "io.logz.sender.DiscreteDomain.longs()";
        }
    }

    private static final class IntegerDomain
    extends DiscreteDomain<Integer>
    implements Serializable {
        private static final IntegerDomain INSTANCE = new IntegerDomain();
        private static final long serialVersionUID = 0L;

        IntegerDomain() {
            super(true);
        }

        @Override
        public Integer next(Integer value) {
            int i = value.intValue();
            return i == java.lang.Integer.MAX_VALUE ? null : Integer.valueOf((int)(i + 1));
        }

        @Override
        public Integer previous(Integer value) {
            int i = value.intValue();
            return i == java.lang.Integer.MIN_VALUE ? null : Integer.valueOf((int)(i - 1));
        }

        @Override
        Integer offset(Integer origin, long distance) {
            CollectPreconditions.checkNonnegative(distance, (String)"io.logz.sender.distance");
            return Integer.valueOf((int)Ints.checkedCast(origin.longValue() + distance));
        }

        @Override
        public long distance(Integer start, Integer end) {
            return (long)end.intValue() - (long)start.intValue();
        }

        @Override
        public Integer minValue() {
            return Integer.valueOf((int)java.lang.Integer.MIN_VALUE);
        }

        @Override
        public Integer maxValue() {
            return Integer.valueOf((int)java.lang.Integer.MAX_VALUE);
        }

        private io.logz.sender.java.lang.Object readResolve() {
            return INSTANCE;
        }

        public String toString() {
            return "io.logz.sender.DiscreteDomain.integers()";
        }
    }
}

