/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.Beta;
import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.annotations.GwtIncompatible;
import io.logz.sender.com.google.common.base.Function;
import io.logz.sender.com.google.common.base.Joiner;
import io.logz.sender.com.google.common.base.Optional;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.base.Predicate;
import io.logz.sender.com.google.common.collect.AbstractIndexedListIterator;
import io.logz.sender.com.google.common.collect.Collections2;
import io.logz.sender.com.google.common.collect.ImmutableList;
import io.logz.sender.com.google.common.collect.ImmutableListMultimap;
import io.logz.sender.com.google.common.collect.ImmutableMap;
import io.logz.sender.com.google.common.collect.ImmutableMultiset;
import io.logz.sender.com.google.common.collect.ImmutableSet;
import io.logz.sender.com.google.common.collect.ImmutableSortedSet;
import io.logz.sender.com.google.common.collect.Iterables;
import io.logz.sender.com.google.common.collect.Iterators;
import io.logz.sender.com.google.common.collect.Lists;
import io.logz.sender.com.google.common.collect.Maps;
import io.logz.sender.com.google.common.collect.Multimaps;
import io.logz.sender.com.google.common.collect.Ordering;
import io.logz.sender.com.google.common.collect.Streams;
import io.logz.sender.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.logz.sender.java.lang.Class;
import io.logz.sender.java.lang.Deprecated;
import io.logz.sender.java.lang.Iterable;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.util.Arrays;
import io.logz.sender.java.util.Collection;
import io.logz.sender.java.util.Comparator;
import io.logz.sender.java.util.Iterator;
import io.logz.sender.java.util.List;
import io.logz.sender.java.util.SortedSet;
import io.logz.sender.java.util.stream.Stream;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible(emulated=true)
public abstract class FluentIterable<E extends io.logz.sender.java.lang.Object>
extends io.logz.sender.java.lang.Object
implements Iterable<E> {
    private final Optional<Iterable<E>> iterableDelegate;

    protected FluentIterable() {
        this.iterableDelegate = Optional.absent();
    }

    FluentIterable(Iterable<E> iterable) {
        Preconditions.checkNotNull(iterable);
        this.iterableDelegate = Optional.fromNullable(this != iterable ? iterable : null);
    }

    private Iterable<E> getDelegate() {
        return this.iterableDelegate.or(this);
    }

    public static <E extends io.logz.sender.java.lang.Object> FluentIterable<E> from(final Iterable<E> iterable) {
        return iterable instanceof FluentIterable ? (FluentIterable<E>)iterable : new FluentIterable<E>(iterable){

            public Iterator<E> iterator() {
                return iterable.iterator();
            }
        };
    }

    @Beta
    public static <E extends io.logz.sender.java.lang.Object> FluentIterable<E> from(E[] elements) {
        return FluentIterable.from(Arrays.asList(elements));
    }

    @Deprecated
    public static <E extends io.logz.sender.java.lang.Object> FluentIterable<E> from(FluentIterable<E> iterable) {
        return Preconditions.checkNotNull(iterable);
    }

    @Beta
    public static <T extends io.logz.sender.java.lang.Object> FluentIterable<T> concat(Iterable<? extends T> a, Iterable<? extends T> b) {
        return FluentIterable.concatNoDefensiveCopy(a, b);
    }

    @Beta
    public static <T extends io.logz.sender.java.lang.Object> FluentIterable<T> concat(Iterable<? extends T> a, Iterable<? extends T> b, Iterable<? extends T> c) {
        return FluentIterable.concatNoDefensiveCopy(a, b, c);
    }

    @Beta
    public static <T extends io.logz.sender.java.lang.Object> FluentIterable<T> concat(Iterable<? extends T> a, Iterable<? extends T> b, Iterable<? extends T> c, Iterable<? extends T> d) {
        return FluentIterable.concatNoDefensiveCopy(a, b, c, d);
    }

    @Beta
    public static <T extends io.logz.sender.java.lang.Object> FluentIterable<T> concat(Iterable<? extends T> ... inputs) {
        return FluentIterable.concatNoDefensiveCopy((Iterable[])Arrays.copyOf(inputs, (int)inputs.length));
    }

    @Beta
    public static <T extends io.logz.sender.java.lang.Object> FluentIterable<T> concat(Iterable<? extends Iterable<? extends T>> inputs) {
        Preconditions.checkNotNull(inputs);
        return new FluentIterable<T>((Iterable)inputs){
            final /* synthetic */ Iterable val$inputs;
            {
                this.val$inputs = iterable;
            }

            public Iterator<T> iterator() {
                return Iterators.concat(Iterators.transform(this.val$inputs.iterator(), Iterables.toIterator()));
            }
        };
    }

    private static <T extends io.logz.sender.java.lang.Object> FluentIterable<T> concatNoDefensiveCopy(final Iterable<? extends T> ... inputs) {
        for (Iterable<? extends T> input : inputs) {
            Preconditions.checkNotNull(input);
        }
        return new FluentIterable<T>(){

            public Iterator<T> iterator() {
                return Iterators.concat(new AbstractIndexedListIterator<Iterator<? extends T>>(inputs.length){

                    @Override
                    public Iterator<? extends T> get(int i) {
                        return inputs[i].iterator();
                    }
                });
            }
        };
    }

    @Beta
    public static <E extends io.logz.sender.java.lang.Object> FluentIterable<E> of() {
        return FluentIterable.from(ImmutableList.of());
    }

    @Beta
    public static <E extends io.logz.sender.java.lang.Object> FluentIterable<E> of(@NullableDecl E element, E ... elements) {
        return FluentIterable.from(Lists.asList(element, elements));
    }

    public String toString() {
        return Iterables.toString(this.getDelegate());
    }

    public final int size() {
        return Iterables.size(this.getDelegate());
    }

    public final boolean contains(@NullableDecl io.logz.sender.java.lang.Object target) {
        return Iterables.contains(this.getDelegate(), target);
    }

    public final FluentIterable<E> cycle() {
        return FluentIterable.from(Iterables.cycle(this.getDelegate()));
    }

    @Beta
    public final FluentIterable<E> append(Iterable<? extends E> other) {
        return FluentIterable.concat(this.getDelegate(), other);
    }

    @Beta
    public final FluentIterable<E> append(E ... elements) {
        return FluentIterable.concat(this.getDelegate(), Arrays.asList(elements));
    }

    public final FluentIterable<E> filter(Predicate<? super E> predicate) {
        return FluentIterable.from(Iterables.filter(this.getDelegate(), predicate));
    }

    @GwtIncompatible
    public final <T extends io.logz.sender.java.lang.Object> FluentIterable<T> filter(Class<T> type) {
        return FluentIterable.from(Iterables.filter(this.getDelegate(), type));
    }

    public final boolean anyMatch(Predicate<? super E> predicate) {
        return Iterables.any(this.getDelegate(), predicate);
    }

    public final boolean allMatch(Predicate<? super E> predicate) {
        return Iterables.all(this.getDelegate(), predicate);
    }

    public final Optional<E> firstMatch(Predicate<? super E> predicate) {
        return Iterables.tryFind(this.getDelegate(), predicate);
    }

    public final <T extends io.logz.sender.java.lang.Object> FluentIterable<T> transform(Function<? super E, T> function) {
        return FluentIterable.from(Iterables.transform(this.getDelegate(), function));
    }

    public <T extends io.logz.sender.java.lang.Object> FluentIterable<T> transformAndConcat(Function<? super E, ? extends Iterable<? extends T>> function) {
        return FluentIterable.concat(this.transform(function));
    }

    public final Optional<E> first() {
        Iterator iterator = this.getDelegate().iterator();
        return iterator.hasNext() ? Optional.of(iterator.next()) : Optional.absent();
    }

    public final Optional<E> last() {
        io.logz.sender.java.lang.Object current;
        Iterable<E> iterable = this.getDelegate();
        if (iterable instanceof List) {
            List list = (List)iterable;
            if (list.isEmpty()) {
                return Optional.absent();
            }
            return Optional.of(list.get(list.size() - 1));
        }
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return Optional.absent();
        }
        if (iterable instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)iterable;
            return Optional.of(sortedSet.last());
        }
        do {
            current = iterator.next();
        } while (iterator.hasNext());
        return Optional.of(current);
    }

    public final FluentIterable<E> skip(int numberToSkip) {
        return FluentIterable.from(Iterables.skip(this.getDelegate(), numberToSkip));
    }

    public final FluentIterable<E> limit(int maxSize) {
        return FluentIterable.from(Iterables.limit(this.getDelegate(), maxSize));
    }

    public final boolean isEmpty() {
        return !this.getDelegate().iterator().hasNext();
    }

    public final ImmutableList<E> toList() {
        return ImmutableList.copyOf(this.getDelegate());
    }

    public final ImmutableList<E> toSortedList(Comparator<? super E> comparator) {
        return Ordering.from(comparator).immutableSortedCopy(this.getDelegate());
    }

    public final ImmutableSet<E> toSet() {
        return ImmutableSet.copyOf(this.getDelegate());
    }

    public final ImmutableSortedSet<E> toSortedSet(Comparator<? super E> comparator) {
        return ImmutableSortedSet.copyOf(comparator, this.getDelegate());
    }

    public final ImmutableMultiset<E> toMultiset() {
        return ImmutableMultiset.copyOf(this.getDelegate());
    }

    public final <V extends io.logz.sender.java.lang.Object> ImmutableMap<E, V> toMap(Function<? super E, V> valueFunction) {
        return Maps.toMap(this.getDelegate(), valueFunction);
    }

    public final <K extends io.logz.sender.java.lang.Object> ImmutableListMultimap<K, E> index(Function<? super E, K> keyFunction) {
        return Multimaps.index(this.getDelegate(), keyFunction);
    }

    public final <K extends io.logz.sender.java.lang.Object> ImmutableMap<K, E> uniqueIndex(Function<? super E, K> keyFunction) {
        return Maps.uniqueIndex(this.getDelegate(), keyFunction);
    }

    @GwtIncompatible
    public final E[] toArray(Class<E> type) {
        return Iterables.toArray(this.getDelegate(), type);
    }

    @CanIgnoreReturnValue
    public final <C extends Collection<? super E>> C copyInto(C collection) {
        Preconditions.checkNotNull(collection);
        Iterable<E> iterable = this.getDelegate();
        if (iterable instanceof Collection) {
            collection.addAll(Collections2.cast(iterable));
        } else {
            for (io.logz.sender.java.lang.Object item : iterable) {
                collection.add(item);
            }
        }
        return collection;
    }

    @Beta
    public final String join(Joiner joiner) {
        return joiner.join(this);
    }

    public final E get(int position) {
        return Iterables.get(this.getDelegate(), position);
    }

    public final Stream<E> stream() {
        return Streams.stream(this.getDelegate());
    }

    private static class FromIterableFunction<E extends io.logz.sender.java.lang.Object>
    extends io.logz.sender.java.lang.Object
    implements Function<Iterable<E>, FluentIterable<E>> {
        private FromIterableFunction() {
        }

        @Override
        public FluentIterable<E> apply(Iterable<E> fromObject) {
            return FluentIterable.from(fromObject);
        }
    }
}

