/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.Beta;
import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.collect.ForwardingMap;
import io.logz.sender.com.google.common.collect.Maps;
import io.logz.sender.java.lang.ClassCastException;
import io.logz.sender.java.lang.Comparable;
import io.logz.sender.java.lang.NullPointerException;
import io.logz.sender.java.util.Comparator;
import io.logz.sender.java.util.NoSuchElementException;
import io.logz.sender.java.util.SortedMap;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible
public abstract class ForwardingSortedMap<K extends io.logz.sender.java.lang.Object, V extends io.logz.sender.java.lang.Object>
extends ForwardingMap<K, V>
implements SortedMap<K, V> {
    protected ForwardingSortedMap() {
    }

    @Override
    protected abstract SortedMap<K, V> delegate();

    public Comparator<? super K> comparator() {
        return this.delegate().comparator();
    }

    public K firstKey() {
        return (K)this.delegate().firstKey();
    }

    public SortedMap<K, V> headMap(K toKey) {
        return this.delegate().headMap(toKey);
    }

    public K lastKey() {
        return (K)this.delegate().lastKey();
    }

    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        return this.delegate().subMap(fromKey, toKey);
    }

    public SortedMap<K, V> tailMap(K fromKey) {
        return this.delegate().tailMap(fromKey);
    }

    private int unsafeCompare(io.logz.sender.java.lang.Object k1, io.logz.sender.java.lang.Object k2) {
        Comparator<K> comparator = this.comparator();
        if (comparator == null) {
            return ((Comparable)k1).compareTo(k2);
        }
        return comparator.compare(k1, k2);
    }

    @Override
    @Beta
    protected boolean standardContainsKey(@NullableDecl io.logz.sender.java.lang.Object key) {
        try {
            ForwardingSortedMap self = this;
            io.logz.sender.java.lang.Object ceilingKey = self.tailMap(key).firstKey();
            return this.unsafeCompare(ceilingKey, key) == 0;
        }
        catch (ClassCastException | NullPointerException | NoSuchElementException e) {
            return false;
        }
    }

    @Beta
    protected SortedMap<K, V> standardSubMap(K fromKey, K toKey) {
        Preconditions.checkArgument(this.unsafeCompare((io.logz.sender.java.lang.Object)fromKey, (io.logz.sender.java.lang.Object)toKey) <= 0, (io.logz.sender.java.lang.Object)"io.logz.sender.fromKey must be <= toKey");
        return this.tailMap(fromKey).headMap(toKey);
    }

    @Beta
    protected class StandardKeySet
    extends Maps.SortedKeySet<K, V> {
        public StandardKeySet() {
            super(ForwardingSortedMap.this);
        }
    }
}

