/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.annotations.GwtIncompatible;
import io.logz.sender.com.google.common.collect.AbstractMapBasedMultiset;
import io.logz.sender.com.google.common.collect.Iterables;
import io.logz.sender.com.google.common.collect.Maps;
import io.logz.sender.com.google.common.collect.Multisets;
import io.logz.sender.com.google.common.collect.Serialization;
import io.logz.sender.java.io.IOException;
import io.logz.sender.java.io.ObjectInputStream;
import io.logz.sender.java.io.ObjectOutputStream;
import io.logz.sender.java.lang.ClassNotFoundException;
import io.logz.sender.java.lang.Iterable;
import io.logz.sender.java.util.HashMap;

@GwtCompatible(serializable=true, emulated=true)
public final class HashMultiset<E extends io.logz.sender.java.lang.Object>
extends AbstractMapBasedMultiset<E> {
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    public static <E extends io.logz.sender.java.lang.Object> HashMultiset<E> create() {
        return new HashMultiset<E>();
    }

    public static <E extends io.logz.sender.java.lang.Object> HashMultiset<E> create(int distinctElements) {
        return new HashMultiset<E>(distinctElements);
    }

    public static <E extends io.logz.sender.java.lang.Object> HashMultiset<E> create(Iterable<? extends E> elements) {
        HashMultiset<E> multiset = HashMultiset.create(Multisets.inferDistinctElements(elements));
        Iterables.addAll(multiset, elements);
        return multiset;
    }

    private HashMultiset() {
        super(new HashMap());
    }

    private HashMultiset(int distinctElements) {
        super(Maps.newHashMapWithExpectedSize(distinctElements));
    }

    @GwtIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        Serialization.writeMultiset(this, stream);
    }

    @GwtIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int distinctElements = Serialization.readCount(stream);
        this.setBackingMap(Maps.newHashMap());
        Serialization.populateMultiset(this, stream, distinctElements);
    }
}

