/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.collect.ImmutableList;
import io.logz.sender.com.google.common.collect.ImmutableMultiset;
import io.logz.sender.com.google.common.collect.ImmutableSet;
import io.logz.sender.com.google.common.collect.Maps;
import io.logz.sender.com.google.common.collect.Multiset;
import io.logz.sender.com.google.common.collect.Multisets;
import io.logz.sender.com.google.common.primitives.Ints;
import io.logz.sender.java.lang.Integer;
import io.logz.sender.java.util.Collection;
import io.logz.sender.java.util.HashMap;
import io.logz.sender.java.util.Map;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible
final class JdkBackedImmutableMultiset<E extends io.logz.sender.java.lang.Object>
extends ImmutableMultiset<E> {
    private final Map<E, Integer> delegateMap;
    private final ImmutableList<Multiset.Entry<E>> entries;
    private final long size;
    private transient ImmutableSet<E> elementSet;

    static <E extends io.logz.sender.java.lang.Object> ImmutableMultiset<E> create(Collection<? extends Multiset.Entry<? extends E>> entries) {
        io.logz.sender.java.lang.Object[] entriesArray = (Multiset.Entry[])entries.toArray((io.logz.sender.java.lang.Object[])new Multiset.Entry[0]);
        HashMap delegateMap = Maps.newHashMapWithExpectedSize(entriesArray.length);
        long size = 0L;
        for (int i = 0; i < entriesArray.length; ++i) {
            Multiset.Entry entry = entriesArray[i];
            int count = entry.getCount();
            size += (long)count;
            Object element = Preconditions.checkNotNull(entry.getElement());
            delegateMap.put(element, (io.logz.sender.java.lang.Object)Integer.valueOf((int)count));
            if (entry instanceof Multisets.ImmutableEntry) continue;
            entriesArray[i] = Multisets.immutableEntry(element, count);
        }
        return new JdkBackedImmutableMultiset(delegateMap, ImmutableList.asImmutableList(entriesArray), size);
    }

    private JdkBackedImmutableMultiset(Map<E, Integer> delegateMap, ImmutableList<Multiset.Entry<E>> entries, long size) {
        this.delegateMap = delegateMap;
        this.entries = entries;
        this.size = size;
    }

    @Override
    public int count(@NullableDecl io.logz.sender.java.lang.Object element) {
        return ((Integer)this.delegateMap.getOrDefault(element, (io.logz.sender.java.lang.Object)Integer.valueOf((int)0))).intValue();
    }

    @Override
    public ImmutableSet<E> elementSet() {
        ImmutableSet<E> result = this.elementSet;
        return result == null ? (this.elementSet = new ImmutableMultiset.ElementSet<E>(this.entries, this)) : result;
    }

    @Override
    Multiset.Entry<E> getEntry(int index) {
        return (Multiset.Entry)this.entries.get(index);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int size() {
        return Ints.saturatedCast(this.size);
    }
}

