/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.annotations.VisibleForTesting;
import io.logz.sender.com.google.common.base.Function;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.collect.AllEqualOrdering;
import io.logz.sender.com.google.common.collect.ByFunctionOrdering;
import io.logz.sender.com.google.common.collect.CollectPreconditions;
import io.logz.sender.com.google.common.collect.ComparatorOrdering;
import io.logz.sender.com.google.common.collect.CompoundOrdering;
import io.logz.sender.com.google.common.collect.ExplicitOrdering;
import io.logz.sender.com.google.common.collect.ImmutableList;
import io.logz.sender.com.google.common.collect.Iterables;
import io.logz.sender.com.google.common.collect.LexicographicalOrdering;
import io.logz.sender.com.google.common.collect.Lists;
import io.logz.sender.com.google.common.collect.MapMaker;
import io.logz.sender.com.google.common.collect.Maps;
import io.logz.sender.com.google.common.collect.NaturalOrdering;
import io.logz.sender.com.google.common.collect.NullsFirstOrdering;
import io.logz.sender.com.google.common.collect.NullsLastOrdering;
import io.logz.sender.com.google.common.collect.Platform;
import io.logz.sender.com.google.common.collect.ReverseOrdering;
import io.logz.sender.com.google.common.collect.TopKSelector;
import io.logz.sender.com.google.common.collect.UsingToStringOrdering;
import io.logz.sender.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.logz.sender.java.lang.AssertionError;
import io.logz.sender.java.lang.ClassCastException;
import io.logz.sender.java.lang.Comparable;
import io.logz.sender.java.lang.Deprecated;
import io.logz.sender.java.lang.Integer;
import io.logz.sender.java.lang.Iterable;
import io.logz.sender.java.lang.Object;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.lang.System;
import io.logz.sender.java.util.ArrayList;
import io.logz.sender.java.util.Arrays;
import io.logz.sender.java.util.Collection;
import io.logz.sender.java.util.Collections;
import io.logz.sender.java.util.Comparator;
import io.logz.sender.java.util.Iterator;
import io.logz.sender.java.util.List;
import io.logz.sender.java.util.Map;
import io.logz.sender.java.util.concurrent.ConcurrentMap;
import io.logz.sender.java.util.concurrent.atomic.AtomicInteger;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible
public abstract class Ordering<T extends Object>
extends Object
implements Comparator<T> {
    static final int LEFT_IS_GREATER = 1;
    static final int RIGHT_IS_GREATER = -1;

    @GwtCompatible(serializable=true)
    public static <C extends Comparable> Ordering<C> natural() {
        return NaturalOrdering.INSTANCE;
    }

    @GwtCompatible(serializable=true)
    public static <T extends Object> Ordering<T> from(Comparator<T> comparator) {
        return comparator instanceof Ordering ? (Ordering<T>)comparator : new ComparatorOrdering<T>(comparator);
    }

    @Deprecated
    @GwtCompatible(serializable=true)
    public static <T extends Object> Ordering<T> from(Ordering<T> ordering) {
        return Preconditions.checkNotNull(ordering);
    }

    @GwtCompatible(serializable=true)
    public static <T extends Object> Ordering<T> explicit(List<T> valuesInOrder) {
        return new ExplicitOrdering<T>(valuesInOrder);
    }

    @GwtCompatible(serializable=true)
    public static <T extends Object> Ordering<T> explicit(T leastValue, T ... remainingValuesInOrder) {
        return Ordering.explicit(Lists.asList(leastValue, remainingValuesInOrder));
    }

    @GwtCompatible(serializable=true)
    public static Ordering<Object> allEqual() {
        return AllEqualOrdering.INSTANCE;
    }

    @GwtCompatible(serializable=true)
    public static Ordering<Object> usingToString() {
        return UsingToStringOrdering.INSTANCE;
    }

    public static Ordering<Object> arbitrary() {
        return ArbitraryOrderingHolder.ARBITRARY_ORDERING;
    }

    protected Ordering() {
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<S> reverse() {
        return new ReverseOrdering(this);
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<S> nullsFirst() {
        return new NullsFirstOrdering(this);
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<S> nullsLast() {
        return new NullsLastOrdering(this);
    }

    @GwtCompatible(serializable=true)
    public <F extends Object> Ordering<F> onResultOf(Function<F, ? extends T> function) {
        return new ByFunctionOrdering<F, T>(function, this);
    }

    <T2 extends T> Ordering<Map.Entry<T2, ?>> onKeys() {
        return this.onResultOf(Maps.keyFunction());
    }

    @GwtCompatible(serializable=true)
    public <U extends T> Ordering<U> compound(Comparator<? super U> secondaryComparator) {
        return new CompoundOrdering<U>(this, Preconditions.checkNotNull(secondaryComparator));
    }

    @GwtCompatible(serializable=true)
    public static <T extends Object> Ordering<T> compound(Iterable<? extends Comparator<? super T>> comparators) {
        return new CompoundOrdering(comparators);
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<Iterable<S>> lexicographical() {
        return new LexicographicalOrdering(this);
    }

    @CanIgnoreReturnValue
    public abstract int compare(@NullableDecl T var1, @NullableDecl T var2);

    @CanIgnoreReturnValue
    public <E extends T> E min(Iterator<E> iterator) {
        Object minSoFar = iterator.next();
        while (iterator.hasNext()) {
            minSoFar = this.min(minSoFar, iterator.next());
        }
        return (E)minSoFar;
    }

    @CanIgnoreReturnValue
    public <E extends T> E min(Iterable<E> iterable) {
        return this.min(iterable.iterator());
    }

    @CanIgnoreReturnValue
    public <E extends T> E min(@NullableDecl E a, @NullableDecl E b) {
        return this.compare(a, b) <= 0 ? a : b;
    }

    @CanIgnoreReturnValue
    public <E extends T> E min(@NullableDecl E a, @NullableDecl E b, @NullableDecl E c, E ... rest) {
        E minSoFar = this.min(this.min(a, b), c);
        for (E r : rest) {
            minSoFar = this.min(minSoFar, r);
        }
        return minSoFar;
    }

    @CanIgnoreReturnValue
    public <E extends T> E max(Iterator<E> iterator) {
        Object maxSoFar = iterator.next();
        while (iterator.hasNext()) {
            maxSoFar = this.max(maxSoFar, iterator.next());
        }
        return (E)maxSoFar;
    }

    @CanIgnoreReturnValue
    public <E extends T> E max(Iterable<E> iterable) {
        return this.max(iterable.iterator());
    }

    @CanIgnoreReturnValue
    public <E extends T> E max(@NullableDecl E a, @NullableDecl E b) {
        return this.compare(a, b) >= 0 ? a : b;
    }

    @CanIgnoreReturnValue
    public <E extends T> E max(@NullableDecl E a, @NullableDecl E b, @NullableDecl E c, E ... rest) {
        E maxSoFar = this.max(this.max(a, b), c);
        for (E r : rest) {
            maxSoFar = this.max(maxSoFar, r);
        }
        return maxSoFar;
    }

    public <E extends T> List<E> leastOf(Iterable<E> iterable, int k) {
        Collection collection;
        if (iterable instanceof Collection && (long)(collection = (Collection)iterable).size() <= 2L * (long)k) {
            Object[] array = collection.toArray();
            Arrays.sort((Object[])array, (Comparator)this);
            if (array.length > k) {
                array = Arrays.copyOf((Object[])array, (int)k);
            }
            return Collections.unmodifiableList((List)Arrays.asList((Object[])array));
        }
        return this.leastOf(iterable.iterator(), k);
    }

    public <E extends T> List<E> leastOf(Iterator<E> iterator, int k) {
        Preconditions.checkNotNull(iterator);
        CollectPreconditions.checkNonnegative(k, (String)"io.logz.sender.k");
        if (k == 0 || !iterator.hasNext()) {
            return Collections.emptyList();
        }
        if (k >= 0x3FFFFFFF) {
            ArrayList<E> list = Lists.newArrayList(iterator);
            Collections.sort(list, (Comparator)this);
            if (list.size() > k) {
                list.subList(k, list.size()).clear();
            }
            list.trimToSize();
            return Collections.unmodifiableList(list);
        }
        TopKSelector<E> selector = TopKSelector.least(k, this);
        selector.offerAll(iterator);
        return selector.topK();
    }

    public <E extends T> List<E> greatestOf(Iterable<E> iterable, int k) {
        return this.reverse().leastOf(iterable, k);
    }

    public <E extends T> List<E> greatestOf(Iterator<E> iterator, int k) {
        return this.reverse().leastOf(iterator, k);
    }

    @CanIgnoreReturnValue
    public <E extends T> List<E> sortedCopy(Iterable<E> elements) {
        Object[] array = Iterables.toArray(elements);
        Arrays.sort((Object[])array, (Comparator)this);
        return Lists.newArrayList(Arrays.asList((Object[])array));
    }

    @CanIgnoreReturnValue
    public <E extends T> ImmutableList<E> immutableSortedCopy(Iterable<E> elements) {
        return ImmutableList.sortedCopyOf(this, elements);
    }

    public boolean isOrdered(Iterable<? extends T> iterable) {
        Iterator it = iterable.iterator();
        if (it.hasNext()) {
            Object prev = it.next();
            while (it.hasNext()) {
                Object next = it.next();
                if (this.compare(prev, next) > 0) {
                    return false;
                }
                prev = next;
            }
        }
        return true;
    }

    public boolean isStrictlyOrdered(Iterable<? extends T> iterable) {
        Iterator it = iterable.iterator();
        if (it.hasNext()) {
            Object prev = it.next();
            while (it.hasNext()) {
                Object next = it.next();
                if (this.compare(prev, next) >= 0) {
                    return false;
                }
                prev = next;
            }
        }
        return true;
    }

    @Deprecated
    public int binarySearch(List<? extends T> sortedList, @NullableDecl T key) {
        return Collections.binarySearch(sortedList, key, (Comparator)this);
    }

    @VisibleForTesting
    static class IncomparableValueException
    extends ClassCastException {
        final Object value;
        private static final long serialVersionUID = 0L;

        IncomparableValueException(Object value) {
            super(new StringBuilder().append((String)"io.logz.sender.Cannot compare value: ").append(value).toString());
            this.value = value;
        }
    }

    @VisibleForTesting
    static class ArbitraryOrdering
    extends Ordering<Object> {
        private final AtomicInteger counter = new AtomicInteger(0);
        private final ConcurrentMap<Object, Integer> uids = Platform.tryWeakKeys(new MapMaker()).makeMap();

        ArbitraryOrdering() {
        }

        private Integer getUid(Object obj) {
            Integer alreadySet;
            Integer uid = (Integer)this.uids.get(obj);
            if (uid == null && (alreadySet = (Integer)this.uids.putIfAbsent(obj, (Object)(uid = Integer.valueOf((int)this.counter.getAndIncrement())))) != null) {
                uid = alreadySet;
            }
            return uid;
        }

        @Override
        public int compare(Object left, Object right) {
            int rightCode;
            if (left == right) {
                return 0;
            }
            if (left == null) {
                return -1;
            }
            if (right == null) {
                return 1;
            }
            int leftCode = this.identityHashCode(left);
            if (leftCode != (rightCode = this.identityHashCode(right))) {
                return leftCode < rightCode ? -1 : 1;
            }
            int result = this.getUid(left).compareTo(this.getUid(right));
            if (result == 0) {
                throw new AssertionError();
            }
            return result;
        }

        public String toString() {
            return "io.logz.sender.Ordering.arbitrary()";
        }

        int identityHashCode(Object object) {
            return System.identityHashCode((Object)object);
        }
    }

    private static class ArbitraryOrderingHolder
    extends Object {
        static final Ordering<Object> ARBITRARY_ORDERING = new ArbitraryOrdering();

        private ArbitraryOrderingHolder() {
        }
    }
}

