/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.Beta;
import io.logz.sender.com.google.common.annotations.GwtIncompatible;
import io.logz.sender.com.google.common.collect.Range;
import io.logz.sender.java.lang.Comparable;
import io.logz.sender.java.lang.Iterable;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.util.Set;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@Beta
@GwtIncompatible
public interface RangeSet<C extends Comparable> {
    public boolean contains(C var1);

    public Range<C> rangeContaining(C var1);

    public boolean intersects(Range<C> var1);

    public boolean encloses(Range<C> var1);

    public boolean enclosesAll(RangeSet<C> var1);

    default public boolean enclosesAll(Iterable<Range<C>> other) {
        for (Range range : other) {
            if (this.encloses(range)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty();

    public Range<C> span();

    public Set<Range<C>> asRanges();

    public Set<Range<C>> asDescendingSetOfRanges();

    public RangeSet<C> complement();

    public RangeSet<C> subRangeSet(Range<C> var1);

    public void add(Range<C> var1);

    public void remove(Range<C> var1);

    public void clear();

    public void addAll(RangeSet<C> var1);

    default public void addAll(Iterable<Range<C>> ranges) {
        for (Range range : ranges) {
            this.add(range);
        }
    }

    public void removeAll(RangeSet<C> var1);

    default public void removeAll(Iterable<Range<C>> ranges) {
        for (Range range : ranges) {
            this.remove(range);
        }
    }

    public boolean equals(@NullableDecl io.logz.sender.java.lang.Object var1);

    public int hashCode();

    public String toString();
}

