/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.annotations.VisibleForTesting;
import io.logz.sender.com.google.common.collect.Hashing;
import io.logz.sender.com.google.common.collect.ImmutableList;
import io.logz.sender.com.google.common.collect.ImmutableSet;
import io.logz.sender.com.google.common.collect.Iterators;
import io.logz.sender.com.google.common.collect.RegularImmutableAsList;
import io.logz.sender.com.google.common.collect.UnmodifiableIterator;
import io.logz.sender.java.lang.System;
import io.logz.sender.java.util.Spliterator;
import io.logz.sender.java.util.Spliterators;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableSet<E extends io.logz.sender.java.lang.Object>
extends ImmutableSet<E> {
    static final RegularImmutableSet<io.logz.sender.java.lang.Object> EMPTY = new RegularImmutableSet(new io.logz.sender.java.lang.Object[0], 0, null, 0);
    private final transient io.logz.sender.java.lang.Object[] elements;
    @VisibleForTesting
    final transient io.logz.sender.java.lang.Object[] table;
    private final transient int mask;
    private final transient int hashCode;

    RegularImmutableSet(io.logz.sender.java.lang.Object[] elements, int hashCode, io.logz.sender.java.lang.Object[] table, int mask) {
        this.elements = elements;
        this.table = table;
        this.mask = mask;
        this.hashCode = hashCode;
    }

    @Override
    public boolean contains(@NullableDecl io.logz.sender.java.lang.Object target) {
        io.logz.sender.java.lang.Object[] table = this.table;
        if (target == null || table == null) {
            return false;
        }
        int i = Hashing.smearedHash(target);
        io.logz.sender.java.lang.Object candidate;
        while ((candidate = table[i &= this.mask]) != null) {
            if (candidate.equals(target)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int size() {
        return this.elements.length;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.forArray((io.logz.sender.java.lang.Object[])this.elements);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator((io.logz.sender.java.lang.Object[])this.elements, (int)1297);
    }

    @Override
    int copyIntoArray(io.logz.sender.java.lang.Object[] dst, int offset) {
        System.arraycopy((io.logz.sender.java.lang.Object)this.elements, (int)0, (io.logz.sender.java.lang.Object)dst, (int)offset, (int)this.elements.length);
        return offset + this.elements.length;
    }

    @Override
    ImmutableList<E> createAsList() {
        return this.table == null ? ImmutableList.of() : new RegularImmutableAsList(this, this.elements);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    boolean isHashCodeFast() {
        return true;
    }
}

