/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.annotations.GwtIncompatible;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.collect.ImmutableList;
import io.logz.sender.com.google.common.collect.ImmutableSortedAsList;
import io.logz.sender.com.google.common.collect.ImmutableSortedSet;
import io.logz.sender.com.google.common.collect.Multiset;
import io.logz.sender.com.google.common.collect.Ordering;
import io.logz.sender.com.google.common.collect.SortedIterables;
import io.logz.sender.com.google.common.collect.UnmodifiableIterator;
import io.logz.sender.java.lang.ClassCastException;
import io.logz.sender.java.lang.Comparable;
import io.logz.sender.java.lang.NullPointerException;
import io.logz.sender.java.util.Collection;
import io.logz.sender.java.util.Collections;
import io.logz.sender.java.util.Comparator;
import io.logz.sender.java.util.Iterator;
import io.logz.sender.java.util.NoSuchElementException;
import io.logz.sender.java.util.Set;
import io.logz.sender.java.util.Spliterator;
import io.logz.sender.java.util.function.Consumer;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableSortedSet<E extends io.logz.sender.java.lang.Object>
extends ImmutableSortedSet<E> {
    static final RegularImmutableSortedSet<Comparable> NATURAL_EMPTY_SET = new RegularImmutableSortedSet(ImmutableList.of(), Ordering.natural());
    private final transient ImmutableList<E> elements;

    RegularImmutableSortedSet(ImmutableList<E> elements, Comparator<? super E> comparator) {
        super(comparator);
        this.elements = elements;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return this.elements.iterator();
    }

    @Override
    @GwtIncompatible
    public UnmodifiableIterator<E> descendingIterator() {
        return this.elements.reverse().iterator();
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.asList().spliterator();
    }

    public void forEach(Consumer<? super E> action) {
        this.elements.forEach(action);
    }

    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean contains(@NullableDecl io.logz.sender.java.lang.Object o) {
        try {
            return o != null && this.unsafeBinarySearch(o) >= 0;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean containsAll(Collection<?> targets) {
        if (targets instanceof Multiset) {
            targets = ((Multiset)targets).elementSet();
        }
        if (!SortedIterables.hasSameComparator(this.comparator(), targets) || targets.size() <= 1) {
            return super.containsAll(targets);
        }
        Iterator thisIterator = this.iterator();
        Iterator thatIterator = targets.iterator();
        if (!thisIterator.hasNext()) {
            return false;
        }
        io.logz.sender.java.lang.Object target = thatIterator.next();
        io.logz.sender.java.lang.Object current = thisIterator.next();
        try {
            while (true) {
                int cmp;
                if ((cmp = this.unsafeCompare(current, target)) < 0) {
                    if (!thisIterator.hasNext()) {
                        return false;
                    }
                    current = thisIterator.next();
                    continue;
                }
                if (cmp == 0) {
                    if (!thatIterator.hasNext()) {
                        return true;
                    }
                    target = thatIterator.next();
                    continue;
                }
                if (cmp > 0) break;
            }
            return false;
        }
        catch (ClassCastException | NullPointerException e) {
            return false;
        }
    }

    private int unsafeBinarySearch(io.logz.sender.java.lang.Object key) throws ClassCastException {
        return Collections.binarySearch(this.elements, (io.logz.sender.java.lang.Object)key, this.unsafeComparator());
    }

    @Override
    boolean isPartialView() {
        return this.elements.isPartialView();
    }

    @Override
    int copyIntoArray(io.logz.sender.java.lang.Object[] dst, int offset) {
        return this.elements.copyIntoArray(dst, offset);
    }

    @Override
    public boolean equals(@NullableDecl io.logz.sender.java.lang.Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set that = (Set)object;
        if (this.size() != that.size()) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        if (SortedIterables.hasSameComparator(this.comparator, that)) {
            Iterator otherIterator = that.iterator();
            try {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    io.logz.sender.java.lang.Object element = iterator.next();
                    io.logz.sender.java.lang.Object otherElement = otherIterator.next();
                    if (otherElement != null && this.unsafeCompare(element, otherElement) == 0) continue;
                    return false;
                }
                return true;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NoSuchElementException e) {
                return false;
            }
        }
        return this.containsAll((Collection<?>)that);
    }

    @Override
    public E first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (E)this.elements.get(0);
    }

    @Override
    public E last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (E)this.elements.get(this.size() - 1);
    }

    @Override
    public E lower(E element) {
        int index = this.headIndex(element, false) - 1;
        return (E)(index == -1 ? null : this.elements.get(index));
    }

    @Override
    public E floor(E element) {
        int index = this.headIndex(element, true) - 1;
        return (E)(index == -1 ? null : this.elements.get(index));
    }

    @Override
    public E ceiling(E element) {
        int index = this.tailIndex(element, true);
        return (E)(index == this.size() ? null : this.elements.get(index));
    }

    @Override
    public E higher(E element) {
        int index = this.tailIndex(element, false);
        return (E)(index == this.size() ? null : this.elements.get(index));
    }

    @Override
    ImmutableSortedSet<E> headSetImpl(E toElement, boolean inclusive) {
        return this.getSubSet(0, this.headIndex(toElement, inclusive));
    }

    int headIndex(E toElement, boolean inclusive) {
        int index = Collections.binarySearch(this.elements, Preconditions.checkNotNull(toElement), this.comparator());
        if (index >= 0) {
            return inclusive ? index + 1 : index;
        }
        return ~index;
    }

    @Override
    ImmutableSortedSet<E> subSetImpl(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return this.tailSetImpl(fromElement, fromInclusive).headSetImpl(toElement, toInclusive);
    }

    @Override
    ImmutableSortedSet<E> tailSetImpl(E fromElement, boolean inclusive) {
        return this.getSubSet(this.tailIndex(fromElement, inclusive), this.size());
    }

    int tailIndex(E fromElement, boolean inclusive) {
        int index = Collections.binarySearch(this.elements, Preconditions.checkNotNull(fromElement), this.comparator());
        if (index >= 0) {
            return inclusive ? index : index + 1;
        }
        return ~index;
    }

    Comparator<io.logz.sender.java.lang.Object> unsafeComparator() {
        return this.comparator;
    }

    RegularImmutableSortedSet<E> getSubSet(int newFromIndex, int newToIndex) {
        if (newFromIndex == 0 && newToIndex == this.size()) {
            return this;
        }
        if (newFromIndex < newToIndex) {
            return new RegularImmutableSortedSet<E>(this.elements.subList(newFromIndex, newToIndex), this.comparator);
        }
        return RegularImmutableSortedSet.emptySet(this.comparator);
    }

    @Override
    int indexOf(@NullableDecl io.logz.sender.java.lang.Object target) {
        int position;
        if (target == null) {
            return -1;
        }
        try {
            position = Collections.binarySearch(this.elements, (io.logz.sender.java.lang.Object)target, this.unsafeComparator());
        }
        catch (ClassCastException e) {
            return -1;
        }
        return position >= 0 ? position : -1;
    }

    @Override
    ImmutableList<E> createAsList() {
        return this.size() <= 1 ? this.elements : new ImmutableSortedAsList<E>(this, this.elements);
    }

    @Override
    ImmutableSortedSet<E> createDescendingSet() {
        Comparator reversedOrder = Collections.reverseOrder((Comparator)this.comparator);
        return this.isEmpty() ? RegularImmutableSortedSet.emptySet(reversedOrder) : new RegularImmutableSortedSet<E>(this.elements.reverse(), reversedOrder);
    }
}

