/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.collect.Ordering;
import io.logz.sender.java.io.Serializable;
import io.logz.sender.java.lang.Iterable;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.util.Iterator;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible(serializable=true)
final class ReverseOrdering<T extends io.logz.sender.java.lang.Object>
extends Ordering<T>
implements Serializable {
    final Ordering<? super T> forwardOrder;
    private static final long serialVersionUID = 0L;

    ReverseOrdering(Ordering<? super T> forwardOrder) {
        this.forwardOrder = Preconditions.checkNotNull(forwardOrder);
    }

    @Override
    public int compare(T a, T b) {
        return this.forwardOrder.compare(b, a);
    }

    @Override
    public <S extends T> Ordering<S> reverse() {
        return this.forwardOrder;
    }

    @Override
    public <E extends T> E min(E a, E b) {
        return this.forwardOrder.max(a, b);
    }

    @Override
    public <E extends T> E min(E a, E b, E c, E ... rest) {
        return (E)this.forwardOrder.max((io.logz.sender.java.lang.Object)a, (io.logz.sender.java.lang.Object)b, (io.logz.sender.java.lang.Object)c, (io.logz.sender.java.lang.Object[])rest);
    }

    @Override
    public <E extends T> E min(Iterator<E> iterator) {
        return this.forwardOrder.max(iterator);
    }

    @Override
    public <E extends T> E min(Iterable<E> iterable) {
        return this.forwardOrder.max(iterable);
    }

    @Override
    public <E extends T> E max(E a, E b) {
        return this.forwardOrder.min(a, b);
    }

    @Override
    public <E extends T> E max(E a, E b, E c, E ... rest) {
        return (E)this.forwardOrder.min((io.logz.sender.java.lang.Object)a, (io.logz.sender.java.lang.Object)b, (io.logz.sender.java.lang.Object)c, (io.logz.sender.java.lang.Object[])rest);
    }

    @Override
    public <E extends T> E max(Iterator<E> iterator) {
        return this.forwardOrder.min(iterator);
    }

    @Override
    public <E extends T> E max(Iterable<E> iterable) {
        return this.forwardOrder.min(iterable);
    }

    public int hashCode() {
        return -this.forwardOrder.hashCode();
    }

    public boolean equals(@NullableDecl io.logz.sender.java.lang.Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ReverseOrdering) {
            ReverseOrdering that = (ReverseOrdering)object;
            return this.forwardOrder.equals(that.forwardOrder);
        }
        return false;
    }

    public String toString() {
        return new StringBuilder().append(this.forwardOrder).append((String)"io.logz.sender..reverse()").toString();
    }
}

