/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.collect.CollectPreconditions;
import io.logz.sender.com.google.common.collect.ImmutableBiMap;
import io.logz.sender.com.google.common.collect.ImmutableSet;
import io.logz.sender.com.google.common.collect.Maps;
import io.logz.sender.com.google.errorprone.annotations.concurrent.LazyInit;
import io.logz.sender.com.google.j2objc.annotations.RetainedWith;
import io.logz.sender.java.util.Map;
import io.logz.sender.java.util.function.BiConsumer;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible(serializable=true, emulated=true)
final class SingletonImmutableBiMap<K extends io.logz.sender.java.lang.Object, V extends io.logz.sender.java.lang.Object>
extends ImmutableBiMap<K, V> {
    final transient K singleKey;
    final transient V singleValue;
    @LazyInit
    @RetainedWith
    transient ImmutableBiMap<V, K> inverse;

    SingletonImmutableBiMap(K singleKey, V singleValue) {
        CollectPreconditions.checkEntryNotNull(singleKey, singleValue);
        this.singleKey = singleKey;
        this.singleValue = singleValue;
    }

    private SingletonImmutableBiMap(K singleKey, V singleValue, ImmutableBiMap<V, K> inverse) {
        this.singleKey = singleKey;
        this.singleValue = singleValue;
        this.inverse = inverse;
    }

    @Override
    public V get(@NullableDecl io.logz.sender.java.lang.Object key) {
        return this.singleKey.equals(key) ? (V)this.singleValue : null;
    }

    public int size() {
        return 1;
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        Preconditions.checkNotNull(action).accept(this.singleKey, this.singleValue);
    }

    @Override
    public boolean containsKey(@NullableDecl io.logz.sender.java.lang.Object key) {
        return this.singleKey.equals(key);
    }

    @Override
    public boolean containsValue(@NullableDecl io.logz.sender.java.lang.Object value) {
        return this.singleValue.equals(value);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return ImmutableSet.of(Maps.immutableEntry(this.singleKey, this.singleValue));
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return ImmutableSet.of(this.singleKey);
    }

    @Override
    public ImmutableBiMap<V, K> inverse() {
        ImmutableBiMap<V, K> result = this.inverse;
        if (result == null) {
            this.inverse = new SingletonImmutableBiMap<K, V>(this.singleValue, this.singleKey, this);
            return this.inverse;
        }
        return result;
    }
}

